/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.SASScope;
import com.sas.services.publish.RB;
import com.sas.text.Message;
import jakarta.activation.DataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;

@SASScope
public class StreamMailDataSource
implements DataSource {
    private InputStream _stream = null;
    private String _contentType;
    private String _name;
    private File _tempFile = null;

    public StreamMailDataSource(InputStream is, String contentType, String name) {
        this._contentType = contentType;
        this._name = name;
        this._stream = is;
    }

    public InputStream getInputStream() throws IOException {
        FileOutputStream fos = null;
        FileInputStream stream = null;
        try {
            if (this._tempFile == null) {
                int len;
                this._tempFile = File.createTempFile("Pubdsrc", ".bin");
                this._tempFile.deleteOnExit();
                fos = new FileOutputStream(this._tempFile);
                byte[] bb = new byte[2048];
                while ((len = this._stream.read(bb)) != -1) {
                    fos.write(bb, 0, len);
                }
                fos.close();
                this._stream.close();
            }
            stream = new FileInputStream(this._tempFile);
        }
        catch (IOException e) {
            throw new IOException(Message.format((ResourceBundle)RB.getResources(), (String)"StreamMailDataSource.ioErr.ex.fmt.txt", (Object)e.getMessage()));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
        }
        return stream;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException(RB.getStringResource("PublishCommon.notSupportedSQLException.ex.txt"));
    }

    public String getContentType() {
        if (this._contentType == null) {
            return "application/octet-stream";
        }
        return this._contentType;
    }

    public String getName() {
        return this._name;
    }

    protected void finalize() throws Throwable {
        if (this._tempFile != null) {
            String tname = this._tempFile.getPath();
            boolean b = this._tempFile.delete();
            if (!b) {
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"StreamMailDataSource.delErr.fmt.txt", (Object)tname, (Object)this._name));
            }
            this._tempFile = null;
        }
        super.finalize();
    }
}

