/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.SASScope;
import com.sas.services.publish.Column;
import com.sas.services.publish.RB;
import com.sas.services.publish.ServiceResultSetMetaDataInterface;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

@SASScope
class ServiceResultSetMetaData
implements Serializable,
ServiceResultSetMetaDataInterface {
    private static final long serialVersionUID = 228216120303875184L;
    private Column[] _columns;
    private int _numColumns;
    private int _numberOfRows;

    ServiceResultSetMetaData(Column[] columns, int numcolumns) throws SQLException {
        this._columns = columns;
        this._numColumns = numcolumns;
    }

    ServiceResultSetMetaData(Column[] columns, int numcolumns, int numRows) throws SQLException {
        this(columns, numcolumns);
        this._numberOfRows = numRows;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this._numColumns;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return true;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return 2;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return this._columns[column - 1].getLength();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return this._columns[column - 1].getLabel();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return this._columns[column - 1].getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return this._columns[column - 1].getFormatDecimal();
    }

    @Override
    public int getScale(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        int type = this._columns[column - 1].getSQLType();
        return type;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return "";
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int type = this.getColumnType(column);
        Object columnObject = null;
        if (type != 12 && type != 1 && type != -1) {
            switch (type) {
                case 91: {
                    columnObject = new Date(0L);
                    break;
                }
                case 92: {
                    columnObject = new Time(0L);
                    break;
                }
                case 93: {
                    columnObject = new Timestamp(0L);
                    break;
                }
                case -7: {
                    columnObject = Boolean.TRUE;
                    break;
                }
                case 4: 
                case 5: {
                    columnObject = 0;
                }
                default: {
                    columnObject = 0.0;
                    break;
                }
            }
        } else {
            columnObject = "";
        }
        return columnObject.getClass().getName();
    }

    @Override
    public int getFormatFieldLength(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return this._columns[column - 1].getFormatFieldLength();
    }

    @Override
    public String getFormatName(int column) throws SQLException {
        if (column < 1 || column > this._numColumns) {
            throw new SQLException(RB.getStringResource("ServiceResultSetMetaData.invalidColumnValueSQLException.ex.txt"));
        }
        return this._columns[column - 1].getFormat();
    }

    @Override
    public int getRowCount() throws SQLException {
        return this._numberOfRows;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }
}

