/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.services.TransportException;
import com.sas.services.publish.AbstractEntry;
import com.sas.services.publish.BinaryFileEntry;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.EventDataInterface;
import com.sas.services.publish.HTMLEntry;
import com.sas.services.publish.LibraryMemberEntryInterface;
import com.sas.services.publish.RB;
import com.sas.services.publish.ResultPackageEventBuilder;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TextFileEntry;
import com.sas.services.publish.ViewerEntry;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ResultPackage
extends AbstractEntry
implements ResultPackageInterface {
    private String _abstract;
    private boolean _isNested = false;
    private ArrayList _entries = new ArrayList();
    private long _expiration;
    private String _nestedName = null;

    public ResultPackage() throws RemoteException {
        super(ResultPackage.class);
    }

    @Override
    public Object hasInputStream() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return null;
    }

    @Override
    public InputStream getInputStream(Object streamID) throws IllegalStateException {
        this.throwExceptionIfClosed();
        return null;
    }

    @Override
    public InputStream getInputStream() throws IllegalStateException {
        this.throwExceptionIfClosed();
        return null;
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(Object streamID) throws IOException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return null;
    }

    @Override
    public String getAbstract() throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._abstract;
    }

    @Override
    public void setAbstract(String pkgAbstract) throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ResultPackage.readOnly.ex.txt"));
        }
        this._abstract = pkgAbstract;
    }

    @Override
    public long getExpirationDateTime() throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._expiration;
    }

    @Override
    public void setExpirationDateTime(long expiration) throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ResultPackage.readOnly.ex.txt"));
        }
        this._expiration = expiration;
    }

    @Override
    public long getCreationDateTime() throws IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        throw new IllegalStateException(RB.getStringResource("ResultPackage.creationIllegalStateException.ex.txt"));
    }

    @Override
    public String getName() throws IllegalStateException, TransportException, RemoteException {
        this.throwExceptionIfClosed();
        return this._nestedName;
    }

    @Override
    public void setName(String name) throws IllegalStateException, RemoteException {
        this.throwExceptionIfClosed();
        this._nestedName = name;
    }

    @Override
    public EntryInterface getEntry(int index) throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return (EntryInterface)this._entries.get(index);
    }

    @Override
    public EntryInterface[] getEntries() throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        EntryInterface[] entries = new EntryInterface[this._entries.size()];
        Iterator itor = this._entries.iterator();
        int i = 0;
        while (itor.hasNext()) {
            entries[i++] = (EntryInterface)itor.next();
        }
        return entries;
    }

    @Override
    public void addEntry(EntryInterface entry) throws RemoteException, IllegalStateException, IllegalArgumentException {
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ResultPackage.readOnly.ex.txt"));
        }
        if (entry instanceof LibraryMemberEntryInterface) {
            throw new IllegalArgumentException(RB.getStringResource("ResultPackage.libraryMemberIllegalArgumentException.ex.txt"));
        }
        this._entries.add(entry);
    }

    @Override
    public boolean isNested() throws RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        return this._isNested;
    }

    @Override
    public void close() throws RemoteException, IllegalStateException, TransportException {
        EntryInterface[] entries = this.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            EntryInterface entry = entries[i];
            if (entry instanceof BinaryFileEntry) {
                ((BinaryFileEntry)entry).closeEntry();
            }
            if (entry instanceof TextFileEntry) {
                ((TextFileEntry)entry).closeEntry();
            }
            if (entry instanceof ViewerEntry) {
                ((ViewerEntry)entry).closeEntry();
            }
            if (!(entry instanceof HTMLEntry)) continue;
            ((HTMLEntry)entry).closeEntry();
        }
        this._entries.clear();
        this.setClosed(true);
    }

    @Override
    public void delete() throws TransportException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (!this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("ResultPackage.deleteIllegalStateException.ex.txt"));
        }
        if (this.isNested()) {
            throw new IllegalStateException(RB.getStringResource("ResultPackage.nestedDeleteIllegalStateException.ex.txt"));
        }
    }

    @Override
    public EventDataInterface getEventData() throws TransportException, RemoteException, IllegalStateException {
        this.throwExceptionIfClosed();
        EventDataInterface eventData = null;
        ResultPackageEventBuilder builder = new ResultPackageEventBuilder();
        eventData = builder.buildEvent(this, null, null, null, null);
        return eventData;
    }

    @Override
    public EntryInterface getEntry(String uniqueId) throws IllegalStateException, RemoteException, TransportException {
        this.throwExceptionIfClosed();
        return this.findEntry(uniqueId, null);
    }

    private EntryInterface findEntry(String uniqueId, ResultPackageInterface rpkg) throws TransportException, RemoteException {
        Object[] entryList = null;
        EntryInterface foundEntry = null;
        entryList = rpkg == null ? this._entries.toArray() : rpkg.getEntries();
        for (int i = 0; i < entryList.length && foundEntry == null; ++i) {
            EntryInterface entry = (EntryInterface)entryList[i];
            String id = entry.getEntityKey();
            if (id.equals(uniqueId)) {
                foundEntry = entry;
                continue;
            }
            if (!(entry instanceof ResultPackageInterface)) continue;
            foundEntry = this.findEntry(uniqueId, rpkg);
        }
        return foundEntry;
    }
}

