/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.TransportException;
import com.sas.services.publish.RemoteResultSetInterface;
import com.sas.services.publish.ResultSetProviderInterface;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class RemoteResultSet
extends UnicastRemoteObject
implements RemoteResultSetInterface {
    private transient ResultSet _resultSet;

    public RemoteResultSet() throws RemoteException {
        this(RemoteResultSet.class);
    }

    protected RemoteResultSet(Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
    }

    public RemoteResultSet(ResultSet resultSet) throws RemoteException {
        this(RemoteResultSet.class);
        this._resultSet = resultSet;
    }

    @Override
    public synchronized void close() throws SQLException, RemoteException {
        this._resultSet.close();
    }

    @Override
    public synchronized Date getDate(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getDate(columnIndex);
    }

    @Override
    public synchronized boolean next() throws SQLException, RemoteException {
        return this._resultSet.next();
    }

    @Override
    public synchronized String getString(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getString(columnIndex);
    }

    @Override
    public synchronized String getString(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getString(columnName);
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException, RemoteException {
        return this._resultSet.getMetaData();
    }

    @Override
    public synchronized boolean wasNull() throws SQLException, RemoteException {
        return this._resultSet.wasNull();
    }

    @Override
    public synchronized boolean getBoolean(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getBoolean(columnIndex);
    }

    @Override
    public synchronized byte getByte(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getByte(columnIndex);
    }

    @Override
    public synchronized short getShort(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getShort(columnIndex);
    }

    @Override
    public synchronized int getInt(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getInt(columnIndex);
    }

    @Override
    public synchronized long getLong(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getLong(columnIndex);
    }

    @Override
    public synchronized double getDouble(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getDouble(columnIndex);
    }

    @Override
    public synchronized float getFloat(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getFloat(columnIndex);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException, RemoteException {
        return this._resultSet.getBigDecimal(columnIndex);
    }

    @Override
    public synchronized byte[] getBytes(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getBytes(columnIndex);
    }

    @Override
    public synchronized Time getTime(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getTime(columnIndex);
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getTimestamp(columnIndex);
    }

    @Override
    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getAsciiStream(columnIndex);
    }

    @Override
    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getUnicodeStream(columnIndex);
    }

    @Override
    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getBinaryStream(columnIndex);
    }

    @Override
    public synchronized boolean getBoolean(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getBoolean(columnName);
    }

    @Override
    public synchronized byte getByte(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getByte(columnName);
    }

    @Override
    public synchronized short getShort(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getShort(columnName);
    }

    @Override
    public synchronized int getInt(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getInt(columnName);
    }

    @Override
    public synchronized long getLong(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getLong(columnName);
    }

    @Override
    public synchronized double getDouble(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getDouble(columnName);
    }

    @Override
    public synchronized float getFloat(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getFloat(columnName);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String columnName, int scale) throws SQLException, RemoteException {
        return this._resultSet.getBigDecimal(columnName);
    }

    @Override
    public synchronized byte[] getBytes(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getBytes(columnName);
    }

    @Override
    public synchronized Date getDate(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getDate(columnName);
    }

    @Override
    public synchronized Time getTime(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getTime(columnName);
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getTimestamp(columnName);
    }

    @Override
    public synchronized InputStream getAsciiStream(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getAsciiStream(columnName);
    }

    @Override
    public synchronized InputStream getUnicodeStream(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getUnicodeStream(columnName);
    }

    @Override
    public synchronized InputStream getBinaryStream(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getBinaryStream(columnName);
    }

    public synchronized SQLWarning getSQLWarnings() throws SQLException, RemoteException {
        return this._resultSet.getWarnings();
    }

    @Override
    public synchronized void clearWarnings() throws SQLException, RemoteException {
        this._resultSet.clearWarnings();
    }

    @Override
    public synchronized String getCursorName() throws SQLException, RemoteException {
        return this._resultSet.getCursorName();
    }

    @Override
    public synchronized Object getObject(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getObject(columnIndex);
    }

    @Override
    public synchronized Object getObject(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getObject(columnName);
    }

    @Override
    public synchronized int findColumn(String columnName) throws SQLException, RemoteException {
        return this._resultSet.findColumn(columnName);
    }

    @Override
    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getCharacterStream(columnIndex);
    }

    @Override
    public synchronized Reader getCharacterStream(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getCharacterStream(columnName);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException, RemoteException {
        return this._resultSet.getBigDecimal(columnIndex);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String columnName) throws SQLException, RemoteException {
        return this._resultSet.getBigDecimal(columnName);
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException, RemoteException {
        return this._resultSet.isBeforeFirst();
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException, RemoteException {
        return this._resultSet.isAfterLast();
    }

    @Override
    public synchronized boolean isFirst() throws SQLException, RemoteException {
        return this._resultSet.isFirst();
    }

    @Override
    public synchronized boolean isLast() throws SQLException, RemoteException {
        return this._resultSet.isLast();
    }

    @Override
    public synchronized void beforeFirst() throws SQLException, RemoteException {
        this._resultSet.beforeFirst();
    }

    @Override
    public synchronized void afterLast() throws SQLException, RemoteException {
        this._resultSet.afterLast();
    }

    @Override
    public synchronized boolean first() throws SQLException, RemoteException {
        return this._resultSet.first();
    }

    @Override
    public synchronized boolean last() throws SQLException, RemoteException {
        return this._resultSet.last();
    }

    @Override
    public synchronized int getRow() throws SQLException, RemoteException {
        return this._resultSet.getRow();
    }

    @Override
    public synchronized boolean absolute(int row) throws SQLException, RemoteException {
        return this._resultSet.absolute(row);
    }

    @Override
    public synchronized boolean relative(int rows) throws SQLException, RemoteException {
        return this._resultSet.relative(rows);
    }

    @Override
    public synchronized boolean previous() throws SQLException, RemoteException {
        return this._resultSet.previous();
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException, RemoteException {
        this._resultSet.setFetchDirection(direction);
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException, RemoteException {
        return this._resultSet.getFetchDirection();
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException, RemoteException {
        this._resultSet.setFetchSize(rows);
    }

    @Override
    public synchronized int getFetchSize() throws SQLException, RemoteException {
        return this._resultSet.getFetchSize();
    }

    @Override
    public synchronized int getType() throws SQLException, RemoteException {
        return this._resultSet.getType();
    }

    @Override
    public synchronized int getConcurrency() throws SQLException, RemoteException {
        return this._resultSet.getConcurrency();
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException, RemoteException {
        return this._resultSet.rowUpdated();
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException, RemoteException {
        return this._resultSet.rowInserted();
    }

    @Override
    public synchronized boolean rowDeleted() throws SQLException, RemoteException {
        return this._resultSet.rowDeleted();
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException, RemoteException {
        this._resultSet.updateNull(columnIndex);
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException, RemoteException {
        this._resultSet.updateBoolean(columnIndex, x);
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException, RemoteException {
        this._resultSet.updateShort(columnIndex, x);
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException, RemoteException {
        this._resultSet.updateByte(columnIndex, x);
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException, RemoteException {
        this._resultSet.updateInt(columnIndex, x);
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException, RemoteException {
        this._resultSet.updateLong(columnIndex, x);
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException, RemoteException {
        this._resultSet.updateFloat(columnIndex, x);
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException, RemoteException {
        this._resultSet.updateDouble(columnIndex, x);
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException, RemoteException {
        this._resultSet.updateBigDecimal(columnIndex, x);
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException, RemoteException {
        this._resultSet.updateString(columnIndex, x);
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException, RemoteException {
        this._resultSet.updateBytes(columnIndex, x);
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException, RemoteException {
        this._resultSet.updateDate(columnIndex, x);
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException, RemoteException {
        this._resultSet.updateTime(columnIndex, x);
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException, RemoteException {
        this._resultSet.updateTimestamp(columnIndex, x);
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException, RemoteException {
        this._resultSet.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException, RemoteException {
        this._resultSet.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException, RemoteException {
        this._resultSet.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException, RemoteException {
        this._resultSet.updateObject(columnIndex, x, scale);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException, RemoteException {
        this._resultSet.updateObject(columnIndex, x);
    }

    @Override
    public synchronized void updateNull(String columnName) throws SQLException, RemoteException {
        this._resultSet.updateNull(columnName);
    }

    @Override
    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException, RemoteException {
        this._resultSet.updateBoolean(columnName, x);
    }

    @Override
    public synchronized void updateShort(String columnName, short x) throws SQLException, RemoteException {
        this._resultSet.updateShort(columnName, x);
    }

    @Override
    public synchronized void updateByte(String columnName, byte x) throws SQLException, RemoteException {
        this._resultSet.updateByte(columnName, x);
    }

    @Override
    public synchronized void updateInt(String columnName, int x) throws SQLException, RemoteException {
        this._resultSet.updateInt(columnName, x);
    }

    @Override
    public synchronized void updateLong(String columnName, long x) throws SQLException, RemoteException {
        this._resultSet.updateLong(columnName, x);
    }

    @Override
    public synchronized void updateFloat(String columnName, float x) throws SQLException, RemoteException {
        this._resultSet.updateFloat(columnName, x);
    }

    @Override
    public synchronized void updateDouble(String columnName, double x) throws SQLException, RemoteException {
        this._resultSet.updateDouble(columnName, x);
    }

    @Override
    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException, RemoteException {
        this._resultSet.updateBigDecimal(columnName, x);
    }

    @Override
    public synchronized void updateString(String columnName, String x) throws SQLException, RemoteException {
        this._resultSet.updateString(columnName, x);
    }

    @Override
    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException, RemoteException {
        this._resultSet.updateBytes(columnName, x);
    }

    @Override
    public synchronized void updateDate(String columnName, Date x) throws SQLException, RemoteException {
        this._resultSet.updateDate(columnName, x);
    }

    @Override
    public synchronized void updateTime(String columnName, Time x) throws SQLException, RemoteException {
        this._resultSet.updateTime(columnName, x);
    }

    @Override
    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException, RemoteException {
        this._resultSet.updateTimestamp(columnName, x);
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException, RemoteException {
        this._resultSet.updateAsciiStream(columnName, x, length);
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException, RemoteException {
        this._resultSet.updateBinaryStream(columnName, x, length);
    }

    @Override
    public synchronized void updateCharacterStream(String columnName, Reader x, int length) throws SQLException, RemoteException {
        this._resultSet.updateCharacterStream(columnName, x, length);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException, RemoteException {
        this._resultSet.updateObject(columnName, x, scale);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x) throws SQLException, RemoteException {
        this._resultSet.updateObject(columnName, x);
    }

    @Override
    public synchronized void insertRow() throws SQLException, RemoteException {
        this._resultSet.insertRow();
    }

    @Override
    public synchronized void updateRow() throws SQLException, RemoteException {
        this._resultSet.updateRow();
    }

    @Override
    public synchronized void deleteRow() throws SQLException, RemoteException {
        this._resultSet.deleteRow();
    }

    @Override
    public synchronized void refreshRow() throws SQLException, RemoteException {
        this._resultSet.refreshRow();
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException, RemoteException {
        this._resultSet.cancelRowUpdates();
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException, RemoteException {
        this._resultSet.moveToInsertRow();
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException, RemoteException {
    }

    @Override
    public synchronized Statement getStatement() throws SQLException, RemoteException {
        return this._resultSet.getStatement();
    }

    @Override
    public synchronized Ref getRef(int i) throws SQLException, RemoteException {
        return this._resultSet.getRef(i);
    }

    @Override
    public synchronized Blob getBlob(int i) throws SQLException, RemoteException {
        return this._resultSet.getBlob(i);
    }

    @Override
    public synchronized Clob getClob(int i) throws SQLException, RemoteException {
        return this._resultSet.getClob(i);
    }

    @Override
    public synchronized Array getArray(int i) throws SQLException, RemoteException {
        return this._resultSet.getArray(i);
    }

    @Override
    public synchronized Ref getRef(String colName) throws SQLException, RemoteException {
        return this._resultSet.getRef(colName);
    }

    @Override
    public synchronized Blob getBlob(String colName) throws SQLException, RemoteException {
        return this._resultSet.getBlob(colName);
    }

    @Override
    public synchronized Clob getClob(String colName) throws SQLException, RemoteException {
        return this._resultSet.getClob(colName);
    }

    @Override
    public synchronized Array getArray(String colName) throws SQLException, RemoteException {
        return this._resultSet.getArray(colName);
    }

    @Override
    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException, RemoteException {
        return this._resultSet.getDate(columnIndex, cal);
    }

    @Override
    public synchronized Date getDate(String columnName, Calendar cal) throws SQLException, RemoteException {
        return this._resultSet.getDate(columnName, cal);
    }

    @Override
    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException, RemoteException {
        return this._resultSet.getTime(columnIndex, cal);
    }

    @Override
    public synchronized Time getTime(String columnName, Calendar cal) throws SQLException, RemoteException {
        return this._resultSet.getTime(columnName, cal);
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException, RemoteException {
        return this._resultSet.getTimestamp(columnIndex, cal);
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException, RemoteException {
        return this._resultSet.getTimestamp(columnName, cal);
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException, RemoteException {
        return this._resultSet.getWarnings();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this._resultSet.getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this._resultSet.getURL(columnName);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this._resultSet.updateRef(columnIndex, x);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this._resultSet.updateRef(columnName, x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this._resultSet.updateBlob(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this._resultSet.updateBlob(columnName, x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this._resultSet.updateClob(columnIndex, x);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this._resultSet.updateClob(columnName, x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this._resultSet.updateArray(columnIndex, x);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this._resultSet.updateArray(columnName, x);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._resultSet.getHoldability();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this._resultSet.getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this._resultSet.getNCharacterStream(columnLabel);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this._resultSet.getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this._resultSet.getNClob(columnLabel);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this._resultSet.getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this._resultSet.getNString(columnLabel);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this._resultSet.getObject(columnIndex, map);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this._resultSet.getObject(columnLabel, map);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this._resultSet.getRowId(columnIndex);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this._resultSet.getRowId(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this._resultSet.getSQLXML(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this._resultSet.getSQLXML(columnLabel);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._resultSet.isClosed();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this._resultSet.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this._resultSet.unwrap(iface);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this._resultSet.updateAsciiStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this._resultSet.updateAsciiStream(columnLabel, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this._resultSet.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this._resultSet.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this._resultSet.updateBinaryStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this._resultSet.updateBinaryStream(columnLabel, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this._resultSet.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this._resultSet.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this._resultSet.updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this._resultSet.updateBlob(columnLabel, inputStream);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this._resultSet.updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this._resultSet.updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this._resultSet.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this._resultSet.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this._resultSet.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this._resultSet.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this._resultSet.updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this._resultSet.updateClob(columnLabel, reader);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this._resultSet.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this._resultSet.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this._resultSet.updateNCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this._resultSet.updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this._resultSet.updateNCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this._resultSet.updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        this._resultSet.updateNClob(columnIndex, clob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        this._resultSet.updateNClob(columnLabel, clob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this._resultSet.updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this._resultSet.updateNClob(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this._resultSet.updateNClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this._resultSet.updateNClob(columnLabel, reader, length);
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        this._resultSet.updateNString(columnIndex, string);
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        this._resultSet.updateNString(columnLabel, string);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this._resultSet.updateRowId(columnIndex, x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this._resultSet.updateRowId(columnLabel, x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this._resultSet.updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this._resultSet.updateSQLXML(columnLabel, xmlObject);
    }

    public static ResultSet getResultSet(ResultSetProviderInterface provider) throws TransportException, RemoteException {
        ResultSet resultSet = null;
        try {
            provider.hasResultSet();
            resultSet = provider.getResultSet();
        }
        catch (RemoteException e) {
            RemoteResultSetInterface rrsi = provider.getRemoteResultSet();
            resultSet = new Proxy(rrsi);
        }
        return resultSet;
    }

    @SASScope
    private static class Proxy
    implements ResultSet {
        private transient RemoteResultSetInterface rsi;

        Proxy(RemoteResultSetInterface rsi) {
            this.rsi = rsi;
        }

        @Override
        public synchronized boolean next() throws SQLException {
            boolean b;
            try {
                b = this.rsi.next();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized void close() throws SQLException {
            try {
                this.rsi.close();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized String getString(int column) throws SQLException {
            String s = null;
            try {
                s = this.rsi.getString(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return s;
        }

        @Override
        public synchronized int getInt(int column) throws SQLException {
            int i;
            try {
                i = this.rsi.getInt(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return i;
        }

        @Override
        public synchronized double getDouble(int column) throws SQLException {
            double d;
            try {
                d = this.rsi.getDouble(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return d;
        }

        @Override
        public synchronized Date getDate(int column) throws SQLException {
            Date date = null;
            try {
                date = this.rsi.getDate(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return date;
        }

        @Override
        public synchronized Time getTime(int column) throws SQLException {
            Time time = null;
            try {
                time = this.rsi.getTime(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return time;
        }

        @Override
        public synchronized Timestamp getTimestamp(int column) throws SQLException {
            Timestamp ts = null;
            try {
                ts = this.rsi.getTimestamp(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return ts;
        }

        @Override
        public synchronized ResultSetMetaData getMetaData() throws SQLException {
            ResultSetMetaData meta;
            try {
                meta = this.rsi.getMetaData();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return meta;
        }

        @Override
        public synchronized Object getObject(int column) throws SQLException {
            Object o = null;
            try {
                o = this.rsi.getObject(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return o;
        }

        @Override
        public synchronized Object getObject(String columnName) throws SQLException {
            Object o = null;
            try {
                o = this.rsi.getObject(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return o;
        }

        @Override
        public synchronized boolean wasNull() throws SQLException {
            boolean b;
            try {
                b = this.rsi.wasNull();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized boolean getBoolean(int column) throws SQLException {
            boolean b = false;
            try {
                b = this.rsi.getBoolean(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized byte getByte(int column) throws SQLException {
            byte b;
            try {
                b = this.rsi.getByte(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized short getShort(int column) throws SQLException {
            short s;
            try {
                s = this.rsi.getShort(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return s;
        }

        @Override
        public synchronized long getLong(int column) throws SQLException {
            long l;
            try {
                l = this.rsi.getLong(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return l;
        }

        @Override
        public synchronized float getFloat(int column) throws SQLException {
            float f;
            try {
                f = this.rsi.getFloat(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return f;
        }

        @Override
        public synchronized BigDecimal getBigDecimal(int column) throws SQLException {
            BigDecimal d;
            try {
                d = this.rsi.getBigDecimal(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return d;
        }

        @Override
        public synchronized BigDecimal getBigDecimal(int column, int scale) throws SQLException {
            BigDecimal d;
            try {
                d = this.rsi.getBigDecimal(column, scale);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return d;
        }

        @Override
        public synchronized byte[] getBytes(int column) throws SQLException {
            byte[] b = null;
            try {
                b = this.rsi.getBytes(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized InputStream getAsciiStream(int column) throws SQLException {
            InputStream stream = null;
            try {
                stream = this.rsi.getAsciiStream(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return stream;
        }

        @Override
        public synchronized InputStream getUnicodeStream(int column) throws SQLException {
            InputStream stream = null;
            try {
                stream = this.rsi.getUnicodeStream(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return stream;
        }

        @Override
        public synchronized InputStream getBinaryStream(int column) throws SQLException {
            InputStream stream = null;
            try {
                stream = this.rsi.getBinaryStream(column);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return stream;
        }

        @Override
        public synchronized String getString(String columnName) throws SQLException {
            String s = null;
            try {
                s = this.rsi.getString(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return s;
        }

        @Override
        public synchronized boolean getBoolean(String columnName) throws SQLException {
            boolean b;
            try {
                b = this.rsi.getBoolean(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized byte getByte(String columnName) throws SQLException {
            byte b;
            try {
                b = this.rsi.getByte(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized short getShort(String columnName) throws SQLException {
            short s;
            try {
                s = this.rsi.getShort(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return s;
        }

        @Override
        public synchronized int getInt(String columnName) throws SQLException {
            int i;
            try {
                i = this.rsi.getInt(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return i;
        }

        @Override
        public synchronized long getLong(String columnName) throws SQLException {
            long l;
            try {
                l = this.rsi.getLong(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return l;
        }

        @Override
        public synchronized float getFloat(String columnName) throws SQLException {
            float f;
            try {
                f = this.rsi.getFloat(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return f;
        }

        @Override
        public synchronized double getDouble(String columnName) throws SQLException {
            double d;
            try {
                d = this.rsi.getDouble(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return d;
        }

        @Override
        public synchronized BigDecimal getBigDecimal(String columnName) throws SQLException {
            BigDecimal d;
            try {
                d = this.rsi.getBigDecimal(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return d;
        }

        @Override
        public synchronized BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
            BigDecimal d;
            try {
                d = this.rsi.getBigDecimal(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return d;
        }

        @Override
        public synchronized byte[] getBytes(String columnName) throws SQLException {
            byte[] b;
            try {
                b = this.rsi.getBytes(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized Date getDate(String columnName) throws SQLException {
            Date date;
            try {
                date = this.rsi.getDate(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return date;
        }

        @Override
        public synchronized Time getTime(String columnName) throws SQLException {
            Time time;
            try {
                time = this.rsi.getTime(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return time;
        }

        @Override
        public synchronized Timestamp getTimestamp(String columnName) throws SQLException {
            Timestamp ts;
            try {
                ts = this.rsi.getTimestamp(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return ts;
        }

        @Override
        public synchronized InputStream getAsciiStream(String columnName) throws SQLException {
            InputStream stream;
            try {
                stream = this.rsi.getAsciiStream(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return stream;
        }

        @Override
        public synchronized InputStream getUnicodeStream(String columnName) throws SQLException {
            InputStream stream;
            try {
                stream = this.rsi.getUnicodeStream(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return stream;
        }

        @Override
        public synchronized InputStream getBinaryStream(String columnName) throws SQLException {
            InputStream stream;
            try {
                stream = this.rsi.getBinaryStream(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return stream;
        }

        @Override
        public synchronized String getCursorName() throws SQLException {
            String s;
            try {
                s = this.rsi.getCursorName();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return s;
        }

        @Override
        public synchronized SQLWarning getWarnings() throws SQLException {
            SQLWarning warning;
            try {
                warning = this.rsi.getWarnings();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return warning;
        }

        @Override
        public synchronized void clearWarnings() throws SQLException {
            try {
                this.rsi.clearWarnings();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized int findColumn(String columnName) throws SQLException {
            int i;
            try {
                i = this.rsi.findColumn(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return i;
        }

        @Override
        public boolean absolute(int rowOffset) throws SQLException {
            boolean b;
            try {
                b = this.rsi.absolute(rowOffset);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
            Reader reader;
            try {
                reader = this.rsi.getCharacterStream(columnIndex);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return reader;
        }

        @Override
        public synchronized Reader getCharacterStream(String columnName) throws SQLException {
            Reader reader;
            try {
                reader = this.rsi.getCharacterStream(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return reader;
        }

        @Override
        public synchronized boolean isBeforeFirst() throws SQLException {
            boolean b;
            try {
                b = this.rsi.isBeforeFirst();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized boolean isAfterLast() throws SQLException {
            boolean b;
            try {
                b = this.rsi.isAfterLast();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized boolean isFirst() throws SQLException {
            boolean b;
            try {
                b = this.rsi.isFirst();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized boolean isLast() throws SQLException {
            boolean b;
            try {
                b = this.rsi.isLast();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized void beforeFirst() throws SQLException {
            try {
                this.rsi.beforeFirst();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void afterLast() throws SQLException {
            try {
                this.rsi.afterLast();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized boolean first() throws SQLException {
            boolean b;
            try {
                b = this.rsi.first();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized boolean last() throws SQLException {
            boolean b;
            try {
                b = this.rsi.last();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized int getRow() throws SQLException {
            int i;
            try {
                i = this.rsi.getRow();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return i;
        }

        @Override
        public synchronized boolean relative(int rowOffset) throws SQLException {
            boolean b;
            try {
                b = this.rsi.relative(rowOffset);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized boolean previous() throws SQLException {
            boolean b;
            try {
                b = this.rsi.previous();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized void setFetchDirection(int direction) throws SQLException {
            try {
                this.rsi.setFetchDirection(direction);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized int getFetchDirection() throws SQLException {
            int i;
            try {
                i = this.rsi.getFetchDirection();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return i;
        }

        @Override
        public synchronized void setFetchSize(int rows) throws SQLException {
            try {
                this.rsi.setFetchSize(rows);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized int getFetchSize() throws SQLException {
            int i;
            try {
                i = this.rsi.getFetchSize();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return i;
        }

        @Override
        public synchronized int getType() throws SQLException {
            int i;
            try {
                i = this.rsi.getType();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return i;
        }

        @Override
        public synchronized int getConcurrency() throws SQLException {
            int i;
            try {
                i = this.rsi.getConcurrency();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return i;
        }

        @Override
        public synchronized boolean rowUpdated() throws SQLException {
            boolean b;
            try {
                b = this.rsi.rowUpdated();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized boolean rowInserted() throws SQLException {
            boolean b;
            try {
                b = this.rsi.rowUpdated();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized boolean rowDeleted() throws SQLException {
            boolean b;
            try {
                b = this.rsi.rowDeleted();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return b;
        }

        @Override
        public synchronized void updateNull(int columnIndex) throws SQLException {
            try {
                this.rsi.updateNull(columnIndex);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
            try {
                this.rsi.updateBoolean(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
            try {
                this.rsi.updateByte(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateShort(int columnIndex, short x) throws SQLException {
            try {
                this.rsi.updateShort(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateInt(int columnIndex, int x) throws SQLException {
            try {
                this.rsi.updateInt(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateLong(int columnIndex, long x) throws SQLException {
            try {
                this.rsi.updateLong(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
            try {
                this.rsi.updateFloat(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
            try {
                this.rsi.updateDouble(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
            try {
                this.rsi.updateBigDecimal(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateString(int columnIndex, String x) throws SQLException {
            try {
                this.rsi.updateString(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
            try {
                this.rsi.updateBytes(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
            try {
                this.rsi.updateDate(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
            try {
                this.rsi.updateTime(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
            try {
                this.rsi.updateTimestamp(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
            try {
                this.rsi.updateAsciiStream(columnIndex, x, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
            try {
                this.rsi.updateBinaryStream(columnIndex, x, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
            try {
                this.rsi.updateCharacterStream(columnIndex, x, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
            try {
                this.rsi.updateObject(columnIndex, x, scale);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
            try {
                this.rsi.updateObject(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateNull(String columnName) throws SQLException {
            try {
                this.rsi.updateNull(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
            try {
                this.rsi.updateBoolean(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateByte(String columnName, byte x) throws SQLException {
            try {
                this.rsi.updateByte(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateShort(String columnName, short x) throws SQLException {
            try {
                this.rsi.updateShort(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateInt(String columnName, int x) throws SQLException {
            try {
                this.rsi.updateInt(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateLong(String columnName, long x) throws SQLException {
            try {
                this.rsi.updateLong(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateFloat(String columnName, float x) throws SQLException {
            try {
                this.rsi.updateFloat(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateDouble(String columnName, double x) throws SQLException {
            try {
                this.rsi.updateDouble(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
            try {
                this.rsi.updateBigDecimal(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateString(String columnName, String x) throws SQLException {
            try {
                this.rsi.updateString(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
            try {
                this.rsi.updateBytes(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateDate(String columnName, Date x) throws SQLException {
            try {
                this.rsi.updateDate(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateTime(String columnName, Time x) throws SQLException {
            try {
                this.rsi.updateTime(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
            try {
                this.rsi.updateTimestamp(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
            try {
                this.rsi.updateAsciiStream(columnName, x, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
            try {
                this.rsi.updateBinaryStream(columnName, x, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
            try {
                this.rsi.updateCharacterStream(columnName, reader, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
            try {
                this.rsi.updateObject(columnName, x, scale);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateObject(String columnName, Object x) throws SQLException {
            try {
                this.rsi.updateObject(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void insertRow() throws SQLException {
            try {
                this.rsi.insertRow();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateRow() throws SQLException {
            try {
                this.rsi.updateRow();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void deleteRow() throws SQLException {
            try {
                this.rsi.deleteRow();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void refreshRow() throws SQLException {
            try {
                this.rsi.refreshRow();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void cancelRowUpdates() throws SQLException {
            try {
                this.rsi.cancelRowUpdates();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void moveToInsertRow() throws SQLException {
            try {
                this.rsi.moveToInsertRow();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void moveToCurrentRow() throws SQLException {
            try {
                this.rsi.moveToCurrentRow();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized Blob getBlob(int i) throws SQLException {
            Blob blob;
            try {
                blob = this.rsi.getBlob(i);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return blob;
        }

        @Override
        public synchronized Clob getClob(int i) throws SQLException {
            Clob clob;
            try {
                clob = this.rsi.getClob(i);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return clob;
        }

        @Override
        public synchronized Array getArray(int i) throws SQLException {
            Array array;
            try {
                array = this.rsi.getArray(i);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return array;
        }

        @Override
        public synchronized Ref getRef(int i) throws SQLException {
            Ref ref;
            try {
                ref = this.rsi.getRef(i);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return ref;
        }

        @Override
        public synchronized Ref getRef(String colName) throws SQLException {
            Ref ref;
            try {
                ref = this.rsi.getRef(colName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return ref;
        }

        @Override
        public synchronized Array getArray(String colName) throws SQLException {
            Array array;
            try {
                array = this.rsi.getArray(colName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return array;
        }

        @Override
        public synchronized Blob getBlob(String colName) throws SQLException {
            Blob blob;
            try {
                blob = this.rsi.getBlob(colName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return blob;
        }

        @Override
        public synchronized Clob getClob(String colName) throws SQLException {
            Clob c = null;
            try {
                c = this.rsi.getClob(colName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return c;
        }

        @Override
        public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
            Date date;
            try {
                date = this.rsi.getDate(columnIndex, cal);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return date;
        }

        @Override
        public synchronized Date getDate(String columnName, Calendar cal) throws SQLException {
            Date date;
            try {
                date = this.rsi.getDate(columnName, cal);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return date;
        }

        @Override
        public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
            Time time;
            try {
                time = this.rsi.getTime(columnIndex, cal);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return time;
        }

        @Override
        public synchronized Time getTime(String columnName, Calendar cal) throws SQLException {
            Time time;
            try {
                time = this.rsi.getTime(columnName, cal);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return time;
        }

        @Override
        public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
            Timestamp ts;
            try {
                ts = this.rsi.getTimestamp(columnIndex, cal);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return ts;
        }

        @Override
        public synchronized Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
            Timestamp ts;
            try {
                ts = this.rsi.getTimestamp(columnName, cal);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return ts;
        }

        @Override
        public synchronized Statement getStatement() throws SQLException {
            Statement stmt;
            try {
                stmt = this.rsi.getStatement();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return stmt;
        }

        @Override
        public URL getURL(int columnIndex) throws SQLException {
            URL u;
            try {
                u = this.rsi.getURL(columnIndex);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return u;
        }

        @Override
        public URL getURL(String columnName) throws SQLException {
            URL u;
            try {
                u = this.rsi.getURL(columnName);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
            return u;
        }

        @Override
        public synchronized void updateRef(int columnIndex, Ref x) throws SQLException {
            try {
                this.rsi.updateRef(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateRef(String columnName, Ref x) throws SQLException {
            try {
                this.rsi.updateRef(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateBlob(int columnIndex, Blob x) throws SQLException {
            try {
                this.rsi.updateBlob(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateBlob(String columnName, Blob x) throws SQLException {
            try {
                this.rsi.updateBlob(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateClob(int columnIndex, Clob x) throws SQLException {
            try {
                this.rsi.updateClob(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateClob(String columnName, Clob x) throws SQLException {
            try {
                this.rsi.updateClob(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateArray(int columnIndex, Array x) throws SQLException {
            try {
                this.rsi.updateArray(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public synchronized void updateArray(String columnName, Array x) throws SQLException {
            try {
                this.rsi.updateArray(columnName, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public int getHoldability() throws SQLException {
            try {
                return this.rsi.getHoldability();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public Reader getNCharacterStream(int columnIndex) throws SQLException {
            try {
                return this.rsi.getNCharacterStream(columnIndex);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public Reader getNCharacterStream(String columnLabel) throws SQLException {
            try {
                return this.rsi.getNCharacterStream(columnLabel);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public NClob getNClob(int columnIndex) throws SQLException {
            try {
                return this.rsi.getNClob(columnIndex);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public NClob getNClob(String columnLabel) throws SQLException {
            try {
                return this.rsi.getNClob(columnLabel);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public String getNString(int columnIndex) throws SQLException {
            try {
                return this.rsi.getNString(columnIndex);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public String getNString(String columnLabel) throws SQLException {
            try {
                return this.rsi.getNString(columnLabel);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
            try {
                return this.rsi.getObject(columnIndex, map);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
            try {
                return this.rsi.getObject(columnLabel, map);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public RowId getRowId(int columnIndex) throws SQLException {
            try {
                return this.rsi.getRowId(columnIndex);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public RowId getRowId(String columnLabel) throws SQLException {
            try {
                return this.rsi.getRowId(columnLabel);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public SQLXML getSQLXML(int columnIndex) throws SQLException {
            try {
                return this.rsi.getSQLXML(columnIndex);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public SQLXML getSQLXML(String columnLabel) throws SQLException {
            try {
                return this.rsi.getSQLXML(columnLabel);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public boolean isClosed() throws SQLException {
            try {
                return this.rsi.isClosed();
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
            try {
                this.rsi.updateAsciiStream(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
            try {
                this.rsi.updateAsciiStream(columnLabel, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
            try {
                this.rsi.updateAsciiStream(columnIndex, x, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
            try {
                this.rsi.updateAsciiStream(columnLabel, x, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
            try {
                this.rsi.updateBinaryStream(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
            try {
                this.rsi.updateBinaryStream(columnLabel, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
            try {
                this.rsi.updateBinaryStream(columnIndex, x, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
            try {
                this.rsi.updateBinaryStream(columnLabel, x, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
            try {
                this.rsi.updateBlob(columnIndex, inputStream);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
            try {
                this.rsi.updateBlob(columnLabel, inputStream);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
            try {
                this.rsi.updateBlob(columnIndex, inputStream, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
            try {
                this.rsi.updateBlob(columnLabel, inputStream, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
            try {
                this.rsi.updateCharacterStream(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
            try {
                this.rsi.updateCharacterStream(columnLabel, reader);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
            try {
                this.rsi.updateCharacterStream(columnIndex, x, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
            try {
                this.rsi.updateCharacterStream(columnLabel, reader, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateClob(int columnIndex, Reader reader) throws SQLException {
            try {
                this.rsi.updateClob(columnIndex, reader);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateClob(String columnLabel, Reader reader) throws SQLException {
            try {
                this.rsi.updateClob(columnLabel, reader);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
            try {
                this.rsi.updateClob(columnIndex, reader, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
            try {
                this.rsi.updateClob(columnLabel, reader, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
            try {
                this.rsi.updateNCharacterStream(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
            try {
                this.rsi.updateNCharacterStream(columnLabel, reader);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
            try {
                this.rsi.updateNCharacterStream(columnIndex, x, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
            try {
                this.rsi.updateNCharacterStream(columnLabel, reader, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateNClob(int columnIndex, NClob clob) throws SQLException {
            try {
                this.rsi.updateNClob(columnIndex, clob);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateNClob(String columnLabel, NClob clob) throws SQLException {
            try {
                this.rsi.updateNClob(columnLabel, clob);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateNClob(int columnIndex, Reader reader) throws SQLException {
            try {
                this.rsi.updateNClob(columnIndex, reader);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateNClob(String columnLabel, Reader reader) throws SQLException {
            try {
                this.rsi.updateNClob(columnLabel, reader);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
            try {
                this.rsi.updateNClob(columnIndex, reader, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
            try {
                this.rsi.updateNClob(columnLabel, reader, length);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateNString(int columnIndex, String string) throws SQLException {
            try {
                this.rsi.updateNString(columnIndex, string);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateNString(String columnLabel, String string) throws SQLException {
            try {
                this.rsi.updateString(columnLabel, string);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateRowId(int columnIndex, RowId x) throws SQLException {
            try {
                this.rsi.updateRowId(columnIndex, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateRowId(String columnLabel, RowId x) throws SQLException {
            try {
                this.rsi.updateRowId(columnLabel, x);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
            try {
                this.rsi.updateSQLXML(columnIndex, xmlObject);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
            try {
                this.rsi.updateSQLXML(columnLabel, xmlObject);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            try {
                return this.rsi.isWrapperFor(iface);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            try {
                return this.rsi.unwrap(iface);
            }
            catch (RemoteException e) {
                throw new SQLException(e.getMessage());
            }
        }

        @Override
        public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
            throw new SQLException("Method not supported");
        }

        @Override
        public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
            throw new SQLException("Method not supported");
        }
    }
}

