/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.SASScope;
import com.sas.services.publish.Column;
import com.sas.services.publish.ObsValue;
import com.sas.text.SASFormat;

@SASScope
public class NumericObsValue
extends ObsValue {
    private double numericValue;
    private int sqlType;

    public NumericObsValue(Column c) {
        super(c);
        this.sqlType = c.getSQLType();
    }

    @Override
    public String toString(int len) {
        String s = null;
        if (this.isMissing()) {
            s = null;
        } else {
            SASFormat f = this.getColumn().getSASFormat();
            String string = s = f != null ? f.format((Object)this.getValue()) : "" + this.numericValue;
        }
        if (s.length() > len) {
            s = s.substring(0, len);
        }
        return s;
    }

    @Override
    public Object toSQLType() {
        if (this.isMissing()) {
            return 0.0;
        }
        switch (this.sqlType) {
            case 4: 
            case 5: {
                Integer itemp = (int)this.numericValue;
                return itemp;
            }
        }
        Double temp = this.numericValue;
        return temp;
    }

    public double getValue() {
        return this.numericValue;
    }

    public void setValue(double d) {
        if (Double.isNaN(d)) {
            d = 0.0;
            this.setMissing(true);
        } else {
            this.numericValue = d;
        }
    }
}

