/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.EntityKeyInterface;
import com.sas.io.ChainedIOException;
import com.sas.io.InputStreamAdapter;
import com.sas.io.RemoteInputStream;
import com.sas.io.RemoteInputStreamInterface;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.DefaultEntityKeyImpl;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.RB;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class HTMLFile
extends UnicastRemoteObject
implements HTMLFileInterface {
    private static final int ARRAY_SIZE_2048 = 2048;
    private String _url = null;
    private String _encoding = null;
    private boolean _isReadOnly = false;
    private InputStream _inputStream = null;
    private File _file;
    private String _mimeType;
    private int _role;
    private String _name = null;
    private EntityKeyInterface _entityKeyIf = new DefaultEntityKeyImpl();
    private File _tempFile = null;
    private static final ByteArrayInputStream DUMMY_INPUTSTREAM = new ByteArrayInputStream(new byte[1]);

    public HTMLFile() throws RemoteException {
        this(HTMLFile.class);
    }

    protected HTMLFile(Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
    }

    public HTMLFile(File file, int role) throws IllegalArgumentException, RemoteException {
        this(HTMLFile.class);
        if (role != 1 && role != 7 && role != 2 && role != 3 && role != 4 && role != 5 && role != 6) {
            throw new IllegalArgumentException(RB.getStringResource("HTMLFile.invalidTypeIllegalArgumentException.ex.txt"));
        }
        if (file == null) {
            throw new IllegalArgumentException(RB.getStringResource("PublishCommon.nullFile.ex.txt"));
        }
        this._file = file;
        this._role = role;
    }

    public HTMLFile(InputStream inputStream, String name, int role) throws IllegalArgumentException, RemoteException {
        this(HTMLFile.class);
        if (role != 1 && role != 7 && role != 2 && role != 3 && role != 4 && role != 5 && role != 6) {
            throw new IllegalArgumentException(RB.getStringResource("HTMLFile.invalidTypeIllegalArgumentException.ex.txt"));
        }
        if (inputStream == null) {
            throw new IllegalArgumentException(RB.getStringResource("PublishCommon.nullStream.ex.txt"));
        }
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource("PublishCommon.nullName.ex.txt"));
        }
        this._inputStream = inputStream;
        this._role = role;
        this._name = name;
    }

    @Override
    public String getURL() throws RemoteException {
        return this._url;
    }

    @Override
    public void setURL(String url) throws IllegalStateException, RemoteException {
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("PublishCommon.entryReadOnly.ex.txt"));
        }
        this._url = url;
    }

    @Override
    public String getEncoding() throws RemoteException {
        return this._encoding;
    }

    @Override
    public void setEncoding(String encoding) throws IllegalStateException, RemoteException {
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("PublishCommon.entryReadOnly.ex.txt"));
        }
        this._encoding = encoding;
    }

    public boolean isReadOnly() throws RemoteException {
        return this._isReadOnly;
    }

    @Override
    public String getName() throws RemoteException {
        return this._file != null ? this._file.getName() : this._name;
    }

    @Override
    public String getMIMEType() {
        return this._mimeType;
    }

    @Override
    public void setMIMEType(String mimeType) throws IllegalStateException, RemoteException {
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("PublishCommon.entryReadOnly.ex.txt"));
        }
        this._mimeType = mimeType;
    }

    @Override
    public int getRole() throws RemoteException {
        return this._role;
    }

    @Override
    public InputStream getInputStream() throws IOException, RemoteException {
        FileInputStream stream = null;
        if (this._file != null) {
            try {
                stream = new FileInputStream(this._file);
            }
            catch (FileNotFoundException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.streamIOError.ex.txt"));
            }
        } else {
            this.consumeStream();
            stream = new FileInputStream(this._tempFile);
        }
        return new InputStreamAdapter((InputStream)stream);
    }

    @Override
    public InputStream getInputStream(Object streamID) throws IOException, RemoteException, UnmarshalException {
        FileInputStream stream = null;
        if (this._file != null) {
            try {
                stream = new FileInputStream(this._file);
            }
            catch (FileNotFoundException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.streamIOError.ex.txt"));
            }
        } else {
            this.consumeStream();
            stream = new FileInputStream(this._tempFile);
        }
        return stream;
    }

    @Override
    public RemoteInputStreamInterface getRemoteInputStream(Object streamID) throws ChainedIOException, RemoteException {
        FileInputStream stream = null;
        RemoteInputStream remoteInputStream = null;
        if (this._file != null) {
            try {
                stream = new FileInputStream(this._file);
            }
            catch (FileNotFoundException e) {
                throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.remoteStreamIOError.ex.txt"));
            }
        }
        try {
            this.consumeStream();
            stream = new FileInputStream(this._tempFile);
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.streamIOError.ex.txt"));
        }
        remoteInputStream = new RemoteInputStream((InputStream)stream);
        return remoteInputStream;
    }

    @Override
    public Object hasInputStream() throws UnmarshalException, RemoteException {
        return DUMMY_INPUTSTREAM;
    }

    public void consumeStream() throws IOException, RemoteException, IllegalStateException {
        if (this._file != null) {
            return;
        }
        FileOutputStream fos = null;
        try {
            if (this._tempFile == null) {
                int len;
                this._tempFile = File.createTempFile("PubHTML", ".html");
                this._tempFile.deleteOnExit();
                fos = new FileOutputStream(this._tempFile);
                byte[] bb = new byte[2048];
                while ((len = this._inputStream.read(bb)) != -1) {
                    fos.write(bb, 0, len);
                }
                fos.close();
                this._inputStream.close();
                this._inputStream = null;
            }
        }
        catch (IOException e) {
            throw new ChainedIOException((Throwable)e, RB.getStringResource("PublishCommon.streamIOError.ex.txt"));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                fos = null;
            }
        }
    }

    public String getEntityKey() throws IllegalStateException, RemoteException {
        return this._entityKeyIf.getEntityKey();
    }

    public boolean sameEntity(EntityKeyInterface entity) throws RemoteException {
        return this._entityKeyIf.sameEntity(entity);
    }

    public void setEntityKey(String entityKey) throws RemoteException, IllegalStateException {
        this._entityKeyIf.setEntityKey(entityKey);
    }

    protected void closeEntry() {
        if (this._tempFile != null) {
            boolean b = this._tempFile.delete();
            if (!b) {
                String tname = this._tempFile.getPath();
                System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"HTMLFile.delErr.fmt.txt", (Object)tname, (Object)this._name));
            }
            this._tempFile = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this._inputStream != null) {
            try {
                this._inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._inputStream = null;
        }
        this.closeEntry();
        super.finalize();
    }
}

