/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.SASScope;
import com.sas.services.ParseException;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.RB;
import com.sas.services.publish.ViewerEntryInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

@SASScope
public class HTMLEncodingParser
extends HTMLEditorKit.ParserCallback {
    private static final int ARRAY_SIZE_1024 = 1024;
    private boolean _foundMetaTag = false;
    private int _metaTagOffset = 0;
    private String _encoding;
    public static final String ENCODING = "ENCODING";
    public static final String OFFSET = "OFFSET";

    @Override
    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (!this._foundMetaTag && t == HTML.Tag.META) {
            this.processMetaAttributes(a, pos);
        }
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (!this._foundMetaTag && t == HTML.Tag.META) {
            this.processMetaAttributes(a, pos);
        }
    }

    public Map parse(Object f) throws ParseException, IllegalArgumentException {
        HashMap<String, Object> map = null;
        if (!(f instanceof HTMLFileInterface) && !(f instanceof ViewerEntryInterface)) {
            throw new IllegalArgumentException(RB.getStringResource("HTMLEncodingParser.badArg.ex.txt"));
        }
        try {
            if (f instanceof HTMLFileInterface) {
                this.parseHTML(((HTMLFileInterface)f).getInputStream(), false);
            } else {
                this.parseHTML(((ViewerEntryInterface)f).getInputStream(), false);
            }
        }
        catch (ChangedCharSetException e) {
            if (e.keyEqualsCharSet()) {
                this._encoding = e.getCharSetSpec();
            } else {
                int advance;
                String metaAttr = e.getCharSetSpec();
                int pos = metaAttr.indexOf(59);
                if (pos > -1 && pos < metaAttr.length() - 1) {
                    metaAttr = metaAttr.substring(pos + 1);
                }
                if (metaAttr.length() > 0 && (pos = metaAttr.indexOf("charset=")) >= 0 && (advance = pos + 8) > 0) {
                    this._encoding = metaAttr.substring(advance, metaAttr.length());
                }
            }
            try {
                if (f instanceof HTMLFileInterface) {
                    this.parseHTML(((HTMLFileInterface)f).getInputStream(), true);
                } else {
                    this.parseHTML(((ViewerEntryInterface)f).getInputStream(), true);
                }
            }
            catch (IOException ee) {
                throw new ParseException((Throwable)ee, RB.getStringResource("HTMLEncodingParser.ioParseException.ex.txt"));
            }
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e, RB.getStringResource("HTMLEncodingParser.ioParseException.ex.txt"));
        }
        if (this._metaTagOffset > 0) {
            try {
                if (f instanceof HTMLFileInterface) {
                    this.readFile(((HTMLFileInterface)f).getInputStream());
                } else {
                    this.readFile(((ViewerEntryInterface)f).getInputStream());
                }
                map = new HashMap<String, Object>();
                map.put(ENCODING, this._encoding);
                map.put(OFFSET, this._metaTagOffset);
            }
            catch (IOException e) {
                throw new ParseException((Throwable)e, RB.getStringResource("HTMLEncodingParser.ioParseException.ex.txt"));
            }
        }
        return map;
    }

    private void readFile(InputStream stream) throws ParseException {
        Reader reader = null;
        try {
            reader = this._encoding != null ? new InputStreamReader(stream, this._encoding) : new InputStreamReader(stream);
            char[] buf = new char[1024];
            int len = 0;
            for (int offset = 0; offset < this._metaTagOffset; offset += len) {
                len = this._metaTagOffset - offset > 1024 ? 1024 : this._metaTagOffset - offset;
                reader.read(buf, 0, len);
            }
            reader.read(buf, 0, 1024);
            String s = new String(buf);
            int cpos = s.indexOf("charset=");
            if (cpos < 0) {
                char[] cbuf = new char[1024];
                reader.read(cbuf, 0, 1024);
                StringBuffer sBuf = new StringBuffer();
                sBuf.append(s);
                String s2 = new String(cbuf);
                sBuf.append(s2);
                s = sBuf.toString();
                cpos = s.indexOf("charset=");
                if (cpos < 0) {
                    throw new ParseException(RB.getStringResource("HTMLEncodingParser.noCharParseException.ex.txt"));
                }
            }
            this._metaTagOffset += cpos + 8;
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e, RB.getStringResource("HTMLEncodingParser.ioParseException.ex.txt"));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseHTML(InputStream stream, boolean ignoreCharSet) throws ChangedCharSetException, IOException {
        ParserGetter kit = new ParserGetter();
        HTMLEditorKit.Parser parser = kit.getParser();
        InputStreamReader reader = null;
        try {
            reader = this._encoding != null ? new InputStreamReader(stream, this._encoding) : new InputStreamReader(stream);
            this._foundMetaTag = false;
            parser.parse(reader, this, ignoreCharSet);
        }
        finally {
            if (stream != null) {
                stream.close();
                stream = null;
            }
            if (reader != null) {
                ((Reader)reader).close();
                reader = null;
            }
        }
    }

    private void processMetaAttributes(MutableAttributeSet a, int pos) {
        this._metaTagOffset = pos;
        Enumeration<?> enumeration = a.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (o != HTML.Attribute.CONTENT) continue;
            String content = (String)a.getAttribute(o);
            int p = content.indexOf("charset=");
            if (p < 0) break;
            int len = content.length();
            this._encoding = content.substring(p + 8, len);
            break;
        }
        this._foundMetaTag = true;
    }

    @SASScope
    class ParserGetter
    extends HTMLEditorKit {
        ParserGetter() {
        }

        @Override
        public HTMLEditorKit.Parser getParser() {
            return super.getParser();
        }
    }
}

