/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.publish.RB;
import com.sas.util.Strings;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DirectoryHierarchy {
    public static final String FOLDER_NAME_PUBLISHING = "Publishing";
    public static final String FOLDER_NAME_CHANNELS = "Channels";
    public static final String FOLDER_NAME_PACKAGESUBSCRIBERS = "Content Subscribers";
    public static final String FOLDER_NAME_EVENTSUBSCRIBERS = "Event Subscribers";
    public static final String FOLDER_NAME_SUBSCRIBERS = "Subscribers";
    public static final String FOLDER_NAME_SYSTEM = "System";
    private static final Map LOCALIZED_FOLDER_NAMES = new HashMap(5);
    private RepositoryInterface _repository;
    private Map _directoryMap = new HashMap(LOCALIZED_FOLDER_NAMES.size());
    private boolean _isValidHierarchy;

    public DirectoryHierarchy(RepositoryInterface repository, boolean isCreateDirectoriesAsNeeded) throws InitializationException {
        this.setRepository(repository);
        this._isValidHierarchy = DirectoryHierarchy.isValidDirectoryHierarchy(repository, isCreateDirectoriesAsNeeded, this._directoryMap);
    }

    public final boolean isValidDirectoryHierarchy() {
        return this._isValidHierarchy;
    }

    public static final String getLocalizedFolderName(String folderName) {
        String localizedFolderName = folderName;
        Object o = LOCALIZED_FOLDER_NAMES.get(folderName);
        try {
            localizedFolderName = (String)o;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return localizedFolderName;
    }

    public static final boolean isValidDirectoryHierarchy(RepositoryInterface repository, boolean isCreateDirectoriesAsNeeded) {
        return DirectoryHierarchy.isValidDirectoryHierarchy(repository, isCreateDirectoriesAsNeeded, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isValidDirectoryHierarchy(RepositoryInterface repository, boolean isCreateDirectoriesAsNeeded, Map directoryMap) {
        boolean isValidHierarchy = false;
        Throwable ex = null;
        try {
            FolderInterface systemFolder;
            if (repository != null && (systemFolder = DirectoryHierarchy.getSystemFolder(repository)) != null) {
                FolderInterface folderPubSub = DirectoryHierarchy.getSubFolder(systemFolder, isCreateDirectoriesAsNeeded, FOLDER_NAME_PUBLISHING);
                FolderInterface folderChannels = null;
                FolderInterface folderSubscribers = null;
                if (folderPubSub != null) {
                    List subFolders = folderPubSub.getSubfolders();
                    Iterator iter = subFolders.iterator();
                    Object o2 = null;
                    boolean isValidSubscribers = false;
                    boolean isValidChannels = false;
                    FolderInterface folder = null;
                    String folderName = null;
                    while (iter.hasNext()) {
                        o2 = iter.next();
                        if (!(o2 instanceof FolderInterface)) continue;
                        folder = o2;
                        folderName = folder.getName();
                        if (!isValidChannels && Strings.equal((String)folderName, (String)FOLDER_NAME_CHANNELS, (boolean)false, (boolean)false)) {
                            isValidChannels = true;
                            folderChannels = folder;
                        } else if (!isValidSubscribers && Strings.equal((String)folderName, (String)FOLDER_NAME_SUBSCRIBERS, (boolean)false, (boolean)false)) {
                            isValidSubscribers = true;
                            folderSubscribers = folder;
                        }
                        if (!isValidChannels || !isValidSubscribers) continue;
                    }
                    if (folderChannels == null && isCreateDirectoriesAsNeeded) {
                        folderPubSub.makeSubfolder(FOLDER_NAME_CHANNELS);
                        folderPubSub.update();
                        folderChannels = folderPubSub.getSubfolder(FOLDER_NAME_CHANNELS);
                    }
                    if (folderSubscribers == null && isCreateDirectoriesAsNeeded) {
                        folderPubSub.makeSubfolder(FOLDER_NAME_SUBSCRIBERS);
                        folderPubSub.update();
                        folderSubscribers = folderPubSub.getSubfolder(FOLDER_NAME_SUBSCRIBERS);
                    }
                    FolderInterface folderContentSubscribers = null;
                    if (folderSubscribers != null) {
                        for (Object o2 : folderSubscribers.getSubfolders()) {
                            if (!(o2 instanceof FolderInterface)) continue;
                            folder = o2;
                            folderName = folder.getName();
                            if (folderContentSubscribers != null || !Strings.equal((String)folderName, (String)FOLDER_NAME_PACKAGESUBSCRIBERS, (boolean)false, (boolean)false)) continue;
                            folderContentSubscribers = folder;
                            break;
                        }
                        if (folderContentSubscribers == null && isCreateDirectoriesAsNeeded) {
                            folderSubscribers.makeSubfolder(FOLDER_NAME_PACKAGESUBSCRIBERS);
                            folderSubscribers.update();
                            folderContentSubscribers = folderSubscribers.getSubfolder(FOLDER_NAME_PACKAGESUBSCRIBERS);
                        }
                    }
                    boolean bl = isValidHierarchy = folderChannels != null && folderSubscribers != null && folderContentSubscribers != null;
                    if (isValidHierarchy && directoryMap != null) {
                        directoryMap.put(FOLDER_NAME_PUBLISHING, folderPubSub);
                        directoryMap.put(FOLDER_NAME_CHANNELS, folderChannels);
                        directoryMap.put(FOLDER_NAME_SUBSCRIBERS, folderSubscribers);
                        directoryMap.put(FOLDER_NAME_PACKAGESUBSCRIBERS, folderContentSubscribers);
                    }
                }
            }
        }
        catch (RemoteException e) {
            ex = e;
        }
        catch (ServiceException e) {
            ex = e;
        }
        finally {
            if (ex != null) {
                isValidHierarchy = false;
            }
        }
        return isValidHierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized FolderInterface getSystemFolder(RepositoryInterface repository) {
        FolderInterface systemFolder = null;
        Throwable ex = null;
        try {
            if (repository != null) {
                systemFolder = repository.getRootFolder(FOLDER_NAME_SYSTEM);
            }
        }
        catch (ServiceException e) {
            ex = e;
        }
        catch (RemoteException e) {
            ex = e;
        }
        finally {
            if (ex != null) {
                DirectoryHierarchy.logMessage(repository, "DirectoryHierarchy.systemErr.txt", (Exception)ex);
            }
        }
        return systemFolder;
    }

    private static final FolderInterface getSubFolder(FolderInterface parentFolder, boolean isCreateDirectoriesAsNeeded, String subFolderName) throws ServiceException, RemoteException {
        FolderInterface subFolder = null;
        if (parentFolder != null && (subFolder = parentFolder.getSubfolder(subFolderName)) == null && isCreateDirectoriesAsNeeded) {
            parentFolder.makeSubfolder(subFolderName);
            parentFolder.update();
            subFolder = parentFolder.getSubfolder(subFolderName);
        }
        return subFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FolderInterface getFolderPublishing() {
        FolderInterface folder = null;
        Throwable ex = null;
        try {
            Object o = this._directoryMap.get(FOLDER_NAME_PUBLISHING);
            if (o instanceof FolderInterface) {
                folder = (FolderInterface)o;
            } else {
                FolderInterface folderSystem = DirectoryHierarchy.getSystemFolder(this._repository);
                if (folderSystem != null) {
                    folder = folderSystem.getSubfolder(FOLDER_NAME_PUBLISHING);
                }
            }
        }
        catch (ServiceException e) {
            ex = e;
        }
        catch (RemoteException e) {
            ex = e;
        }
        finally {
            if (ex != null) {
                DirectoryHierarchy.logMessage(this._repository, "DirectoryHierarchy.publishingErr.txt", (Exception)ex);
            }
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FolderInterface getFolderSubscribers() {
        FolderInterface folder = null;
        Throwable ex = null;
        try {
            Object o = this._directoryMap.get(FOLDER_NAME_SUBSCRIBERS);
            if (o instanceof FolderInterface) {
                folder = (FolderInterface)o;
            } else {
                FolderInterface folderPubSub = this.getFolderPublishing();
                if (folderPubSub != null) {
                    folder = folderPubSub.getSubfolder(FOLDER_NAME_SUBSCRIBERS);
                }
            }
        }
        catch (ServiceException e) {
            ex = e;
        }
        catch (RemoteException e) {
            ex = e;
        }
        finally {
            if (ex != null) {
                DirectoryHierarchy.logMessage(this._repository, "DirectoryHierarchy.subscribersErr.txt", (Exception)ex);
            }
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FolderInterface getFolderPackageSubscribers() {
        FolderInterface folder = null;
        Throwable ex = null;
        try {
            Object o = this._directoryMap.get(FOLDER_NAME_PACKAGESUBSCRIBERS);
            if (o instanceof FolderInterface) {
                folder = (FolderInterface)o;
            } else {
                FolderInterface folderSubscribers = this.getFolderSubscribers();
                if (folderSubscribers != null) {
                    folder = folderSubscribers.getSubfolder(FOLDER_NAME_PACKAGESUBSCRIBERS);
                }
            }
        }
        catch (ServiceException e) {
            ex = e;
        }
        catch (RemoteException e) {
            ex = e;
        }
        finally {
            if (ex != null) {
                DirectoryHierarchy.logMessage(this._repository, "DirectoryHierarchy.pkgSubscribersErr.txt", (Exception)ex);
            }
        }
        return folder;
    }

    public final FolderInterface getFolderEventSubscribers() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FolderInterface getFolderChannels() {
        FolderInterface folder = null;
        Throwable ex = null;
        try {
            Object o = this._directoryMap.get(FOLDER_NAME_CHANNELS);
            if (o instanceof FolderInterface) {
                folder = (FolderInterface)o;
            } else {
                FolderInterface folderPubSub = this.getFolderPublishing();
                if (folderPubSub != null) {
                    folder = folderPubSub.getSubfolder(FOLDER_NAME_CHANNELS);
                }
            }
        }
        catch (RemoteException e) {
            ex = e;
        }
        catch (ServiceException e) {
            ex = e;
        }
        finally {
            if (ex != null) {
                DirectoryHierarchy.logMessage(this._repository, "DirectoryHierarchy.channelsErr.txt", (Exception)ex);
            }
        }
        return folder;
    }

    private final void setRepository(RepositoryInterface repository) throws InitializationException {
        if (repository == null) {
            throw new InitializationException(RB.getStringResource("DirectoryHierarchy.repositoryRequired.ex.txt"));
        }
        try {
            OMIRepositoryInterface omiRepository = (OMIRepositoryInterface)repository;
            this._repository = omiRepository;
        }
        catch (ClassCastException e) {
            throw new InitializationException(RB.getStringResource("DirectoryHierarchy.repositoryOMRRequired.ex.txt"));
        }
    }

    private static void logMessage(RepositoryInterface repos, String resourceKey, Exception e) {
        Logger logger;
        if (resourceKey != null && repos != null && (logger = LogManager.getLogger(DirectoryHierarchy.class)) != null && logger.isDebugEnabled()) {
            logger.debug(RB.getStringResource(resourceKey), (Throwable)e);
        }
    }

    static {
        LOCALIZED_FOLDER_NAMES.put(FOLDER_NAME_CHANNELS, RB.getStringResource("DirectoryHierarchy.folderChannels.txt"));
        LOCALIZED_FOLDER_NAMES.put(FOLDER_NAME_PACKAGESUBSCRIBERS, RB.getStringResource("DirectoryHierarchy.folderPackageSubscribers.txt"));
        LOCALIZED_FOLDER_NAMES.put(FOLDER_NAME_SUBSCRIBERS, RB.getStringResource("DirectoryHierarchy.folderSubscribers.txt"));
        LOCALIZED_FOLDER_NAMES.put(FOLDER_NAME_SYSTEM, RB.getStringResource("DirectoryHierarchy.folderSystem.txt"));
        LOCALIZED_FOLDER_NAMES.put(FOLDER_NAME_PUBLISHING, RB.getStringResource("DirectoryHierarchy.folderPublishing.txt"));
    }
}

