/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.SASScope;
import com.sas.services.TransportException;
import com.sas.services.publish.CharacterObsValue;
import com.sas.services.publish.Column;
import com.sas.services.publish.DatasetEntryCallbackInterface;
import com.sas.services.publish.DateTimeObsValue;
import com.sas.services.publish.ExtendedAttributeData;
import com.sas.services.publish.NumericObsValue;
import com.sas.services.publish.ObsValue;
import com.sas.services.publish.RB;
import com.sas.text.Message;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;

@SASScope
public class DatasetRetriever
implements DatasetEntryCallbackInterface {
    private static final int VERSION_DATASET_UTF8_FIX = 31;
    private static final int RETRIEVER_XV_NOTRANSCODE = 2048;
    private static final int PASSWORD_INFO_LENGTH = 16;
    private static final int VERSION_91_NOTRANSCODE = 33;
    private static final int VERSION_94_EXTENDED_ATTRIBUTES = 34;
    private DataInputStream _dis;
    private int _numberOfObservationsRead;
    private long _numRows = -1L;
    private int _numColumns;
    private Column[] _columns;
    private String _encoding;
    private int _version;
    private boolean _readProtected = false;
    private boolean hasExtendedAttributes = false;
    private boolean hasICs = false;
    private boolean hasIndexes = false;
    private ExtendedAttributeData attrData = null;

    public DatasetRetriever(DataInputStream dataInputStream, String encoding, int version) {
        this(dataInputStream, encoding, version, -1);
    }

    public DatasetRetriever(DataInputStream dataInputStream, String encoding, int version, int nobs) {
        this._dis = dataInputStream;
        this._encoding = encoding;
        this._version = version;
        this._numRows = nobs;
    }

    public int getColumnCount() {
        return this._numColumns;
    }

    public Column[] getColumns() {
        return this._columns;
    }

    public void initialize() throws TransportException {
        if (this._version > 34) {
            throw new TransportException(RB.getStringResource("PublishCommon.compat.ex.txt"));
        }
        try {
            this._dis.readInt();
            this._dis.readInt();
            this._dis.readInt();
            byte[] buffer = new byte[8];
            this._dis.readFully(buffer);
            int len = this._dis.readInt();
            buffer = new byte[len - 1];
            this._dis.readFully(buffer);
            byte[] nullB = new byte[1];
            this._dis.readFully(nullB);
            buffer = new byte[8];
            this._dis.readFully(buffer);
            len = this._dis.readInt();
            buffer = new byte[len - 1];
            this._dis.readFully(buffer);
            this._dis.readFully(nullB);
            if (this._numRows == -1L) {
                this._numRows = this._version >= 34 ? this._dis.readLong() : (long)this._dis.readInt();
            } else if (this._version >= 34) {
                this._dis.readLong();
            } else {
                this._dis.readInt();
            }
            this._numColumns = this._dis.readInt();
            this._dis.readInt();
            this._dis.readInt();
            len = this._dis.readInt();
            buffer = new byte[len - 1];
            this._dis.readFully(buffer);
            this._dis.readFully(nullB);
            len = this._dis.readInt();
            buffer = new byte[len - 1];
            this._dis.readFully(buffer);
            this._dis.readFully(nullB);
            this._dis.readFully(nullB);
            this._dis.readInt();
            this._dis.readInt();
            byte[] readPassword = new byte[4];
            this._dis.readFully(readPassword, 0, 4);
            for (int i = 0; i < 4; ++i) {
                if (readPassword[i] == 0) continue;
                this._readProtected = true;
                break;
            }
            if (this._readProtected) {
                this._columns = null;
                this._numColumns = 0;
                this._numRows = 0L;
                this._dis.close();
                this._dis = null;
                throw new TransportException(RB.getStringResource("DatasetRetriever.readAccess.ex.txt"));
            }
            byte[] pw = new byte[16];
            this._dis.readFully(pw, 0, 16);
            this._dis.readInt();
            int sortCollateLen = this._dis.readInt();
            buffer = new byte[sortCollateLen];
            this._dis.readFully(buffer);
            this._dis.readUnsignedShort();
            int flg = this._dis.readInt();
            if (flg > 0) {
                this.hasIndexes = true;
            }
            if ((flg = this._dis.readInt()) > 0) {
                this.hasICs = true;
            }
            if (this._version >= 34) {
                flg = this._dis.readInt();
                if (flg > 0) {
                    this.hasExtendedAttributes = true;
                }
                this._dis.readLong();
            }
            this._dis.readInt();
            this._dis.readInt();
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DatasetRetriever.metadataError.ex.txt"));
        }
    }

    public void readVariableDefinitions() throws TransportException {
        if (this._readProtected) {
            throw new TransportException(RB.getStringResource("DatasetRetriever.readAccess.ex.txt"));
        }
        try {
            this._columns = new Column[this._numColumns];
            for (int i = 0; i < this._numColumns; ++i) {
                Column currentVar;
                this._columns[i] = currentVar = new Column();
                int len = this._dis.readInt();
                byte[] buffer = new byte[len - 1];
                byte[] nullB = new byte[1];
                this._dis.readFully(buffer);
                currentVar.setName(new String(buffer, this._encoding));
                this._dis.readFully(nullB);
                len = this._dis.readInt();
                if (len > 1) {
                    buffer = new byte[len - 1];
                    this._dis.readFully(buffer);
                    currentVar.setFormat(new String(buffer, this._encoding));
                }
                this._dis.readFully(nullB);
                len = this._dis.readInt();
                if (len > 1) {
                    buffer = new byte[len - 1];
                    this._dis.readFully(buffer);
                    currentVar.setInformat(new String(buffer, this._encoding));
                }
                this._dis.readFully(nullB);
                len = this._dis.readInt();
                if (len > 1) {
                    buffer = new byte[len - 1];
                    this._dis.readFully(buffer);
                    currentVar.setLabel(new String(buffer, this._encoding));
                }
                this._dis.readFully(nullB);
                currentVar.setType(this._dis.readByte());
                currentVar.setLength(this._dis.readInt());
                currentVar.setFormatFieldLength(this._dis.readShort());
                currentVar.setFormatDecimal(this._dis.readShort());
                currentVar.setInformatFieldLength(this._dis.readShort());
                currentVar.setInformatDecimal(this._dis.readShort());
                this._dis.readFully(nullB);
                currentVar.setNsort(new String(nullB));
                currentVar.setSQLType();
                if (this._version < 33) continue;
                currentVar.setNflags(this._dis.readInt());
            }
            int subtype = this._dis.readInt();
            if (this.hasExtendedAttributes) {
                this.readExtendedAttributes();
                subtype = this._dis.readInt();
            }
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DatasetRetriever.variableError.ex.txt"));
        }
    }

    public long convertToUnsignedInt(int input) {
        return (long)input & 0xFFFFFFFFL;
    }

    private void readExtendedAttributes() throws IOException, TransportException {
        long numAttr = 0x2000000L;
        long charAttr = 0x1000000L;
        long tableAttr = 0x8000000L;
        long columnAttr = 0x4000000L;
        this._dis.readInt();
        long numAttrs = this._dis.readLong();
        this.attrData = new ExtendedAttributeData();
        Map<String, String> dsCharAttrs = this.attrData.getDataSetCharacterAttributes();
        Map<String, Double> dsNumAttrs = this.attrData.getDataSetNumericAttributes();
        Map<String, Character> dsMissingAttrs = this.attrData.getDataSetMissingValueAttributes();
        int idx = 0;
        while ((long)idx < numAttrs) {
            int flags;
            String varName = null;
            String attrName = null;
            String attrValue = null;
            double attrNumValue = 0.0;
            int len = this._dis.readInt();
            byte[] buffer = new byte[len];
            this._dis.readFully(buffer);
            attrName = new String(buffer, this._encoding);
            len = this._dis.readInt();
            if (len > 0) {
                buffer = new byte[len];
                this._dis.readFully(buffer);
                varName = new String(buffer, this._encoding);
            }
            if (((long)(flags = this._dis.readInt()) & 0x2000000L) != 0L) {
                len = this._dis.readInt();
                buffer = new byte[len];
                attrNumValue = this._dis.readDouble();
            } else if (((long)flags & 0x1000000L) != 0L) {
                len = this._dis.readInt();
                buffer = new byte[len];
                this._dis.readFully(buffer);
                attrValue = new String(buffer);
            } else {
                throw new TransportException(RB.getStringResource("DatasetRetriever.invalidAttrValueType.ex.txt"));
            }
            if (((long)flags & 0x4000000L) == 0x4000000L) {
                int columnIndex = this.findColumn(varName);
                if (-1 == columnIndex) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"DatasetRetriever.columnNotFound.fmt.txt", (Object)varName, (Object)attrName);
                    throw new TransportException(msg);
                }
                if (((long)flags & 0x1000000L) != 0L) {
                    this._columns[columnIndex].getCharacterAttributes().put(attrName, attrValue);
                } else if (Double.isNaN(attrNumValue)) {
                    this._columns[columnIndex].getMissingValueAttributes().put(attrName, Character.valueOf('.'));
                } else {
                    this._columns[columnIndex].getNumericAttributes().put(attrName, attrNumValue);
                }
            } else if (((long)flags & 0x8000000L) == 0x8000000L) {
                if (((long)flags & 0x1000000L) == 0x1000000L) {
                    dsCharAttrs.put(attrName, attrValue);
                } else if (Double.isNaN(attrNumValue)) {
                    dsMissingAttrs.put(attrName, Character.valueOf('.'));
                } else {
                    dsNumAttrs.put(attrName, attrNumValue);
                }
            } else {
                throw new TransportException(RB.getStringResource("DatasetRetriever.invalidAttrType.ex.txt"));
            }
            ++idx;
        }
    }

    public ObsValue[] getObservation() throws TransportException {
        ObsValue[] currentRow = null;
        if (this._readProtected) {
            throw new TransportException(RB.getStringResource("DatasetRetriever.readAccess.ex.txt"));
        }
        if ((long)this._numberOfObservationsRead == this._numRows) {
            return null;
        }
        int nvars = this._columns.length;
        try {
            currentRow = new ObsValue[nvars];
            for (int y = 0; y < nvars; ++y) {
                int sqltype = this._columns[y].getSQLType();
                if (sqltype == 93) {
                    currentRow[y] = new DateTimeObsValue(this._columns[y], true, true);
                    ((NumericObsValue)currentRow[y]).setValue(this._dis.readDouble());
                    continue;
                }
                if (sqltype == 92) {
                    currentRow[y] = new DateTimeObsValue(this._columns[y], false, true);
                    ((NumericObsValue)currentRow[y]).setValue(this._dis.readDouble());
                    continue;
                }
                if (sqltype == 91) {
                    currentRow[y] = new DateTimeObsValue(this._columns[y], true, false);
                    ((NumericObsValue)currentRow[y]).setValue(this._dis.readDouble());
                    continue;
                }
                if (sqltype == 12) {
                    byte[] buffer;
                    currentRow[y] = new CharacterObsValue(this._columns[y]);
                    if (this._version >= 31) {
                        int length = this._dis.readInt();
                        buffer = new byte[length];
                    } else {
                        buffer = new byte[this._columns[y].getLength()];
                    }
                    this._dis.readFully(buffer);
                    int nflags = this._columns[y].getNflags();
                    if (nflags == 2048) {
                        ((CharacterObsValue)currentRow[y]).setString(new String(buffer));
                        continue;
                    }
                    ((CharacterObsValue)currentRow[y]).setString(new String(buffer, this._encoding));
                    continue;
                }
                currentRow[y] = new NumericObsValue(this._columns[y]);
                ((NumericObsValue)currentRow[y]).setValue(this._dis.readDouble());
            }
            ++this._numberOfObservationsRead;
        }
        catch (EOFException y) {
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("DatasetRetriever.obsError.ex.txt"));
        }
        return currentRow;
    }

    @Override
    public void close() {
        if (this._dis != null) {
            try {
                this._dis.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this._dis = null;
            }
        }
    }

    @Override
    public Vector getObservations() throws TransportException {
        if (this._readProtected) {
            throw new TransportException(RB.getStringResource("DatasetRetriever.readAccess.ex.txt"));
        }
        ObsValue[] currentRow = this.getObservation();
        if (currentRow == null) {
            return null;
        }
        Vector<ObsValue[]> v = new Vector<ObsValue[]>();
        v.addElement(currentRow);
        return v;
    }

    private int findColumn(String columnName) {
        int foundIndex = -1;
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this._columns[i].getName().equalsIgnoreCase(columnName)) continue;
            foundIndex = i;
        }
        return foundIndex;
    }

    @Override
    public ExtendedAttributeData getExtendedAttributes() {
        return this.attrData;
    }
}

