/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.SASScope;
import com.sas.services.publish.ColumnFormat;
import com.sas.text.SASFormat;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@SASScope
public class Column
implements Serializable {
    private static final long serialVersionUID = -5025591476656707923L;
    private String name;
    private String label;
    private String format;
    private String informat;
    private byte type;
    private int length;
    private short fd;
    private short ffl;
    private short ifd;
    private short iffl;
    private String nsort;
    private transient SASFormat _sasFormat;
    private int nflags;
    private int sqltype;
    private Map<String, String> charAttributes = new HashMap<String, String>();
    private Map<String, Double> numAttributes = new HashMap<String, Double>();
    private Map<String, Character> missingValueAttributes = new HashMap<String, Character>();
    public static final int NOSUBTYPE = 0;
    public static final int DOUBLE = 1;
    public static final int CHARACTER = 2;
    public static final int DATE = 3;
    public static final int TIME = 4;
    public static final int DATETIME = 5;
    public static final int INTEGER = 6;
    static final int MAXLEN = 32765;

    public Map<String, String> getCharacterAttributes() {
        return this.charAttributes;
    }

    public Map<String, Double> getNumericAttributes() {
        return this.numAttributes;
    }

    public Map<String, Character> getMissingValueAttributes() {
        return this.missingValueAttributes;
    }

    public int getSQLType() {
        return this.sqltype;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public String getInformat() {
        return this.informat;
    }

    public byte getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public short getFormatDecimal() {
        return this.fd;
    }

    public short getInformatDecimal() {
        return this.ifd;
    }

    public short getFormatFieldLength() {
        return this.ffl;
    }

    public short getInformatFieldLength() {
        return this.iffl;
    }

    public String getNsort() {
        return this.nsort;
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public void setFormat(String s) {
        this.format = s;
    }

    public void setInformat(String s) {
        this.informat = s;
    }

    public void setType(byte b) {
        this.type = b;
    }

    public void setSQLType() {
        ColumnFormat cformat = new ColumnFormat();
        if (this.type == 1) {
            if (this.format == null) {
                this.sqltype = 8;
                return;
            }
            Map formatMap = cformat.findFormat(this.format, this.ffl, this.fd);
            Integer i = (Integer)formatMap.get("COLUMNTYPE");
            int subtype = i;
            this._sasFormat = (SASFormat)formatMap.get("SASFORMAT");
            switch (subtype) {
                case 3: {
                    this.sqltype = 91;
                    break;
                }
                case 4: {
                    this.sqltype = 92;
                    break;
                }
                case 5: {
                    this.sqltype = 93;
                    break;
                }
                case 6: {
                    this.sqltype = 4;
                    break;
                }
                default: {
                    this.sqltype = 8;
                    break;
                }
            }
        } else {
            this.sqltype = 12;
        }
    }

    public void setLength(int i) {
        this.length = i;
    }

    public void setFormatDecimal(short sh) {
        this.fd = sh;
    }

    public void setInformatDecimal(short sh) {
        this.ifd = sh;
    }

    public void setFormatFieldLength(short sh) {
        this.ffl = sh;
    }

    public void setInformatFieldLength(short sh) {
        this.iffl = sh;
    }

    public void setNsort(String s) {
        this.nsort = s;
    }

    public SASFormat getSASFormat() {
        return this._sasFormat;
    }

    public int getNflags() {
        return this.nflags;
    }

    public void setNflags(int flags) {
        this.nflags = flags;
    }
}

