/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.SASScope;
import com.sas.services.ParseException;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.information.metadata.ContentSubscriberInterface;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.GroupInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.publish.AbstractTransport;
import com.sas.services.publish.ChannelTransportInterface;
import com.sas.services.publish.EventDataInterface;
import com.sas.services.publish.RB;
import com.sas.services.publish.ResultPackageEventBuilder;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TransportFactory;
import com.sas.services.publish.TransportInterface;
import com.sas.services.publish.archive.ArchiveTransport;
import com.sas.services.publish.archive.ArchiveTransportInterface;
import com.sas.services.publish.metadata.ArchiveInterface;
import com.sas.services.publish.metadata.PublishDirectoryFactory;
import com.sas.services.publish.metadata.PublishDirectoryInterface;
import com.sas.services.publish.webdav.DAVTransportInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.util.AttributeMap;
import com.sas.services.util.AttributeMapInterface;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class ChannelTransport
extends AbstractTransport
implements ChannelTransportInterface {
    private ChannelInterface _channel;
    private String channelName = null;
    private Logger logger = LogManager.getLogger(ChannelTransport.class);
    private static final long DEFAULT_EXPIRATION = 253402300799000L;

    public ChannelTransport(ChannelInterface channel, Logger saslogger, SessionContextInterface sessionContext) throws TransportException, IllegalArgumentException, IllegalStateException {
        this.setSessionContext(sessionContext);
        this._channel = channel;
        if (this._channel == null) {
            throw new IllegalArgumentException(RB.getStringResource("ChannelTransport.invalidChannel.ex.txt"));
        }
        try {
            this.channelName = this._channel.getName();
            if (saslogger != null) {
                this.setLogger(saslogger);
            }
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("PublishCommon.remoteTransportException.ex.txt"));
        }
    }

    public ChannelTransport(ChannelInterface channel, SessionContextInterface sessionContext) throws TransportException, IllegalArgumentException, IllegalStateException {
        this(channel, null, sessionContext);
    }

    @Override
    public void setChannel(ChannelInterface channel) {
        this._channel = channel;
    }

    @Override
    public ChannelInterface getChannel() {
        return this._channel;
    }

    @Override
    public ResultPackageInterface getResultPackage() throws TransportException, UnsupportedOperationException {
        throw new UnsupportedOperationException(RB.getStringResource("ChannelTransport.unsupportedOperationException.ex.txt"));
    }

    @Override
    public EventDataInterface publishResultPackage(ResultPackageInterface rpkg, boolean buildEvent) throws TransportException {
        boolean isAuthorized;
        EventDataInterface eventData = null;
        String channelName = null;
        String userName = "";
        try {
            isAuthorized = this._channel.isPublishAuthorized();
            channelName = this._channel.getName();
            IdentityInterface person = this._channel.getRepository().getIdentity();
            if (person != null) {
                userName = person.getName();
            }
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ChannelTransport.pubErr.ex.txt"));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("ChannelTransport.pubErr.ex.txt"));
        }
        if (!isAuthorized) {
            throw new TransportException(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.permErr.ex.fmt.txt", (Object)userName, (Object)channelName));
        }
        eventData = this.publishThePackage(rpkg, buildEvent);
        return eventData;
    }

    private EventDataInterface publishThePackage(ResultPackageInterface rpkg, boolean buildEvent) throws TransportException {
        ArrayList davSubscribers = new ArrayList();
        EventDataInterface eventData = null;
        eventData = this.publishDefaults(rpkg, buildEvent);
        try {
            for (Object s : this._channel.subscriberList(1)) {
                this.processTheSubscriber((ContentSubscriberInterface)s, davSubscribers, rpkg);
            }
            this.getSubscriberGroups(this._channel.subscriberGroupsList(1).iterator(), davSubscribers, rpkg);
            if (!davSubscribers.isEmpty()) {
                this.publishToDAV(davSubscribers, rpkg);
            }
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("PublishCommon.serviceTransportException.ex.txt"));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, RB.getStringResource("PublishCommon.remoteTransportException.ex.txt"));
        }
        if (buildEvent && eventData == null) {
            ResultPackageEventBuilder builder = new ResultPackageEventBuilder();
            try {
                eventData = builder.buildEvent(rpkg, null, this._channel.getName(), "channel", null);
            }
            catch (RemoteException e) {
                throw new TransportException((Throwable)e, RB.getStringResource("PublishCommon.error.ex.txt"));
            }
        }
        return eventData;
    }

    private void getSubscriberGroups(Iterator it, List davSubscribers, ResultPackageInterface rpkg) throws RemoteException {
        while (it.hasNext()) {
            Object s = it.next();
            if (s instanceof ContentSubscriberInterface) {
                this.processTheSubscriber((ContentSubscriberInterface)s, davSubscribers, rpkg);
                continue;
            }
            if (s instanceof PersonInterface) {
                PersonInterface p = (PersonInterface)s;
                try {
                    Iterator pit = p.getSubscribers().iterator();
                    while (pit.hasNext()) {
                        this.processTheSubscriber((ContentSubscriberInterface)pit.next(), davSubscribers, rpkg);
                    }
                    continue;
                }
                catch (ServiceException e) {
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.personError.fmt.txt", (Object)p.getName()), (Throwable)e);
                    continue;
                }
            }
            GroupInterface g = (GroupInterface)s;
            try {
                this.getSubscriberGroups(g.members().iterator(), davSubscribers, rpkg);
            }
            catch (ServiceException ex) {
                this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.personError.fmt.txt", (Object)g.getName()), (Throwable)ex);
            }
        }
    }

    private void processTheSubscriber(ContentSubscriberInterface sub, List davSubscribers, ResultPackageInterface rpkg) throws RemoteException {
        boolean isInfoLogEnabled = this.logger != null && this.logger.isInfoEnabled();
        String transport = null;
        try {
            transport = sub.getDeliveryTransport();
        }
        catch (ServiceException ex) {
            transport = "";
        }
        if (transport.equalsIgnoreCase("webdav")) {
            this.applyTheFilters(sub, davSubscribers, rpkg);
        } else if (transport.equalsIgnoreCase("email")) {
            if (isInfoLogEnabled) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.emailNotSupported.fmt.txt", (Object)sub.getName()));
            }
        } else if (transport.equalsIgnoreCase("queue")) {
            if (isInfoLogEnabled) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.queueNotSupported.fmt.txt", (Object)sub.getName()));
            }
        } else if (transport.equalsIgnoreCase("none")) {
            int defaultTransport = 0;
            try {
                defaultTransport = this._channel.getDeliveryTransport();
            }
            catch (ServiceException ex) {
                defaultTransport = 0;
            }
            if (defaultTransport == 0 && isInfoLogEnabled) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.noneSubNoTrans.fmt.txt", (Object)sub.getName()));
            }
        } else if (isInfoLogEnabled) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.badTrans.fmt.txt", (Object)sub.getName()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void publishToDAV(List davSubscribers, ResultPackageInterface rpkg) {
        HashMap published = new HashMap();
        TransportFactory factory = new TransportFactory();
        String subscriberName = null;
        Iterator it = davSubscribers.iterator();
        while (it.hasNext()) {
            try {
                ContentDestination content;
                int urlType;
                block14: {
                    String urlTypeString;
                    block15: {
                        urlType = 0;
                        ContentSubscriberInterface sub = (ContentSubscriberInterface)it.next();
                        subscriberName = sub.getName();
                        content = sub.getContentDestination();
                        if (content == null) {
                            if (this.logger == null) continue;
                            this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.noServer.fmt.txt", (Object)subscriberName));
                            continue;
                        }
                        urlTypeString = sub.getDavUrlType();
                        if (urlTypeString == null || urlTypeString.equals("")) break block15;
                        if (urlTypeString.equalsIgnoreCase("collection")) {
                            urlType = 1;
                            urlTypeString = "collection";
                            String subUrl = content.getPath();
                            if (subUrl == null || subUrl.equals("")) {
                                this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.noSubUrl.fmt.txt", (Object)subscriberName));
                                this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.notPublishedToDavSub.fmt.txt", (Object)subscriberName));
                                continue;
                            }
                            break block14;
                        } else if (urlTypeString.equalsIgnoreCase("parent")) {
                            urlType = 2;
                            urlTypeString = "parent";
                            break block14;
                        } else {
                            this.logger.warn(RB.getStringResource("ChannelTransport.invalidRole.txt"));
                            this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.notPublishedToDavSub.fmt.txt", (Object)subscriberName));
                            continue;
                        }
                    }
                    urlType = 2;
                    urlTypeString = "parent";
                }
                DAVTransportInterface dav = factory.getDAVTransport(content, this.getSessionContext());
                dav.setURLRole(urlType);
                if (urlType == 1) {
                    if (published.containsKey(dav.getURL())) {
                        if (this.logger == null) continue;
                        this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.dupDavSub.fmt.txt", (Object)subscriberName));
                        continue;
                    }
                    published.put(dav.getURL(), null);
                }
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.pubToDavSub.fmt.txt", (Object)subscriberName));
                }
                dav.publishResultPackage(rpkg, false);
                if (this.logger == null || !this.logger.isDebugEnabled()) continue;
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.publishedToDavSub.fmt.txt", (Object)subscriberName));
            }
            catch (Exception e) {
                if (this.logger == null) continue;
                if (subscriberName != null) {
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.notPublishedToDavSub.fmt.txt", (Object)subscriberName), (Throwable)e);
                    continue;
                }
                this.logger.warn(RB.getStringResource("ChannelTransport.notPublishedToDavSub.txt"), (Throwable)e);
                continue;
            }
            break;
        }
        return;
    }

    private void applyTheFilters(ContentSubscriberInterface sub, List subscriberList, ResultPackageInterface rpkg) throws RemoteException {
        block22: {
            AttributeMapInterface pkgNameValuePairs = null;
            try {
                pkgNameValuePairs = rpkg.getNameValuePairs();
                List l = sub.nameValueInclusionFilters();
                if (l.size() != 0) {
                    boolean match;
                    if (pkgNameValuePairs == null) {
                        match = false;
                    } else {
                        Iterator itor = l.iterator();
                        match = false;
                        while (itor.hasNext() && !(match = AttributeMap.applyFilter((String)((String)itor.next()), (AttributeMapInterface)rpkg.getNameValuePairs()))) {
                        }
                    }
                    if (!match) {
                        if (this.logger != null) {
                            this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.incFilter.fmt.txt", (Object)sub.getName()));
                        }
                    } else {
                        subscriberList.add(sub);
                    }
                } else {
                    l = sub.nameValueExclusionFilters();
                    if (l.size() == 0) {
                        subscriberList.add(sub);
                    } else {
                        boolean match;
                        if (pkgNameValuePairs == null) {
                            match = false;
                        } else {
                            Iterator itor = l.iterator();
                            match = false;
                            while (itor.hasNext() && !(match = AttributeMap.applyFilter((String)((String)itor.next()), (AttributeMapInterface)rpkg.getNameValuePairs()))) {
                            }
                        }
                        if (match) {
                            if (this.logger != null) {
                                this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.excFilter.fmt.txt", (Object)sub.getName()));
                            }
                        } else {
                            subscriberList.add(sub);
                        }
                    }
                }
            }
            catch (ParseException e) {
                if (this.logger != null) {
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.filterErr.fmt.txt", (Object)sub.getName()), (Throwable)e);
                }
            }
            catch (TransportException e) {
                if (this.logger != null) {
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.filterErr.fmt.txt", (Object)sub.getName()), (Throwable)e);
                }
            }
            catch (ServiceException e) {
                if (this.logger == null) break block22;
                this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.filterErr.fmt.txt", (Object)sub.getName()), (Throwable)e);
            }
        }
    }

    private TransportInterface getDefaultArchive() throws TransportException {
        ServerInterface server = null;
        String path = null;
        ArchiveTransportInterface archiveTransport = null;
        ContentDestination archivePath = null;
        try {
            this.channelName = this._channel.getName();
            archivePath = this._channel.getArchivePath();
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultArchiveErr.fmt.txt", (Object)this.channelName));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultArchiveErr.fmt.txt", (Object)this.channelName));
        }
        if (archivePath == null) {
            throw new TransportException(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.noDefaultArchivePath.fmt.txt", (Object)this.channelName));
        }
        server = archivePath.getServer();
        path = archivePath.getPath();
        if (path == null && server == null) {
            throw new TransportException(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.noPath.ex.fmt.txt", (Object)this.channelName));
        }
        try {
            if (path != null && server == null) {
                int pos = path.indexOf("://");
                if (pos >= 0) {
                    URL u = new URL(path);
                    String protocol = u.getProtocol();
                    if (protocol.compareToIgnoreCase("file") != 0) {
                        throw new TransportException(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.invalidArchiveProto.fmt.txt", (Object)protocol));
                    }
                    path = u.getPath();
                }
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultArchivePath.fmt.txt", (Object)path, (Object)this.channelName));
                }
                if (!path.endsWith(File.separator)) {
                    path = path.concat(File.separator);
                }
            }
            if (server == null) {
                File f = null;
                StringBuffer buf = null;
                boolean generatedUnique = false;
                int counter = 0;
                while (!generatedUnique && counter < 100) {
                    buf = new StringBuffer();
                    buf.append(path);
                    buf.append(Names.generateName((int)0));
                    buf.append(".spk");
                    f = new File(buf.toString());
                    if (!f.exists()) {
                        generatedUnique = true;
                        continue;
                    }
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.notUnique.fmt.txt", (Object)buf.toString()));
                    }
                    ++counter;
                }
                if (!generatedUnique) {
                    throw new TransportException(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.generateUniqueErr.ex.fmt.txt", (Object)this.channelName));
                }
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.createDefaultArchive.fmt.txt", (Object)buf.toString()));
                }
                TransportFactory factory = new TransportFactory();
                archiveTransport = factory.getArchiveTransport(f, this.getSessionContext());
            } else {
                StringBuffer buf = new StringBuffer();
                buf.append(Names.generateName((int)0));
                buf.append(".spk");
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultArchivePathServer.fmt.txt", (Object)this.channelName));
                }
                archiveTransport = new ArchiveTransport(archivePath, this.getSessionContext(), buf.toString());
            }
        }
        catch (TransportException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultArchivePubErr.fmt.txt", (Object)this.channelName));
        }
        catch (MalformedURLException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultArchivePubErr.fmt.txt", (Object)this.channelName));
        }
        return archiveTransport;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TransportInterface getDefaultDAV() throws TransportException {
        DAVTransportInterface davTransport = null;
        try {
            int urlType;
            this.channelName = this._channel.getName();
            ContentDestination content = this._channel.getContentDestination();
            if (content == null) {
                throw new TransportException(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.noContentDest.ex.fmt.txt", (Object)this.channelName));
            }
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultDAV.fmt.txt", (Object)this.channelName));
            }
            TransportFactory factory = new TransportFactory();
            davTransport = factory.getDAVTransport(content, this.getSessionContext());
            String urlTypeString = this._channel.getDavUrlType();
            if (urlTypeString != null && !urlTypeString.equals("")) {
                if (urlTypeString.equalsIgnoreCase("collection")) {
                    urlTypeString = "collection";
                    urlType = 1;
                    String channelUrl = content.getPath();
                    if (channelUrl == null || channelUrl.equals("")) {
                        throw new TransportException(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.noChannelUrl.txt", (Object)this.channelName));
                    }
                } else {
                    if (!urlTypeString.equalsIgnoreCase("parent")) throw new TransportException(RB.getStringResource("ChannelTransport.invalidRole.txt"));
                    urlType = 2;
                    urlTypeString = "parent";
                }
            } else {
                urlType = 2;
                urlTypeString = "parent";
            }
            davTransport.setURLRole(urlType);
            if (this.logger == null || !this.logger.isDebugEnabled()) return davTransport;
            this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.pubToDefaultDAV.fmt.txt", (Object)this.channelName));
            return davTransport;
        }
        catch (TransportException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultDAVPubErr.fmt.txt", (Object)this.channelName));
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultDAVPubErr.fmt.txt", (Object)this.channelName));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultDAVPubErr.fmt.txt", (Object)this.channelName));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EventDataInterface publishDefaults(ResultPackageInterface rpkg, boolean buildEvent) throws TransportException {
        EventDataInterface eventData = null;
        TransportInterface transport = null;
        try {
            int defaultTransport = this._channel.getDeliveryTransport();
            if (defaultTransport != 0) {
                if (defaultTransport == 3) {
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.noDefaultArchivePath.fmt.txt", (Object)this.channelName));
                    }
                    transport = this.getDefaultDAV();
                } else {
                    if (defaultTransport != 2) throw new TransportException(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.invalidTrans.fmt.txt", (Object)this.channelName));
                    transport = this.getDefaultArchive();
                }
            } else {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.noDefaultArchivePath.fmt.txt", (Object)this.channelName));
                }
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.noDefaultDavServer.fmt.txt", (Object)this.channelName));
                }
            }
        }
        catch (ServiceException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaulErr.fmt.txt", (Object)this.channelName));
        }
        catch (RemoteException e) {
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaulErr.fmt.txt", (Object)this.channelName));
        }
        if (transport == null) return eventData;
        ArchiveInterface archive = null;
        ArchiveTransportInterface aT = null;
        if (transport instanceof ArchiveTransportInterface) {
            try {
                aT = (ArchiveTransportInterface)transport;
                DirectoryInterface aPath = this._channel.getArchivePath().getDirectory();
                PublishDirectoryInterface pubDir = PublishDirectoryFactory.newPublishDirectory(aPath);
                String tmpName = aT.getName();
                if (tmpName.endsWith(".spk")) {
                    tmpName = tmpName.substring(0, tmpName.length() - 4);
                }
                archive = pubDir.createArchive(tmpName);
                archive.setName(tmpName);
                archive.setAbstract(rpkg.getAbstract());
                archive.setChannel(this._channel);
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                calendar.setTime(new Date());
                archive.setCreationDate(calendar.getTime().getTime());
                archive.setDescription(rpkg.getDescription());
                archive.setDirectory(aPath);
                AttributeMap attrMap = (AttributeMap)rpkg.getNameValuePairs();
                if (attrMap != null) {
                    archive.setProperties((AttributeMapInterface)attrMap);
                }
                VMID vmid = new VMID();
                archive.setGUID(vmid.toString());
                long l = rpkg.getExpirationDateTime();
                if (l == 0L) {
                    l = 253402300799000L;
                }
                archive.setExpirationDate(l);
                RepositoryInterface repository = this._channel.getRepository();
                if (repository != null) {
                    archive.setPublisher(repository.getUser());
                }
                archive.add();
            }
            catch (ServiceException e) {
                if (archive == null) throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.archiveDefineErr.fmt.txt", (Object)this.channelName));
                try {
                    archive.delete();
                    throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.archiveDefineErr.fmt.txt", (Object)this.channelName));
                }
                catch (Exception ex) {
                    if (this.logger == null) throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.archiveDefineErr.fmt.txt", (Object)this.channelName));
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.pubDelErr.fmt.txt", (Object)this.channelName, (Object)aT.getName()));
                }
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.archiveDefineErr.fmt.txt", (Object)this.channelName));
            }
            catch (RemoteException e) {
                if (archive == null) throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.archiveDefineErr.fmt.txt", (Object)this.channelName));
                try {
                    archive.delete();
                    throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.archiveDefineErr.fmt.txt", (Object)this.channelName));
                }
                catch (Exception ex) {
                    if (this.logger == null) throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.archiveDefineErr.fmt.txt", (Object)this.channelName));
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.pubDelErr.fmt.txt", (Object)this.channelName, (Object)aT.getName()));
                }
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.archiveDefineErr.fmt.txt", (Object)this.channelName));
            }
        }
        try {
            eventData = transport.publishResultPackage(rpkg, buildEvent);
        }
        catch (Exception e) {
            if (transport instanceof DAVTransportInterface) {
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultDAVPubErr.fmt.txt", (Object)this.channelName));
            }
            if (archive == null) throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultArchivePubErr.fmt.txt", (Object)this.channelName));
            try {
                archive.delete();
                throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultArchivePubErr.fmt.txt", (Object)this.channelName));
            }
            catch (Exception ex) {
                if (this.logger == null) throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultArchivePubErr.fmt.txt", (Object)this.channelName));
                this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.pubDelErr.fmt.txt", (Object)this.channelName, (Object)aT.getName()));
            }
            throw new TransportException((Throwable)e, Message.format((ResourceBundle)RB.getResources(), (String)"ChannelTransport.defaultArchivePubErr.fmt.txt", (Object)this.channelName));
        }
        if (this.logger == null || !this.logger.isDebugEnabled()) return eventData;
        if (transport instanceof DAVTransportInterface) {
            this.logger.debug(RB.getStringResource("ChannelTransport.defaultDAVPub.txt"));
            return eventData;
        } else {
            this.logger.debug(RB.getStringResource("ChannelTransport.defaultArchivePub.txt"));
        }
        return eventData;
    }
}

