/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.publish;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.EntityKeyInterface;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.DefaultEntityKeyImpl;
import com.sas.services.TransportException;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.RB;
import com.sas.services.util.AttributeMapInterface;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public abstract class AbstractEntry
extends UnicastRemoteObject
implements EntryInterface {
    public static final int DEFAULT_ENTRY_VERSION = 15;
    public static final int REFERENCE_COMPAT_VERSION = 15;
    public static final int TEXT_COMPAT_VERSION = 15;
    public static final int BINARY_COMPAT_VERSION = 15;
    public static final int HTML_COMPAT_VERSION = 32;
    public static final int VIEWER_COMPAT_VERSION = 30;
    public static final int DATASET_COMPAT_VERSION = 34;
    public static final int VERSION_94_EXTENDED_ATTRIBUTES = 34;
    public static final int CATALOG_COMPAT_VERSION = 15;
    public static final int MDDB_COMPAT_VERSION = 15;
    public static final int SQLVIEW_COMPAT_VERSION = 15;
    public static final int NESTEDPACKAGE_COMPAT_VERSION = 15;
    private String _description;
    private AttributeMapInterface _namevalues;
    private boolean _closed = false;
    private boolean _readOnly = false;
    private EntityKeyInterface _entityKeyIf = new DefaultEntityKeyImpl();

    public AbstractEntry() throws RemoteException {
        this(AbstractEntry.class);
    }

    protected AbstractEntry(Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
    }

    protected void throwExceptionIfClosed() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("AbstractEntry.alreadyClosedIllegalStateException.ex.txt"));
        }
    }

    protected boolean isClosed() {
        return this._closed;
    }

    protected void setClosed(boolean closed) {
        this._closed = closed;
    }

    @Override
    public boolean isReadOnly() throws RemoteException {
        return this._readOnly;
    }

    protected void setRead(boolean readOnly) {
        this._readOnly = readOnly;
    }

    @Override
    public String getDescription() throws RemoteException, IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("AbstractEntry.alreadyClosedIllegalStateException.ex.txt"));
        }
        return this._description;
    }

    @Override
    public void setDescription(String description) throws IllegalStateException, RemoteException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("AbstractEntry.alreadyClosedIllegalStateException.ex.txt"));
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("PublishCommon.entryReadOnly.ex.txt"));
        }
        this._description = description;
    }

    @Override
    public AttributeMapInterface getNameValuePairs() throws TransportException, RemoteException, IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("AbstractEntry.alreadyClosedIllegalStateException.ex.txt"));
        }
        return this._namevalues;
    }

    @Override
    public void setNameValuePairs(AttributeMapInterface namevalues) throws IllegalStateException, RemoteException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("AbstractEntry.alreadyClosedIllegalStateException.ex.txt"));
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException(RB.getStringResource("PublishCommon.entryReadOnly.ex.txt"));
        }
        this._namevalues = namevalues;
    }

    public String getEntityKey() throws IllegalStateException, RemoteException {
        return this._entityKeyIf.getEntityKey();
    }

    public boolean sameEntity(EntityKeyInterface entity) throws RemoteException {
        return this._entityKeyIf.sameEntity(entity);
    }

    public void setEntityKey(String entityKey) throws RemoteException, IllegalStateException {
        this._entityKeyIf.setEntityKey(entityKey);
    }

    @Override
    public String getURL() throws IllegalStateException, TransportException, RemoteException {
        if (this.isClosed()) {
            throw new IllegalStateException(RB.getStringResource("AbstractEntry.alreadyClosedIllegalStateException.ex.txt"));
        }
        return null;
    }
}

