/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TriggerEventInfo", propOrder={"schedulerDataBinding", "typeDataBinding", "timeEventDataBinding", "fileEventDataBinding", "groupingEventDataBinding"})
public class TriggerEventInfo
extends DisplayInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="SchedulerServer")
    protected SchedulerServerInfo schedulerDataBinding;
    @XmlElement(name="Type", required=true)
    protected String typeDataBinding;
    @XmlElement(name="TimeEvent")
    protected TimeEventInfo timeEventDataBinding;
    @XmlElement(name="FileEvent")
    protected FileEventInfo fileEventDataBinding;
    @XmlElement(name="GroupingEvent")
    protected GroupingEventInfo groupingEventDataBinding;
    private static final ResourceBundle m_bundle;
    public static final String IconName;

    public SchedulerServerInfo getSchedulerDataBinding() {
        return this.schedulerDataBinding;
    }

    public void setSchedulerDataBinding(SchedulerServerInfo value) {
        this.schedulerDataBinding = value;
    }

    public String getTypeDataBinding() {
        return this.typeDataBinding;
    }

    public void setTypeDataBinding(String value) {
        this.typeDataBinding = value;
    }

    public TimeEventInfo getTimeEventDataBinding() {
        return this.timeEventDataBinding;
    }

    public void setTimeEventDataBinding(TimeEventInfo value) {
        this.timeEventDataBinding = value;
    }

    public FileEventInfo getFileEventDataBinding() {
        return this.fileEventDataBinding;
    }

    public void setFileEventDataBinding(FileEventInfo value) {
        this.fileEventDataBinding = value;
    }

    public GroupingEventInfo getGroupingEventDataBinding() {
        return this.groupingEventDataBinding;
    }

    public void setGroupingEventDataBinding(GroupingEventInfo value) {
        this.groupingEventDataBinding = value;
    }

    public TriggerEventInfo() {
    }

    public TriggerEventInfo(String name, SchedulerServerInfo scheduler, String type) {
        super(name, null, IconName);
        this.schedulerDataBinding = scheduler;
        this.typeDataBinding = type;
    }

    public TriggerEventInfo(TimeEventInfo event, SchedulerServerInfo scheduler) {
        super(event.toString(), event.getDescription(), IconName);
        this.schedulerDataBinding = scheduler;
        this.timeEventDataBinding = event;
        this.fileEventDataBinding = null;
        this.groupingEventDataBinding = null;
        this.typeDataBinding = "TimeEvent";
    }

    public TriggerEventInfo(FileEventInfo event, SchedulerServerInfo scheduler) {
        super(event.toString(), event.getDescription(), IconName);
        if (scheduler == null || scheduler.isFileEventSupportedAsTriggers()) {
            this.schedulerDataBinding = scheduler;
            this.timeEventDataBinding = null;
            this.fileEventDataBinding = event;
            this.groupingEventDataBinding = null;
            this.typeDataBinding = "FileEvent";
        } else {
            boolean debug;
            String message = m_bundle.getString("TriggerEventInfo.FileEvent.InvalidForScheduler.txt");
            InvalidParameterException ex = new InvalidParameterException(message);
            boolean bl = debug = System.getProperty("Debug") != null;
            if (debug) {
                ex.printStackTrace();
            }
            this.schedulerDataBinding = scheduler;
            this.fileEventDataBinding = null;
            this.timeEventDataBinding = null;
            this.groupingEventDataBinding = null;
            this.typeDataBinding = null;
        }
    }

    public TriggerEventInfo(GroupingEventInfo event, SchedulerServerInfo scheduler) {
        super(event.toString(), event.getDescription(), IconName);
        if (scheduler != null && scheduler.isMultiTriggersSupported()) {
            this.schedulerDataBinding = scheduler;
            this.fileEventDataBinding = null;
            this.timeEventDataBinding = null;
            this.groupingEventDataBinding = event;
            this.typeDataBinding = "Gate";
        } else {
            boolean debug;
            String message = m_bundle.getString("TriggerEventInfo.GateEvent.InvalidForScheduler.txt");
            InvalidParameterException ex = new InvalidParameterException(message);
            boolean bl = debug = System.getProperty("Debug") != null;
            if (debug) {
                ex.printStackTrace();
            }
            this.schedulerDataBinding = scheduler;
            this.fileEventDataBinding = null;
            this.timeEventDataBinding = null;
            this.groupingEventDataBinding = null;
            this.typeDataBinding = null;
        }
    }

    @Override
    public String getIconName() {
        if (this.timeEventDataBinding != null) {
            return TimeEventInfo.IconName;
        }
        if (this.fileEventDataBinding != null) {
            return FileEventInfo.IconName;
        }
        return GroupingEventInfo.IconName;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.timeEventDataBinding != null) {
            this.timeEventDataBinding.setName(name);
        } else if (this.fileEventDataBinding != null) {
            this.fileEventDataBinding.setName(name);
        }
    }

    public boolean setEvent(DisplayInfo event) {
        if (event instanceof TimeEventInfo) {
            this.timeEventDataBinding = (TimeEventInfo)event;
            this.typeDataBinding = "TimeEvent";
            super.setName(event.toString());
            return true;
        }
        if (event instanceof FileEventInfo) {
            this.fileEventDataBinding = (FileEventInfo)event;
            this.typeDataBinding = "FileEvent";
            super.setName(event.toString());
            return true;
        }
        if (event instanceof GroupingEventInfo) {
            this.groupingEventDataBinding = (GroupingEventInfo)event;
            this.typeDataBinding = "Gate";
            super.setName(event.toString());
            return true;
        }
        return false;
    }

    public AbstractEventInfo getEvent() {
        if (this.timeEventDataBinding != null) {
            return this.timeEventDataBinding;
        }
        if (this.fileEventDataBinding != null) {
            return this.fileEventDataBinding;
        }
        if (this.groupingEventDataBinding != null) {
            return this.groupingEventDataBinding;
        }
        return null;
    }

    public String getType() {
        return this.typeDataBinding;
    }

    public SchedulerServerInfo getScheduler() {
        return this.schedulerDataBinding;
    }

    public boolean setScheduler(SchedulerServerInfo scheduler) {
        this.schedulerDataBinding = scheduler;
        return true;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof TriggerEventInfo) {
            String id = ((TriggerEventInfo)arg0).getId();
            if (this.getId() != null && id != null) {
                return this.getId().equals(id);
            }
            return super.equals(arg0);
        }
        return super.equals(arg0);
    }

    public static String makeValidTriggerName(String condition, String classid) {
        int index;
        String strName = null;
        strName = classid != null && (classid.compareTo("b379c9c1-89e0-4e72-ba43-6a416899b5dd") == 0 || classid.compareTo("8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae") == 0 || classid.compareTo("c8b4baf0-5f9f-488e-ba76-1201e1e81aef") == 0 || classid.compareTo("ff3aab60-8926-4e88-8af3-4287787d7d7") == 0 || classid.compareTo("c8b4baf0-5f9f-471e-ba76-1201e1e81aef") == 0) ? ((index = condition.indexOf(64)) > 0 ? condition.substring(0, index) : condition) : condition;
        return strName;
    }

    public String generateXML() {
        if (this.timeEventDataBinding != null) {
            return this.timeEventDataBinding.generateXML();
        }
        if (this.fileEventDataBinding != null) {
            return this.fileEventDataBinding.generateXML();
        }
        if (this.groupingEventDataBinding != null) {
            return this.groupingEventDataBinding.generateXML();
        }
        return null;
    }

    public void initFromNode(Node node) throws SchedulerException {
        NamedNodeMap map = node.getAttributes();
        String type = map.getNamedItem("Type").getNodeValue();
        if (type != null) {
            if (type.compareTo("Time") == 0) {
                this.timeEventDataBinding = new TimeEventInfo();
                this.timeEventDataBinding.initFromNode(node);
                this.typeDataBinding = "TimeEvent";
            } else if (type.compareTo("File") == 0) {
                this.fileEventDataBinding = new FileEventInfo();
                this.fileEventDataBinding.initFromNode(node);
                this.typeDataBinding = "FileEvent";
            }
        }
    }

    public void initFromNode(Node node, String grouping) throws SchedulerException {
        this.groupingEventDataBinding = new GroupingEventInfo();
        this.groupingEventDataBinding.conditionDataBinding = grouping.equals("AND") ? 0 : 1;
        this.typeDataBinding = "Gate";
        NodeList jnodes = node.getChildNodes();
        int numJNodes = jnodes.getLength();
        for (int i = 0; i < numJNodes; ++i) {
            NamedNodeMap map;
            String type;
            Node jnode = jnodes.item(i);
            if (!jnode.getNodeName().equals("Event") || (type = (map = jnode.getAttributes()).getNamedItem("Type").getNodeValue()) == null) continue;
            if (type.compareTo("Time") == 0) {
                TimeEventInfo te = new TimeEventInfo();
                te.initFromNode(jnode);
                this.groupingEventDataBinding.addDependency(te);
                continue;
            }
            if (type.compareTo("File") != 0) continue;
            FileEventInfo fe = new FileEventInfo();
            fe.initFromNode(jnode);
            this.groupingEventDataBinding.addDependency(fe);
        }
    }

    static {
        String strClassName = TriggerEventInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        IconName = m_bundle.getString("Default.image");
    }
}

