/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.FlowEventInterface;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.OpaqueRecurrence;
import com.sas.scheduler.model.RecurrenceBaseClass;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TimeEventInfo", propOrder={"schedulerDataBinding", "recurrenceDataBinding", "userDataBinding", "hoursDataBinding", "minutesDataBinding", "durationDataBinding", "timezoneDataBinding", "occurDataBinding"})
public class TimeEventInfo
extends AbstractEventInfo
implements Serializable,
FlowEventInterface,
AbstractEventInterface {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="SchedulerServer", required=true)
    protected SchedulerServerInfo schedulerDataBinding;
    @XmlElement(name="Recurrence", required=true)
    protected RecurrenceBaseClass recurrenceDataBinding;
    @XmlElement(name="User", required=true)
    protected String userDataBinding;
    @XmlElement(name="Hours", required=true)
    protected String hoursDataBinding;
    @XmlElement(name="Minutes", required=true)
    protected String minutesDataBinding;
    @XmlElement(name="Duration")
    protected int durationDataBinding;
    @XmlElement(name="Timezone", required=true)
    protected String timezoneDataBinding;
    @XmlElement(name="Occurrence")
    protected int occurDataBinding;
    private static final ResourceBundle m_bundle;
    public static final String IconName;

    public TimeEventInfo() {
        this(null, null, null, "", "0", "00", 1, -1, null);
    }

    public TimeEventInfo(IRecurrenceInfo calInfo, String userName, String hours, String minutes, int duration) {
        this(calInfo, userName, hours, minutes, duration, -1, null);
    }

    public TimeEventInfo(IRecurrenceInfo calInfo, String userName, String hours, String minutes, int duration, int occur) {
        this(TimeEventInfo.toStringShortDesc(calInfo, hours, minutes, String.valueOf(duration), null, Locale.getDefault()), TimeEventInfo.toString(calInfo, hours, minutes, String.valueOf(duration), null, Locale.getDefault()), calInfo, userName, hours, minutes, duration, occur, null);
    }

    public TimeEventInfo(IRecurrenceInfo calInfo, String userName, String hours, String minutes, int duration, String timezoneId) {
        this(TimeEventInfo.toStringShortDesc(calInfo, hours, minutes, String.valueOf(duration), timezoneId, Locale.getDefault()), TimeEventInfo.toString(calInfo, hours, minutes, String.valueOf(duration), timezoneId, Locale.getDefault()), calInfo, userName, hours, minutes, duration, -1, timezoneId);
    }

    public TimeEventInfo(IRecurrenceInfo calInfo, String userName, String hours, String minutes, int duration, int occur, String timezoneId) {
        this(TimeEventInfo.toStringShortDesc(calInfo, hours, minutes, String.valueOf(duration), timezoneId, Locale.getDefault()), TimeEventInfo.toString(calInfo, hours, minutes, String.valueOf(duration), timezoneId, Locale.getDefault()), calInfo, userName, hours, minutes, duration, occur, timezoneId);
    }

    private TimeEventInfo(String name, String description, IRecurrenceInfo calInfo, String userName, String hours, String minutes, int duration, int occur, String timezoneId) {
        super(name, description, IconName);
        this.recurrenceDataBinding = (RecurrenceBaseClass)calInfo;
        this.hoursDataBinding = hours;
        this.minutesDataBinding = minutes;
        this.timezoneDataBinding = timezoneId;
        this.durationDataBinding = duration;
        this.occurDataBinding = occur;
        this.userDataBinding = userName;
        if (minutes != null && minutes.length() == 1) {
            if (minutes.compareTo("0") == 0) {
                this.minutesDataBinding = "00";
            } else if (minutes.compareTo("1") == 0) {
                this.minutesDataBinding = "01";
            } else if (minutes.compareTo("2") == 0) {
                this.minutesDataBinding = "02";
            } else if (minutes.compareTo("3") == 0) {
                this.minutesDataBinding = "03";
            } else if (minutes.compareTo("4") == 0) {
                this.minutesDataBinding = "04";
            } else if (minutes.compareTo("5") == 0) {
                this.minutesDataBinding = "05";
            } else if (minutes.compareTo("6") == 0) {
                this.minutesDataBinding = "06";
            } else if (minutes.compareTo("7") == 0) {
                this.minutesDataBinding = "07";
            } else if (minutes.compareTo("8") == 0) {
                this.minutesDataBinding = "08";
            } else if (minutes.compareTo("9") == 0) {
                this.minutesDataBinding = "09";
            }
        }
    }

    public SchedulerServerInfo getSchedulerDataBinding() {
        return this.schedulerDataBinding;
    }

    public void setSchedulerDataBinding(SchedulerServerInfo value) {
        this.schedulerDataBinding = value;
    }

    public RecurrenceBaseClass getRecurrenceDataBinding() {
        return this.recurrenceDataBinding;
    }

    public void setRecurrenceDataBinding(RecurrenceBaseClass value) {
        this.recurrenceDataBinding = value;
    }

    public String getUserDataBinding() {
        return this.userDataBinding;
    }

    public void setUserDataBinding(String value) {
        this.userDataBinding = value;
    }

    public String getHoursDataBinding() {
        return this.hoursDataBinding;
    }

    public void setHoursDataBinding(String value) {
        this.hoursDataBinding = value;
    }

    public String getMinutesDataBinding() {
        return this.minutesDataBinding;
    }

    public void setMinutesDataBinding(String value) {
        this.minutesDataBinding = value;
    }

    public int getDurationDataBinding() {
        return this.durationDataBinding;
    }

    public void setDurationDataBinding(int value) {
        this.durationDataBinding = value;
    }

    public String getTimezoneDataBinding() {
        return this.timezoneDataBinding;
    }

    public void setTimezoneDataBinding(String value) {
        this.timezoneDataBinding = value;
    }

    public int getOccurDataBinding() {
        return this.occurDataBinding;
    }

    public void setOccurDataBinding(int value) {
        this.occurDataBinding = value;
    }

    public String getType() {
        return "TimeEvent";
    }

    @Override
    public String toString() {
        return TimeEventInfo.toStringIMPL(this.getName(), true, this.recurrenceDataBinding, this.hoursDataBinding, this.minutesDataBinding, String.valueOf(this.durationDataBinding), String.valueOf(this.occurDataBinding), this.timezoneDataBinding, Locale.getDefault());
    }

    public String toString(Locale locale) {
        return TimeEventInfo.toStringIMPL(this.getName(), true, this.recurrenceDataBinding, this.hoursDataBinding, this.minutesDataBinding, String.valueOf(this.durationDataBinding), String.valueOf(this.occurDataBinding), this.timezoneDataBinding, locale);
    }

    public String toStringNoDuration(Locale locale) {
        return TimeEventInfo.toStringIMPL(this.getName(), true, this.recurrenceDataBinding, this.hoursDataBinding, this.minutesDataBinding, "", String.valueOf(this.occurDataBinding), this.timezoneDataBinding, locale);
    }

    public String toStringShortDesc(Locale locale) {
        return TimeEventInfo.toStringIMPL(this.getName(), true, this.recurrenceDataBinding, this.hoursDataBinding, this.minutesDataBinding, "", null, null, locale);
    }

    public static String toString(IRecurrenceInfo rinfo, String hours, String minutes, String duration, Locale locale) {
        return TimeEventInfo.toStringIMPL("", false, rinfo, hours, minutes, duration, null, null, locale);
    }

    public static String toString(IRecurrenceInfo rinfo, String hours, String minutes, String duration, String timezone, Locale locale) {
        return TimeEventInfo.toStringIMPL("", false, rinfo, hours, minutes, duration, null, timezone, locale);
    }

    public static String toStringNoDuration(IRecurrenceInfo rinfo, String hours, String minutes, String duration, Locale locale) {
        return TimeEventInfo.toStringShortDesc(rinfo, hours, minutes, duration, null, null, locale);
    }

    public static String toStringShortDesc(IRecurrenceInfo rinfo, String hours, String minutes, String duration, String timezone, Locale locale) {
        return TimeEventInfo.toStringIMPL("", true, rinfo, hours, minutes, "", null, null, locale);
    }

    public static String toStringShortDesc(IRecurrenceInfo rinfo, String hours, String minutes, String duration, String occur, String timezone, Locale locale) {
        return TimeEventInfo.toStringIMPL("", true, rinfo, hours, minutes, "", occur, timezone, locale);
    }

    private static String toStringIMPL(String name, boolean shortdesc, IRecurrenceInfo rinfo, String hours, String minutes, String duration, String occur, String timezone, Locale locale) {
        String display = name;
        if (rinfo != null) {
            if (rinfo instanceof OpaqueRecurrence) {
                display = ((OpaqueRecurrence)rinfo).toString(locale, hours, minutes, duration);
            } else {
                String recurrence = rinfo.toString(locale);
                Object[] args = new Object[]{recurrence, hours, minutes, duration, occur, timezone};
                display = shortdesc ? (occur != null && occur.length() > 0 && !occur.equalsIgnoreCase("-1") ? MessageFormat.format(m_bundle.getString("TimeEventInfo.ShortFullDisplayName.fmt"), args) : (timezone != null ? MessageFormat.format(m_bundle.getString("TimeEventInfo.ShortTimezoneDisplayName.fmt"), args) : MessageFormat.format(m_bundle.getString("TimeEventInfo.ShortDisplayName.fmt"), args))) : (occur != null && occur.length() > 0 && !occur.equalsIgnoreCase("-1") ? MessageFormat.format(m_bundle.getString("TimeEventInfo.FullDisplayName.fmt"), args) : (timezone != null ? MessageFormat.format(m_bundle.getString("TimeEventInfo.TimezoneDisplayName.fmt"), args) : MessageFormat.format(m_bundle.getString("TimeEventInfo.DisplayName.fmt"), args)));
            }
        }
        return display;
    }

    public SchedulerServerInfo getScheduler() {
        return this.schedulerDataBinding;
    }

    public boolean setScheduler(SchedulerServerInfo scheduler) {
        this.schedulerDataBinding = scheduler;
        return true;
    }

    public IRecurrenceInfo getRecurrence() {
        return this.recurrenceDataBinding;
    }

    public boolean setRecurrence(IRecurrenceInfo recurrence) {
        this.recurrenceDataBinding = (RecurrenceBaseClass)recurrence;
        return true;
    }

    public String getHours() {
        return this.hoursDataBinding;
    }

    public boolean setHours(String hourString) {
        if (this.validateHours(hourString)) {
            this.hoursDataBinding = hourString;
            return true;
        }
        return false;
    }

    public String getMinutes() {
        return this.minutesDataBinding;
    }

    public boolean setMinutes(String minuteString) {
        if (this.validateMinutes(minuteString)) {
            this.minutesDataBinding = minuteString;
            return true;
        }
        return false;
    }

    public String getTimezoneId() {
        return this.timezoneDataBinding;
    }

    public boolean setTimezoneId(String timezoneId) {
        if (timezoneId == null) {
            this.timezoneDataBinding = null;
            return true;
        }
        String id = this.oldValidateTimezone(timezoneId);
        if (id != null) {
            this.timezoneDataBinding = id;
            return true;
        }
        return false;
    }

    public String getTimezone() {
        return this.timezoneDataBinding;
    }

    public boolean setTimezone(String timezoneId) {
        if (this.validateTimezone(timezoneId)) {
            this.timezoneDataBinding = timezoneId;
            return true;
        }
        return false;
    }

    public int getOccur() {
        return this.occurDataBinding;
    }

    public boolean setOccur(int occur) {
        if (this.validateOccur(occur)) {
            this.occurDataBinding = occur;
            return true;
        }
        return false;
    }

    public int getDuration() {
        return this.durationDataBinding;
    }

    public boolean setDuration(int duration) {
        if (this.validateDuration(duration)) {
            this.durationDataBinding = duration;
            return true;
        }
        return false;
    }

    public String getUser() {
        return this.userDataBinding;
    }

    public boolean setUser(String user) {
        this.userDataBinding = user;
        return true;
    }

    public boolean isIndefinite() {
        if (this.recurrenceDataBinding instanceof AbstractRecurrence) {
            Calendar cal = ((AbstractRecurrence)this.recurrenceDataBinding).getEndDate();
            return cal == null;
        }
        return false;
    }

    private boolean validateDuration(int duration) {
        return duration >= 1;
    }

    private boolean validateOccur(int occur) {
        return occur >= 1;
    }

    private String oldValidateTimezone(String id) {
        if (id.length() > 0) {
            String[] timezones = TimeZone.getAvailableIDs();
            int length = timezones.length;
            for (int i = 0; i < length; ++i) {
                if (id.compareTo(timezones[i]) != 0) continue;
                com.ibm.icu.util.TimeZone zone = com.ibm.icu.util.TimeZone.getTimeZone((String)id);
                return zone != null ? zone.getID() : null;
            }
        }
        return null;
    }

    private boolean validateTimezone(String id) {
        if (id == null) {
            return true;
        }
        if (id.length() > 0) {
            String[] timezones = com.ibm.icu.util.TimeZone.getAvailableIDs();
            int length = timezones.length;
            for (int i = 0; i < length; ++i) {
                if (id.compareTo(timezones[i]) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validateMinutes(String minutes) {
        return minutes.length() > 0;
    }

    private boolean validateHours(String hours) {
        return hours.length() > 0;
    }

    @Override
    public String generateXML() {
        String xmlString = null;
        if (this.recurrenceDataBinding == null) {
            return null;
        }
        xmlString = this.recurrenceDataBinding.toXML();
        if (xmlString == null) {
            return null;
        }
        StringBuffer timeXML = new StringBuffer();
        String desc = this.getDescription();
        if (desc != null && desc.indexOf(">") > 0) {
            desc = "";
        }
        timeXML.append("<Event Type=\"Time\" Description=\"" + desc + "\">\n");
        timeXML.append(xmlString);
        String temp = "<time>" + this.hoursDataBinding + ":" + this.minutesDataBinding + ":" + this.durationDataBinding;
        if (this.occurDataBinding != -1) {
            temp = temp + "#" + this.occurDataBinding;
        }
        if (this.timezoneDataBinding != null) {
            temp = temp + "+" + this.timezoneDataBinding;
        }
        timeXML.append(temp + "</time>\n");
        timeXML.append("</Event>\n");
        return timeXML.toString();
    }

    @Override
    public String generateXML(boolean exportFormat) {
        return this.generateXML();
    }

    public void initFromXML(String xml) throws SchedulerException {
        Document doc = GeneralUtilities.parseXML(xml);
        Node node = doc.getElementsByTagName("Event").item(0);
        this.initFromNode(node);
    }

    public void initFromNode(Node node) throws SchedulerException {
        try {
            NamedNodeMap map = node.getAttributes();
            String type = map.getNamedItem("Type").getNodeValue();
            if (type.compareTo("Time") != 0) {
                SchedulerException se = new SchedulerException("Invalid Type");
                throw se;
            }
            NodeList cnodes = node.getChildNodes();
            int numCNodes = cnodes.getLength();
            for (int x = 0; x < numCNodes; ++x) {
                Node cnode = cnodes.item(x);
                String tagname = cnode.getNodeName();
                if (tagname.compareTo("time") == 0) {
                    int thirdColon;
                    int secondColon;
                    String timeString = cnode.getFirstChild().getNodeValue();
                    int firstColon = timeString.indexOf(58);
                    if (firstColon > 0) {
                        this.hoursDataBinding = timeString.substring(0, firstColon);
                    }
                    if ((secondColon = timeString.indexOf(58, firstColon + 1)) > 0) {
                        this.minutesDataBinding = timeString.substring(firstColon + 1, secondColon);
                    }
                    if ((thirdColon = timeString.indexOf(58, secondColon + 1)) > 0) {
                        this.durationDataBinding = Integer.parseInt(timeString.substring(secondColon + 1, thirdColon));
                        this.timezoneDataBinding = timeString.substring(thirdColon + 1);
                        continue;
                    }
                    int hash = timeString.indexOf(35);
                    int tick = timeString.indexOf(43);
                    if (hash > 0) {
                        this.durationDataBinding = Integer.parseInt(timeString.substring(secondColon + 1, hash));
                        if (tick > 0) {
                            this.occurDataBinding = Integer.parseInt(timeString.substring(hash + 1), tick);
                            this.timezoneDataBinding = timeString.substring(tick + 1);
                            continue;
                        }
                        this.occurDataBinding = Integer.parseInt(timeString.substring(hash + 1));
                        this.timezoneDataBinding = null;
                        continue;
                    }
                    if (tick > 0) {
                        this.durationDataBinding = Integer.parseInt(timeString.substring(secondColon + 1, tick));
                        this.occurDataBinding = -1;
                        this.timezoneDataBinding = timeString.substring(tick + 1);
                        continue;
                    }
                    this.durationDataBinding = Integer.parseInt(timeString.substring(secondColon + 1));
                    this.occurDataBinding = -1;
                    this.timezoneDataBinding = null;
                    continue;
                }
                if (tagname.compareTo("schedule") != 0) continue;
                this.recurrenceDataBinding = (RecurrenceBaseClass)this.createFromNode(cnode);
            }
        }
        catch (NullPointerException npe) {
            SchedulerException se = new SchedulerException();
            se.initCause(npe);
            throw se;
        }
        catch (RuntimeException rte) {
            SchedulerException se = new SchedulerException();
            se.initCause(rte);
            throw se;
        }
    }

    private IRecurrenceInfo createFromNode(Node node) {
        try {
            return RecurrenceBaseClass.createFromNode(node);
        }
        catch (SchedulerException schedulerException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    static {
        String strClassName = TimeEventInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        IconName = m_bundle.getString("TimeEvent.image");
    }
}

