/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.JobRendererInfo;
import com.sas.scheduler.model.RunningItemInfo;
import com.sas.svcs.commons.webservice.jaxb.JaxbCalendarXmlAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RunHistory", propOrder={"startTimeDataBinding", "finishTimeDataBinding", "userNameDataBinding", "completionCodeDataBinding", "uniqueItemIdDataBinding", "itemNameDataBinding", "parentNameDataBinding", "retryAttemptsDataBinding", "rendererDataBinding"})
public class RunHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="StartTime", required=true, type=String.class)
    @XmlJavaTypeAdapter(value=JaxbCalendarXmlAdapter.class)
    @XmlSchemaType(name="date")
    protected Calendar startTimeDataBinding = null;
    @XmlElement(name="FinishTime", required=true, type=String.class)
    @XmlJavaTypeAdapter(value=JaxbCalendarXmlAdapter.class)
    @XmlSchemaType(name="date")
    protected Calendar finishTimeDataBinding = null;
    @XmlElement(name="UserName")
    protected String userNameDataBinding = "";
    @XmlElement(name="CompletionCode")
    protected int completionCodeDataBinding = 0;
    @XmlElement(name="UniqueItemId")
    protected String uniqueItemIdDataBinding = "";
    @XmlElement(name="ItemName")
    protected String itemNameDataBinding = "";
    @XmlElement(name="ParentName")
    protected String parentNameDataBinding = "";
    @XmlElement(name="RetryAttempts")
    protected int retryAttemptsDataBinding = 0;
    @XmlElement(name="Renderer")
    protected String rendererDataBinding = null;
    public static final String TopLevelFlowTerminatorLine = "#";
    public static final String ItemSeparator = ",";
    public static final int COMPLETION_CODE_UNSET = 0;
    public static final int COMPLETION_CODE_KILLED = 1;
    public static final int COMPLETION_CODE_EXIT = 2;
    public static final int COMPLETION_CODE_DONE = 4;
    public static final int COMPLETION_CODE_RUNNING = 8;
    public static final int COMPLETION_CODE_WAITING = 16;
    public static final int COMPLETION_CODE_NOTRUN = 32;
    public static final int COMPLETION_CODE_HELD = 64;
    public static final int COMPLETION_CODE_FAILED_RUN = 128;
    protected static final String m_version = "2";
    public static String EscapeSequence = "\\char";
    public static char HistorySeparator = JobRendererInfo.Separator;
    private static final String UserName_Tag = HistorySeparator + "UserName=";
    private static final String StartTime_Tag = HistorySeparator + "StartTime=";
    private static final String FinishTime_Tag = HistorySeparator + "FinishTime=";
    private static final String TimeZoneTag = HistorySeparator + "TimeZone=";
    private static final String FinishState_Tag = HistorySeparator + "FinishState=";
    private static final String UniqueID_Tag = HistorySeparator + "UniqueID=";
    private static final String ItemName_Tag = HistorySeparator + "ItemName=";
    private static final String Version_Tag = HistorySeparator + "Version=";
    private static final String RetryAttempts_Tag = HistorySeparator + "Retries=";
    private static final String Renderer_Tag = HistorySeparator + "Renderer=";

    public RunHistory() {
    }

    public RunHistory(RunningItemInfo completedItem) {
        this();
        this.startTimeDataBinding = completedItem.getStartTime() != null ? (Calendar)completedItem.getStartTime().clone() : null;
        this.finishTimeDataBinding = completedItem.getFinishTime() != null ? (Calendar)completedItem.getFinishTime().clone() : null;
        this.userNameDataBinding = completedItem.getUserName();
        this.itemNameDataBinding = completedItem.getName();
        this.completionCodeDataBinding = completedItem.getCompletionCode();
        this.retryAttemptsDataBinding = completedItem.getRetryAttempts();
    }

    public Calendar getFinishTimeDataBinding() {
        return this.finishTimeDataBinding;
    }

    public void setFinishTimeDataBinding(Calendar cal) {
        this.finishTimeDataBinding = cal;
    }

    public Calendar getStartTimeDataBinding() {
        return this.startTimeDataBinding;
    }

    public void setStartTimeDataBinding(Calendar cal) {
        this.startTimeDataBinding = cal;
    }

    public String getUserNameDataBinding() {
        return this.userNameDataBinding;
    }

    public void setUserNameDataBinding(String name) {
        this.userNameDataBinding = name;
    }

    public int getCompletionCodeDataBinding() {
        return this.completionCodeDataBinding;
    }

    public void setCompletionCodeDataBinding(int value) {
        this.completionCodeDataBinding = value;
    }

    public String getItemNameDataBinding() {
        return this.itemNameDataBinding;
    }

    public void setItemNameDataBinding(String value) {
        this.itemNameDataBinding = value;
    }

    public String getParentNameDataBinding() {
        return this.parentNameDataBinding;
    }

    public void setParentNameDataBinding(String value) {
        this.parentNameDataBinding = value;
    }

    public String getUniqueIdDataBinding() {
        return this.uniqueItemIdDataBinding;
    }

    public void setUniqueIdDataBinding(String value) {
        this.uniqueItemIdDataBinding = value;
    }

    public int getRetryAttemptsDataBinding() {
        return this.retryAttemptsDataBinding;
    }

    public void setRetryAttemptsDataBinding(int value) {
        this.retryAttemptsDataBinding = value;
    }

    public String getRendererDataBinding() {
        return this.rendererDataBinding;
    }

    public void setRendererDataBinding(String value) {
        this.rendererDataBinding = value;
    }

    public String getCompletionStringDataBinding() {
        return RunHistory.getCompletionAsString(this.getCompletionCodeDataBinding());
    }

    public String toSerializedForm() {
        StringBuffer buffer = new StringBuffer();
        this.toSerializedForm(buffer);
        buffer.append("\n");
        buffer.append("#\n");
        return buffer.toString();
    }

    public void toSerializedForm(StringBuffer buffer) {
        buffer.append(Version_Tag);
        buffer.append(m_version);
        buffer.append(UserName_Tag);
        buffer.append(RunHistory.getEscapedString(this.userNameDataBinding));
        buffer.append(StartTime_Tag);
        this.calendarToBuffer(buffer, this.startTimeDataBinding);
        buffer.append(FinishTime_Tag);
        this.calendarToBuffer(buffer, this.finishTimeDataBinding);
        buffer.append(TimeZoneTag);
        if (this.startTimeDataBinding != null) {
            buffer.append(RunHistory.getEscapedString(this.startTimeDataBinding.getTimeZone().getID()));
        }
        buffer.append(FinishState_Tag);
        buffer.append(this.completionCodeDataBinding);
        buffer.append(UniqueID_Tag);
        buffer.append(RunHistory.getEscapedString(this.uniqueItemIdDataBinding));
        buffer.append(ItemName_Tag);
        buffer.append(RunHistory.getEscapedString(this.itemNameDataBinding));
        buffer.append(RetryAttempts_Tag);
        buffer.append(Integer.toString(this.retryAttemptsDataBinding));
        buffer.append(Renderer_Tag);
        buffer.append(RunHistory.getEscapedString(this.rendererDataBinding));
    }

    public static String getUnescapedString(String escapedName) {
        if (escapedName.indexOf(EscapeSequence) < 0) {
            return escapedName;
        }
        StringBuffer buffer = new StringBuffer(escapedName.length());
        int stringLength = escapedName.length();
        for (int i = 0; i < stringLength; ++i) {
            int nextSlash;
            char character = escapedName.charAt(i);
            boolean characterCodeProcessed = false;
            if (character == '\\' && escapedName.substring(i, i + EscapeSequence.length()).equals(EscapeSequence) && (nextSlash = escapedName.indexOf(92, i + EscapeSequence.length())) >= 0) {
                String characterCodeString = escapedName.substring(i + EscapeSequence.length(), nextSlash);
                int characterCode = Integer.parseInt(characterCodeString);
                characterCodeProcessed = true;
                i = nextSlash;
                buffer.append((char)characterCode);
            }
            if (characterCodeProcessed) continue;
            buffer.append(character);
        }
        return buffer.toString();
    }

    public static String getEscapedString(String name) {
        if (name.indexOf(HistorySeparator) < 0 && name.indexOf(13) < 0 && name.indexOf(10) < 0) {
            return name;
        }
        StringBuffer buffer = new StringBuffer(name.length() + 5);
        for (int i = 0; i < name.length(); ++i) {
            char character = name.charAt(i);
            if (character == '\r' || character == '\n' || character == HistorySeparator) {
                buffer.append(EscapeSequence + character + "\\");
                continue;
            }
            buffer.append(character);
        }
        return buffer.toString();
    }

    private void calendarToBuffer(StringBuffer buffer, Calendar time) {
        if (time != null) {
            buffer.append(Long.toString(time.getTimeInMillis()));
        }
    }

    public int getFullSubItemCount() {
        return 0;
    }

    public static String GetParameterFromHistoryLine(String historyLine, String parmName) {
        int index = historyLine.indexOf(parmName);
        if (index < 0) {
            return "";
        }
        int separatorIndex = historyLine.indexOf(HistorySeparator, index + parmName.length());
        if (separatorIndex < 0) {
            separatorIndex = historyLine.length();
        }
        String dataString = historyLine.substring(index + parmName.length(), separatorIndex);
        return dataString;
    }

    protected void createFromData(String flowLine) {
        this.userNameDataBinding = RunHistory.getUnescapedString(RunHistory.GetParameterFromHistoryLine(flowLine, UserName_Tag));
        String startTime = RunHistory.GetParameterFromHistoryLine(flowLine, StartTime_Tag);
        String finishTime = RunHistory.GetParameterFromHistoryLine(flowLine, FinishTime_Tag);
        String timeZone = RunHistory.getUnescapedString(RunHistory.GetParameterFromHistoryLine(flowLine, TimeZoneTag));
        this.startTimeDataBinding = this.createCalendarFromString(startTime, timeZone);
        this.finishTimeDataBinding = this.createCalendarFromString(finishTime, timeZone);
        String completionCode = RunHistory.GetParameterFromHistoryLine(flowLine, FinishState_Tag);
        try {
            this.completionCodeDataBinding = Integer.parseInt(completionCode);
        }
        catch (Exception e) {
            this.completionCodeDataBinding = 0;
        }
        this.itemNameDataBinding = RunHistory.getUnescapedString(RunHistory.GetParameterFromHistoryLine(flowLine, ItemName_Tag));
        this.uniqueItemIdDataBinding = RunHistory.getUnescapedString(RunHistory.GetParameterFromHistoryLine(flowLine, UniqueID_Tag));
        String attemptsString = RunHistory.GetParameterFromHistoryLine(flowLine, RetryAttempts_Tag);
        if (!attemptsString.isEmpty()) {
            try {
                this.retryAttemptsDataBinding = Integer.parseInt(attemptsString);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    private Calendar createCalendarFromString(String timeString, String timeZoneID) {
        if (timeString.length() == 0) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        long utcValue = 0L;
        try {
            utcValue = Long.parseLong(timeString);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        cal.setTimeInMillis(utcValue);
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneID);
        if (timeZone != null) {
            ((Calendar)cal).setTimeZone(timeZone);
        }
        return cal;
    }

    public String toString() {
        return this.toSerializedForm();
    }

    public static String getCompletionAsString(int code) {
        switch (code) {
            case 4: {
                return "Done";
            }
            case 2: {
                return "Exited";
            }
            case 128: {
                return "FailedToRun";
            }
            case 64: {
                return "Held";
            }
            case 1: {
                return "Killed";
            }
            case 32: {
                return "NotRun";
            }
            case 8: {
                return "Running";
            }
            case 16: {
                return "Waiting";
            }
        }
        return "Unknown";
    }
}

