/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowEventInterface;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.TimeEventInfo;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="GroupingEventInfo", propOrder={"targetDataBinding", "conditionDataBinding", "eventsDataBinding"})
public class GroupingEventInfo
extends AbstractEventInfo
implements Serializable,
FlowEventInterface,
AbstractEventInterface {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Target", required=true)
    protected DisplayInfo targetDataBinding;
    @XmlElement(name="Condition")
    protected int conditionDataBinding;
    @XmlElement(name="Event")
    protected List<AbstractEventInfo> eventsDataBinding;
    private static final ResourceBundle m_bundle;
    public static final String IconName;
    public static final int AND = 0;
    public static final int OR = 1;

    public GroupingEventInfo() {
        super("", null, IconName);
        this.conditionDataBinding = -1;
        this.eventsDataBinding = new ArrayList<AbstractEventInfo>();
    }

    public GroupingEventInfo(JobInfo target) {
        super("", null, IconName);
        this.setId(String.valueOf(this.hashCode()));
        this.targetDataBinding = target;
        this.conditionDataBinding = -1;
        this.eventsDataBinding = new ArrayList<AbstractEventInfo>();
    }

    public GroupingEventInfo(FlowInfo target) {
        super("", null, IconName);
        this.setId(String.valueOf(this.hashCode()));
        this.targetDataBinding = target;
        this.conditionDataBinding = -1;
        this.eventsDataBinding = new ArrayList<AbstractEventInfo>();
    }

    public GroupingEventInfo(JobInfo target, int type) {
        this(target);
        this.setEventType(type);
    }

    public DisplayInfo getTargetDataBinding() {
        return this.targetDataBinding;
    }

    public void setTargetDataBinding(DisplayInfo value) {
        this.targetDataBinding = value;
    }

    public int getConditionDataBinding() {
        return this.conditionDataBinding;
    }

    public void setConditionDataBinding(int value) {
        this.conditionDataBinding = value;
    }

    public List<DisplayInfo> getEventsDataBinding() {
        ArrayList<DisplayInfo> temp = new ArrayList<DisplayInfo>();
        if (this.eventsDataBinding != null) {
            temp.addAll(this.eventsDataBinding);
        }
        return temp;
    }

    public void setEventsDataBinding(List<DisplayInfo> events) {
        this.eventsDataBinding = new ArrayList<AbstractEventInfo>();
        Iterator<DisplayInfo> i = events.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof AbstractEventInfo)) continue;
            AbstractEventInfo a = (AbstractEventInfo)((Object)i);
            this.eventsDataBinding.add(a);
        }
    }

    public List<AbstractEventInfo> getEvents() {
        if (this.eventsDataBinding == null) {
            this.eventsDataBinding = new ArrayList<AbstractEventInfo>();
        }
        return this.eventsDataBinding;
    }

    public void setEvents(List<AbstractEventInfo> events) {
        this.eventsDataBinding = events;
    }

    public boolean addDependency(AbstractEventInfo object) {
        return this.eventsDataBinding.add(object);
    }

    public boolean removeDependency(AbstractEventInfo object) {
        if (this.eventsDataBinding.remove(object)) {
            return true;
        }
        boolean rc = false;
        Iterator<AbstractEventInfo> i = this.eventsDataBinding.iterator();
        while (i.hasNext() && !rc) {
            DisplayInfo obj = i.next();
            if (!(obj instanceof GroupingEventInfo)) continue;
            rc = ((GroupingEventInfo)obj).removeDependency(object);
        }
        return rc;
    }

    public List<DisplayInfo> getDependencies() {
        return this.getEventsDataBinding();
    }

    public boolean setDependencies(List<DisplayInfo> objects) {
        this.eventsDataBinding.clear();
        for (DisplayInfo di : objects) {
            if (!(di instanceof AbstractEventInfo)) continue;
            this.eventsDataBinding.add((AbstractEventInfo)di);
        }
        return true;
    }

    public List<AbstractEventInfo> getDependencies2() {
        return this.eventsDataBinding;
    }

    public boolean setDependencies2(List<AbstractEventInfo> objects) {
        this.eventsDataBinding.clear();
        return this.eventsDataBinding.addAll(objects);
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        return GroupingEventInfo.toString(this.conditionDataBinding, locale);
    }

    public static String toString(int type, Locale locale) {
        if (type == 0) {
            return m_bundle.getString("GroupingEventInfo.Condition.And.txt");
        }
        return m_bundle.getString("GroupingEventInfo.Condition.Or.txt");
    }

    public int getEventType() {
        return this.conditionDataBinding;
    }

    public DisplayInfo getTarget() {
        return this.targetDataBinding;
    }

    public boolean setTarget(JobInfo target) {
        this.targetDataBinding = target;
        this.setId(String.valueOf(this.hashCode()));
        return true;
    }

    public boolean setTarget(FlowInfo target) {
        this.targetDataBinding = target;
        this.setId(String.valueOf(this.hashCode()));
        return true;
    }

    public boolean setEventType(int type) {
        if (type != 0 && type != 1) {
            return false;
        }
        this.conditionDataBinding = type;
        return true;
    }

    @Override
    public String generateXML() {
        return this.generateXML(false);
    }

    @Override
    public String generateXML(boolean exportFormat) {
        StringBuffer buffer = new StringBuffer();
        if (this.conditionDataBinding == 0) {
            buffer.append("<Events CombinationType=\"AND\">\n");
        } else {
            buffer.append("<Events CombinationType=\"OR\">\n");
        }
        for (AbstractEventInfo obj : this.eventsDataBinding) {
            String xml = null;
            if (obj instanceof FileEventInfo) {
                xml = ((FileEventInfo)obj).generateXML(exportFormat);
            } else if (obj instanceof TimeEventInfo) {
                xml = ((TimeEventInfo)obj).generateXML(exportFormat);
            } else if (obj instanceof JobEventInfo) {
                xml = ((JobEventInfo)obj).generateXML(exportFormat);
            } else if (obj instanceof GroupingEventInfo) {
                xml = ((GroupingEventInfo)obj).generateXML(exportFormat);
            }
            if (xml == null) continue;
            buffer.append(xml);
        }
        buffer.append("</Events>\n");
        return buffer.toString();
    }

    public void writeObject(OutputStream out, String prefix) throws IOException {
        byte[] b = null;
        byte[] newline = "\n".getBytes();
        String s = null;
        if (this.eventsDataBinding != null) {
            int num = this.eventsDataBinding == null ? 0 : this.eventsDataBinding.size();
            for (int i = 0; i < num; ++i) {
                DisplayInfo obj = this.eventsDataBinding.get(i);
                out.write(prefix.getBytes());
                s = "Object: " + obj.getId() + ":" + obj.toString();
                b = s.getBytes();
                out.write(b);
                out.write(newline);
                if (!(obj instanceof GroupingEventInfo)) continue;
                String newprefix = prefix + "\t";
                ((GroupingEventInfo)obj).writeObject(out, newprefix);
            }
        }
    }

    static {
        String strClassName = GroupingEventInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        IconName = m_bundle.getString("Grouping.image");
    }
}

