/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.InvalidRecurrenceException;
import com.sas.scheduler.model.RecurrenceBaseClass;
import com.sas.svcs.commons.webservice.jaxb.JaxbCalendarXmlAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractRecurrence", propOrder={"startDateDataBinding", "endDateDataBinding", "skipCountDataBinding"})
public abstract class AbstractRecurrence
extends RecurrenceBaseClass
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="StartDate", required=true, type=String.class)
    @XmlJavaTypeAdapter(value=JaxbCalendarXmlAdapter.class)
    @XmlSchemaType(name="date")
    protected Calendar startDateDataBinding = null;
    @XmlElement(name="EndDate", type=String.class)
    @XmlJavaTypeAdapter(value=JaxbCalendarXmlAdapter.class)
    @XmlSchemaType(name="date")
    protected Calendar endDateDataBinding = null;
    @XmlElement(name="SkipCount")
    protected Integer skipCountDataBinding = 1;
    static final String XML_Starttime_Tag = "startTime";
    static final String XML_Endtime_Tag = "endTime";
    static final String XML_SkipCount_Tag = "skipCount";
    static final String XML_SkipCount = "count";

    public Calendar getStartDateDataBinding() {
        return this.startDateDataBinding;
    }

    public void setStartDateDataBinding(Calendar value) {
        this.startDateDataBinding = value;
    }

    public Calendar getEndDateDataBinding() {
        return this.endDateDataBinding;
    }

    public void setEndDateDataBinding(Calendar value) {
        this.endDateDataBinding = value;
    }

    public Integer getSkipCountDataBinding() {
        return this.skipCountDataBinding;
    }

    public void setSkipCountDataBinding(Integer value) {
        this.skipCountDataBinding = value;
    }

    public void setStartDate(Calendar startDate) {
        this.startDateDataBinding = startDate;
    }

    public void setStartTime(Calendar startTime) {
        this.startDateDataBinding = startTime;
    }

    public Calendar getStartDate() {
        return this.startDateDataBinding;
    }

    public Calendar getStartTime() {
        return this.startDateDataBinding;
    }

    public int getSkipCount() {
        return this.skipCountDataBinding;
    }

    public boolean setSkipCount(int skipCount) {
        if (skipCount >= 1) {
            this.skipCountDataBinding = skipCount;
            if (this.skipCountDataBinding >= 2 && this.startDateDataBinding == null) {
                this.startDateDataBinding = new GregorianCalendar(Locale.getDefault());
            }
            return true;
        }
        return false;
    }

    public void setEndDate(Calendar endDate) {
        this.endDateDataBinding = endDate;
    }

    public void setEndTime(Calendar endTime) {
        this.endDateDataBinding = endTime;
    }

    public Calendar getEndDate() {
        return this.endDateDataBinding;
    }

    public Calendar getEndTime() {
        return this.endDateDataBinding;
    }

    @Override
    protected void copyFrom(IRecurrenceInfo source) {
        if (source instanceof AbstractRecurrence) {
            AbstractRecurrence recurrence = (AbstractRecurrence)source;
            this.startDateDataBinding = recurrence.startDateDataBinding != null ? (Calendar)recurrence.startDateDataBinding.clone() : null;
            this.endDateDataBinding = recurrence.endDateDataBinding != null ? (Calendar)recurrence.endDateDataBinding.clone() : null;
            this.skipCountDataBinding = recurrence.skipCountDataBinding;
        }
    }

    @Override
    public void toXML(StringBuffer buffer) {
        buffer.append('<');
        buffer.append(XML_SkipCount_Tag);
        buffer.append(' ');
        buffer.append(XML_SkipCount);
        buffer.append("=");
        buffer.append('\"');
        buffer.append(this.skipCountDataBinding);
        buffer.append('\"');
        buffer.append("/>");
        if (this.startDateDataBinding != null) {
            Calendar startTime = this.startDateDataBinding;
            buffer.append('<');
            buffer.append(XML_Starttime_Tag);
            buffer.append(' ');
            buffer.append("year");
            buffer.append("=");
            buffer.append('\"');
            buffer.append(startTime.get(1));
            buffer.append('\"');
            buffer.append(' ');
            buffer.append("month");
            buffer.append("=");
            buffer.append('\"');
            buffer.append(startTime.get(2) + 1);
            buffer.append('\"');
            buffer.append(' ');
            buffer.append("day");
            buffer.append("=");
            buffer.append('\"');
            buffer.append(startTime.get(5));
            buffer.append('\"');
            buffer.append("/>");
        }
        if (this.endDateDataBinding != null) {
            Calendar endTime = this.endDateDataBinding;
            buffer.append('<');
            buffer.append(XML_Endtime_Tag);
            buffer.append(' ');
            buffer.append("year");
            buffer.append("=");
            buffer.append('\"');
            buffer.append(endTime.get(1));
            buffer.append('\"');
            buffer.append(' ');
            buffer.append("month");
            buffer.append("=");
            buffer.append('\"');
            buffer.append(endTime.get(2) + 1);
            buffer.append('\"');
            buffer.append(' ');
            buffer.append("day");
            buffer.append("=");
            buffer.append('\"');
            buffer.append(endTime.get(5));
            buffer.append('\"');
            buffer.append("/>");
        }
    }

    @Override
    public void injectXML(Document doc, Element tag) {
        Element skipCountTag = doc.createElement(XML_SkipCount_Tag);
        tag.appendChild(skipCountTag);
        skipCountTag.setAttribute(XML_SkipCount, this.skipCountDataBinding.toString());
        if (this.startDateDataBinding != null) {
            Calendar startTime = this.startDateDataBinding;
            Element startTag = doc.createElement(XML_Starttime_Tag);
            tag.appendChild(startTag);
            startTag.setAttribute("year", Integer.toString(startTime.get(1)));
            startTag.setAttribute("month", Integer.toString(startTime.get(2) + 1));
            startTag.setAttribute("day", Integer.toString(startTime.get(5)));
        }
        if (this.endDateDataBinding != null) {
            Calendar endTime = this.endDateDataBinding;
            Element endTag = doc.createElement(XML_Endtime_Tag);
            tag.appendChild(endTag);
            endTag.setAttribute("year", Integer.toString(endTime.get(1)));
            endTag.setAttribute("month", Integer.toString(endTime.get(2) + 1));
            endTag.setAttribute("day", Integer.toString(endTime.get(5)));
        }
    }

    @Override
    public void toShortUniqueString(StringBuffer buffer) {
        buffer.append("sk");
        buffer.append(this.skipCountDataBinding);
        buffer.append('_');
        if (this.startDateDataBinding != null) {
            buffer.append("st" + this.calendarToShortString(this.startDateDataBinding));
            buffer.append('_');
        }
        if (this.endDateDataBinding != null) {
            buffer.append("et" + this.calendarToShortString(this.endDateDataBinding));
            buffer.append('_');
        }
    }

    @Override
    public boolean includesDate(Calendar queryDate) throws InvalidRecurrenceException {
        Calendar endDate = (Calendar)queryDate.clone();
        List<Calendar> results = this.getNextDates(queryDate, endDate, 1);
        if (results.size() > 0) {
            Calendar current = results.get(0);
            return RecurrenceBaseClass.isEqualByDay(current, queryDate);
        }
        return false;
    }

    protected boolean isDateInRange(Calendar date) {
        Calendar calStart = this.getStartDate();
        if (calStart != null && RecurrenceBaseClass.isBeforeByDay(date, calStart)) {
            return false;
        }
        return !this.isDateAfterRange(date);
    }

    protected boolean isDateAfterRange(Calendar date) {
        Calendar calEnd = this.getEndDate();
        return calEnd != null && RecurrenceBaseClass.isAfterByDay(date, calEnd);
    }

    protected void moveCurrentDateJustBeforeQueryDate(Calendar currentDate, Calendar queryDate, int skip, int fieldCode) {
        if (!RecurrenceBaseClass.isBeforeByDay(currentDate, queryDate)) {
            return;
        }
        int multiplier = 1;
        while (true) {
            currentDate.add(fieldCode, skip * multiplier);
            if (!RecurrenceBaseClass.isBeforeByDay(currentDate, queryDate)) break;
            multiplier *= 2;
        }
        if (RecurrenceBaseClass.isEqualByDay(currentDate, queryDate)) {
            return;
        }
        multiplier /= 2;
        multiplier *= -1;
        while (multiplier != 0) {
            currentDate.add(fieldCode, skip * multiplier);
            if (RecurrenceBaseClass.isEqualByDay(currentDate, queryDate)) {
                return;
            }
            multiplier = RecurrenceBaseClass.isBeforeByDay(currentDate, queryDate) ? Math.abs(multiplier) : -Math.abs(multiplier);
            multiplier /= 2;
        }
        while (RecurrenceBaseClass.isAfterByDay(currentDate, queryDate)) {
            currentDate.add(fieldCode, -skip);
        }
    }
}

