/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.util;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConfigurationDirectory {
    static final String MACHINE_PROPERTY = "os.localhost.host.name";
    static final String MACHINE_FQDN_PROPERTY = "os.localhost.fqdn.host.name";
    static final String SASCFG_PROPERTY = "config.lev.dir";

    private ConfigurationDirectory() {
    }

    public static List<SoftwareComponent> getConfigurationDirectories(MdObjectStore store) throws MdException {
        return ConfigurationDirectory.getConfigurationDirectories(store, null);
    }

    public static List<SoftwareComponent> getConfigurationDirectories(MdObjectStore store, String machine) throws MdException {
        ArrayList<SoftwareComponent> components = new ArrayList<SoftwareComponent>();
        try {
            MdFactory factory = store.getFactory();
            String reposID = factory.getOMIUtil().getFoundationReposID();
            String options = "<Templates><SoftwareComponent><Notes/></SoftwareComponent></Templates><XMLSelect search=\"*[@ClassIdentifier='levdirroot']\"/>";
            int flags = 396;
            List objectsList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposID, "SoftwareComponent", flags, options);
            for (SoftwareComponent comp : objectsList) {
                HashMap<String, String> properties = new HashMap<String, String>();
                ConfigurablePropertiesUtil.getObjectProperties(comp, properties, null);
                if (machine != null && !machine.equalsIgnoreCase((String)properties.get(MACHINE_PROPERTY)) && !machine.equalsIgnoreCase((String)properties.get(MACHINE_FQDN_PROPERTY))) continue;
                components.add(comp);
            }
            return components;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public static SoftwareComponent getConfigurationDirectory(MdObjectStore store, String machine, String configurationDirectory) throws MdException {
        try {
            MdFactory factory = store.getFactory();
            String reposID = factory.getOMIUtil().getFoundationReposID();
            String options = "<Templates><SoftwareComponent><Notes/></SoftwareComponent></Templates><XMLSelect search=\"*[@ClassIdentifier='levdirroot']\"/>";
            int flags = 396;
            List objectsList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposID, "SoftwareComponent", flags, options);
            for (SoftwareComponent comp : objectsList) {
                HashMap<String, String> properties = new HashMap<String, String>();
                ConfigurablePropertiesUtil.getObjectProperties(comp, properties, null);
                if (machine != null && !machine.equalsIgnoreCase((String)properties.get(MACHINE_PROPERTY)) && !machine.equalsIgnoreCase((String)properties.get(MACHINE_FQDN_PROPERTY)) || configurationDirectory != null && !configurationDirectory.equalsIgnoreCase((String)properties.get(SASCFG_PROPERTY))) continue;
                return comp;
            }
            return null;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }
}

