/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PersistableSupportedSpecialValues
extends SupportedSpecialValues
implements PersistenceInterface {
    private LoggerFactoryInterface factory = null;
    private CommonLoggerInterface logger = null;

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        this.setAllSupported(provider.consumeBooleanAttr("allSupported", false));
        this.setNoneSupported(provider.consumeBooleanAttr("noneSupported", false));
        this.setOtherSupported(provider.consumeBooleanAttr("otherSupported", false));
        this.setMissingValuesSupported(provider.consumeBooleanAttr("missingSupported", false));
        this.setMissingValuesHiddenIfSupported(provider.consumeBooleanAttr("missingHiddenIfSupported", false));
    }

    @Override
    public void consumeElementText(String text) {
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) {
        XmlUtil.setBooleanAttr(element, "allSupported", this.isAllSupported(), false);
        XmlUtil.setBooleanAttr(element, "noneSupported", this.isNoneSupported(), false);
        XmlUtil.setBooleanAttr(element, "otherSupported", this.isOtherSupported(), false);
        XmlUtil.setBooleanAttr(element, "missingSupported", this.isMissingValuesSupported(), false);
        XmlUtil.setBooleanAttr(element, "missingHiddenIfSupported", this.isMissingValuesHiddenIfSupported(), false);
    }

    @Override
    public String getDefinitionElementName() {
        return "PersistableSupportedSpecialValues";
    }

    @Override
    public void replace(Object referencedObject, Object replacementObject) {
    }

    @Override
    public Element write(Node parentNode, IntegratedWritingContext writingContext) {
        PromptsWritingContext writingContext2 = (PromptsWritingContext)writingContext;
        if (writingContext2.hasBeenWritten(this)) {
            PersistHelper.writeReferenceUnder(parentNode, writingContext2, this);
            return null;
        }
        Element element = this.writeDefinitionUnder(parentNode, writingContext2);
        Map writingContextOptionsMap = writingContext2.getOptionsMap();
        if (writingContextOptionsMap != null && writingContextOptionsMap.containsKey("removeUnreferencedPersistenceIDs")) {
            PersistHelper.removeUnreferencedPersistenceIDs(element, writingContext2);
        }
        return element;
    }

    final Element writeDefinitionUnder(Node parentNode, PromptsWritingContext writingContext) {
        String persistenceID = writingContext.getPersistenceID(this);
        return this.writeDefinitionUnder(parentNode, writingContext, persistenceID);
    }

    @Override
    public final Element writeDefinitionUnder(Node parentNode, PromptsWritingContext writingContext, String persistenceID) {
        Element thisElement = PersistHelper.newSubelement(parentNode, this.getDefinitionElementName());
        writingContext.markObjAsWritten(this);
        if (persistenceID != null) {
            thisElement.setAttribute("obj", persistenceID);
        }
        this.writeDefinition(thisElement, writingContext);
        return thisElement;
    }

    @Override
    public final void write(Node nodeToWriteUnder) {
        this.write(nodeToWriteUnder, PersistenceFactory.newWritingContext(this, this.factory));
    }

    protected CommonLoggerInterface getLogger2() {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger(this.getClass().getName(), new Log4JFactory2());
        }
        return this.logger;
    }

    protected static final void writeRelatedObjects(List objsToWrite, Node parentNode, PromptsWritingContext writingContext, String relationshipName) throws BackingStoreException {
        PersistHelper.writeRelatedObjects(objsToWrite, parentNode, writingContext, relationshipName);
    }
}

