/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import com.sas.util.ListFactory;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.impl.BaseIntegratedWritingContext;
import com.sas.util.xmlpersist.impl.EqualsEqualsList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultWritingContext
extends BaseIntegratedWritingContext
implements PromptsWritingContext {
    private LoggerFactoryInterface factory;
    private CommonLoggerInterface logger = null;
    private List<MetadataDescriptor> metadataList = ListFactory.newList((int)3);
    private Map optionsMap = null;
    private PersistenceInterface _modelBeingWritten;
    private EqualsEqualsList _objsWritten;
    private IdentityHashMap _persistenceIDAssignments;
    private HashMap _persistenceIDsReferenced;
    private ArrayList _writeOnlyWhenUsed = new ArrayList();
    private static final char OBJ_PREFIX_CHAR = 'p';
    static final char EXTERNAL_OBJ_PREFIX_CHAR = 'x';
    private int _nextGeneratedPersistenceNumber = 1;
    private int _nextGeneratedPersistenceNumberForExternalObjects = 1;
    private IdentityHashMap elementNameToUseElementName = new IdentityHashMap(300);

    DefaultWritingContext(PersistenceInterface modelBeingWritten, LoggerFactoryInterface factory, IntegratedWritingContext outerContext) {
        super(outerContext);
        this._modelBeingWritten = modelBeingWritten;
        this.allocateStorage();
    }

    private void allocateStorage() {
        int objCountHint = 50;
        this._objsWritten = new EqualsEqualsList(objCountHint);
        this._persistenceIDAssignments = new IdentityHashMap(objCountHint);
        this._persistenceIDsReferenced = new HashMap(objCountHint / 5);
    }

    @Override
    public PersistenceInterface getModel() {
        return this._modelBeingWritten;
    }

    @Override
    public boolean hasBeenWritten(PersistenceInterface object) {
        boolean state = this._objsWritten.contains(object);
        return state;
    }

    @Override
    public void markObjAsWritten(PersistenceInterface object) {
        if (this._objsWritten.contains(object)) {
            String errMsg = "WritingContext wrote this twice: " + object.getClass().getName();
            throw new RuntimeException(errMsg);
        }
        this._objsWritten.add(object);
    }

    @Override
    public void noteReferenceToPersistenceID(String persistenceID) {
        this._persistenceIDsReferenced.put(persistenceID, persistenceID);
    }

    @Override
    public boolean wasPersistenceIDReferenced(String persistenceID) {
        return this._persistenceIDsReferenced.containsKey(persistenceID);
    }

    @Override
    public String getPersistenceID(PersistenceInterface object) {
        String persistenceID = (String)this._persistenceIDAssignments.get(object);
        if (persistenceID == null) {
            persistenceID = this.generateNewPersistenceID();
            this._persistenceIDAssignments.put(object, persistenceID);
        }
        return persistenceID;
    }

    public String getPersistenceIDOfExternalObject(PersistenceInterface object) {
        String persistenceID = (String)this._persistenceIDAssignments.get(object);
        if (persistenceID == null) {
            persistenceID = this.generateNewPersistenceIDforExternalObjects();
            this._persistenceIDAssignments.put(object, persistenceID);
        }
        return persistenceID;
    }

    private String generateNewPersistenceID() {
        return 'p' + Integer.toString(this._nextGeneratedPersistenceNumber++);
    }

    private String generateNewPersistenceIDforExternalObjects() {
        return 'x' + Integer.toString(this._nextGeneratedPersistenceNumberForExternalObjects++);
    }

    @Override
    public String getWriteUseElementName(String elementName) {
        String out = (String)this.elementNameToUseElementName.get(elementName);
        if (out == null) {
            out = elementName + "Use";
            this.elementNameToUseElementName.put(elementName, out);
        }
        return out;
    }

    void queueToWriteRelatedItemsOnlyIfUsedWithinModel(List objs, Element element, String newSubelementName) {
        this._writeOnlyWhenUsed.add(new LazyWriteRequest(objs, element, newSubelementName));
    }

    void processQueuedLazyWriteRequests() throws BackingStoreException {
        int size = this._writeOnlyWhenUsed.size();
        for (int i = 0; i < size; ++i) {
            LazyWriteRequest request = (LazyWriteRequest)this._writeOnlyWhenUsed.get(i);
            this.processOneRequest(request);
        }
    }

    private void processOneRequest(LazyWriteRequest request) throws BackingStoreException {
        List objs = request.getObjects();
        Element underElement = request.getUnderElement();
        String newSubelementName = request.getNewSubelementName();
        Element newSubelement = null;
        int size = objs.size();
        for (int i = 0; i < size; ++i) {
            PersistenceInterface base = (PersistenceInterface)objs.get(i);
            String persistenceID = (String)this._persistenceIDAssignments.get(base);
            if (persistenceID == null || !this._persistenceIDsReferenced.containsKey(persistenceID)) continue;
            if (newSubelement == null) {
                newSubelement = this.newSubelement(underElement, newSubelementName);
                this.getLogger2().debug(newSubelementName, persistenceID);
            }
            base.writeDefinitionUnder(newSubelement, this, persistenceID);
        }
    }

    Element newSubelement(Node parentNode, String newElementName) {
        this.getLogger2().debug("newSubelement() for", newElementName);
        Document doc = null;
        doc = parentNode instanceof Document ? (Document)parentNode : parentNode.getOwnerDocument();
        Element element = doc.createElement(newElementName);
        parentNode.appendChild(element);
        return element;
    }

    protected final CommonLoggerInterface getLogger2() {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger(this.getClass().getName(), new Log4JFactory2());
        }
        return this.logger;
    }

    @Override
    public void addMetadataDescriptor(MetadataDescriptor descriptor) {
        this.metadataList.add(descriptor);
    }

    @Override
    public void removeMetadataDescriptor(MetadataDescriptor descriptor) {
        this.metadataList.remove(descriptor);
    }

    @Override
    public List<MetadataDescriptor> getMetadataDescriptors() {
        return ListFactory.newList(this.metadataList);
    }

    @Override
    public void setOptionsMap(Map map) {
        this.optionsMap = map;
    }

    @Override
    public Map getOptionsMap() {
        return this.optionsMap;
    }

    static class LazyWriteRequest {
        List _objs;
        Element _underElement;
        String _newSubelementName;

        LazyWriteRequest(List objs, Element underElement, String newSubelementName) {
            this._objs = objs;
            this._underElement = underElement;
            this._newSubelementName = newSubelementName;
        }

        List getObjects() {
            return this._objs;
        }

        Element getUnderElement() {
            return this._underElement;
        }

        String getNewSubelementName() {
            return this._newSubelementName;
        }
    }
}

