/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import com.sas.util.ListFactory;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.RelatedObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xml.sax.SAXException;

final class DefaultRelatedObjectList
implements RelatedObjectList {
    private String _relationshipName;
    private ArrayList _relatedObjects = new ArrayList();
    private LoggerFactoryInterface factory;
    private CommonLoggerInterface logger = null;

    public DefaultRelatedObjectList(String relationshipName, LoggerFactoryInterface factory) {
        this._relationshipName = relationshipName;
    }

    @Override
    public void reinitializeForAdditionOfRelatedObjects(String relationshipName) {
        this._relationshipName = relationshipName;
        this._relatedObjects.clear();
    }

    @Override
    public String getRelationshipName() {
        this.getLogger().debug("RelationshipName is", this._relationshipName);
        return this._relationshipName;
    }

    @Override
    public void add(PersistenceInterface obj) {
        this._relatedObjects.add(obj);
    }

    @Override
    public PersistenceInterface getObject() throws SAXException {
        PersistenceInterface out = null;
        int size = this._relatedObjects.size();
        if (size == 1) {
            out = (PersistenceInterface)this._relatedObjects.get(0);
            if (null != out) {
                this.getLogger().debug("getObject returns", out.toString());
            }
        } else if (size > 1) {
            String msg = "More than one related object was found. Name is: " + this._relationshipName;
            throw new SAXException(msg);
        }
        return out;
    }

    @Override
    public List trustedGetObjects() {
        return this._relatedObjects;
    }

    @Override
    public ArrayList getObjects() {
        return new ArrayList(this._relatedObjects);
    }

    @Override
    public List getObjectsReturningDefensibleList() {
        return ListFactory.newList((Collection)this._relatedObjects);
    }

    private CommonLoggerInterface getLogger() {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger(this.getClass().getName(), new Log4JFactory2());
        }
        return this.logger;
    }
}

