/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import com.sas.util.CalendarUtil;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DefaultAttributesProvider
implements AttributesProvider {
    private Attributes _saxAttrs;
    private String[] _attrNames;
    private int _attrCount;
    private int _attrCountRemaining;
    private boolean _parserIsInterningStrings = false;
    private PromptsReadingContext readingContext;
    private String datePattern;
    private static final String BOOLEAN_FALSE = "false";
    private static final String BOOLEAN_TRUE = "true";
    private LoggerFactoryInterface factory = null;
    private CommonLoggerInterface logger = null;

    DefaultAttributesProvider(PromptsReadingContext readingContext, int initialCapacity, String pattern) {
        this.setReadingContext(readingContext);
        this._attrNames = new String[initialCapacity];
        this.datePattern = null == pattern ? "yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'" : pattern;
    }

    @Override
    public final void reinitializeForConsumptionOfAttributes(Attributes saxAttrs) throws SAXException {
        this._saxAttrs = saxAttrs;
        this._attrCountRemaining = this._attrCount = this._saxAttrs.getLength();
        this.getLogger().debug("Reinitializing for consuming attrs:", Integer.toString(this._attrCount));
        if (this._attrNames.length < this._attrCount) {
            this._attrNames = new String[this._attrCount];
        }
        for (int i = 0; i < this._attrCount; ++i) {
            char firstChar;
            String attrName;
            this._attrNames[i] = attrName = this._saxAttrs.getQName(i);
            if (attrName == null || attrName.length() <= 0 || (firstChar = attrName.charAt(0)) >= 'a' && firstChar <= 'z') continue;
            throw new SAXException("Attribute name \"" + attrName + "\" does not start with a lower case character (an industry standard)");
        }
    }

    void setParserIsInterningStrings(boolean parserIsInterningStrings) {
        this._parserIsInterningStrings = parserIsInterningStrings;
    }

    protected String consumeAttr(String attrName, String defaultValue) {
        String outValue = defaultValue;
        if (this._attrCountRemaining > 0) {
            for (int i = 0; i < this._attrCount; ++i) {
                String slotName = this._attrNames[i];
                if (slotName != attrName && (slotName == null || this._parserIsInterningStrings || !slotName.equals(attrName))) continue;
                outValue = this._saxAttrs.getValue(i);
                this._attrNames[i] = null;
                --this._attrCountRemaining;
                break;
            }
        }
        return outValue;
    }

    @Override
    public final List getUnconsumedAttrNames() {
        ArrayList<String> out = Collections.EMPTY_LIST;
        if (this._attrCountRemaining > 0) {
            out = new ArrayList<String>();
            for (int i = 0; i < this._attrCount; ++i) {
                if (this._attrNames[i] == null) continue;
                out.add(this._attrNames[i]);
                this.getLogger().debug("unconsumed attr name is", this._attrNames[i]);
            }
        }
        return out;
    }

    @Override
    public final boolean hasAttrsRemainingToBeConsumed() {
        return this._attrCountRemaining > 0;
    }

    @Override
    public String consumeAttr(String attrName) {
        return this.consumeAttr(attrName, null);
    }

    @Override
    public String consumeAttrEmptyDefault(String attrName) {
        String out = this.consumeAttr(attrName, null);
        if (out == null) {
            out = "";
        } else if (out.length() == 0) {
            out = null;
        }
        this.getLogger().debug("consume attr empty default:", out);
        return out;
    }

    @Override
    public boolean consumeBooleanAttr(String attrName, boolean defaultValue) {
        boolean out;
        String value = this.consumeAttr(attrName);
        if (value == null) {
            out = defaultValue;
        } else if (BOOLEAN_TRUE.equalsIgnoreCase(value)) {
            out = true;
        } else if (BOOLEAN_FALSE.equalsIgnoreCase(value)) {
            out = false;
        } else {
            throw new IllegalArgumentException("Invalid boolean value:" + value);
        }
        return out;
    }

    @Override
    public int consumeIntAttr(String attrName, int defaultValue) {
        String value = this.consumeAttr(attrName);
        int out = value == null ? defaultValue : Integer.parseInt(value);
        return out;
    }

    @Override
    public Double consumeDoubleAttr(String attrName, Double defaultValue) {
        String value = this.consumeAttr(attrName);
        Double out = value == null ? defaultValue : Double.valueOf(value);
        return out;
    }

    @Override
    public Long consumeLongAttr(String attrName, Long defaultValue) {
        String value = this.consumeAttr(attrName);
        Long out = value == null ? defaultValue : Long.valueOf(value);
        return out;
    }

    @Override
    public Date consumeTimestampAttr(String attrName, Date defaultValue) throws SAXException {
        Date out;
        String value = this.consumeAttr(attrName);
        if (value == null) {
            out = defaultValue;
        } else {
            try {
                out = CalendarUtil.parseDateString((String)value, (String)this.datePattern);
            }
            catch (ParseException e) {
                SAXException se = new SAXException(value, e);
                se.initCause(e);
                throw se;
            }
        }
        return out;
    }

    private CommonLoggerInterface getLogger() {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger(this.getClass().getName(), new Log4JFactory2());
        }
        return this.logger;
    }

    @Override
    public final PromptsReadingContext getReadingContext() {
        if (null == this.readingContext) {
            this.readingContext = PersistenceFactory.newReadingContext(this.factory);
        }
        return this.readingContext;
    }

    public final void setReadingContext(PromptsReadingContext readingContext) {
        this.readingContext = readingContext;
    }
}

