/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import com.sas.codepolicy.SASScope;
import com.sas.models.VersionInterface;
import com.sas.prompts.util.PromptContentHandler;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.io.Serializable;
import java.text.ParseException;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope
public abstract class BaseAbstractPersistence
implements PersistenceInterface,
VersionInterface,
Serializable {
    private static final long serialVersionUID = -6484704496066612081L;
    private transient LoggerFactoryInterface factory = null;
    private transient CommonLoggerInterface logger = null;
    private String version;

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        String sv = provider.consumeAttr("version");
        if (sv == null || Strings.equal((String)sv, (String)"9.2", (boolean)true, (boolean)false)) {
            sv = PromptContentHandler.oldestVersion.toString();
        }
        this.version = sv;
    }

    @Override
    public void consumeElementText(String text) {
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        Node pNode;
        if (element != null && !element.hasAttribute("version") && (pNode = element.getParentNode()) != null) {
            String nodeVersion = null;
            while (pNode != null) {
                Node vNode;
                if (pNode.hasAttributes() && (vNode = pNode.getAttributes().getNamedItem("version")) != null) {
                    nodeVersion = vNode.getNodeValue();
                    break;
                }
                pNode = pNode.getParentNode();
            }
            if (null == nodeVersion) {
                String tempVersion = this.getVersion();
                XmlUtil.setAttr(element, "version", tempVersion);
                this.getLogger2().debug("Writing objects's version:", tempVersion);
            }
        }
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = PromptContentHandler.oldestVersion.toString();
        }
        return this.version;
    }

    @Override
    public String getDefinitionElementName() {
        throw new IllegalStateException("This class has no defined element name and cannot be persisted: " + this.getClass().getName());
    }

    protected CommonLoggerInterface getLogger2() {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger(this.getClass().getName(), new Log4JFactory2());
        }
        return this.logger;
    }

    @Override
    public final void write(Node nodeToWriteUnder) throws BackingStoreException {
        this.write(nodeToWriteUnder, PersistenceFactory.newWritingContext(this, this.factory));
    }

    @Override
    public final Element write(Node parentNode, IntegratedWritingContext writingContext) throws BackingStoreException {
        PromptsWritingContext writingContext2 = (PromptsWritingContext)writingContext;
        try {
            UsageVersion uv = UsageVersion.parseVersion((String)this.getVersion());
            if (!uv.isCompatible(PromptContentHandler.oldestVersion, PromptContentHandler.currentVersion)) {
                throw new BackingStoreException("The version " + this.getVersion() + " is not supported. The currently supported version is " + PromptContentHandler.currentVersion);
            }
        }
        catch (ParseException e) {
            throw new BackingStoreException("Error parsing the version " + this.getVersion() + ". The currently supported version is " + PromptContentHandler.currentVersion);
        }
        if (writingContext2.hasBeenWritten(this)) {
            PersistHelper.writeReferenceUnder(parentNode, writingContext2, this);
            return null;
        }
        Element element = this.writeDefinitionUnder(parentNode, writingContext2);
        return element;
    }

    protected static final void writeRelatedObjects(List<PersistenceInterface> objsToWrite, Node parentNode, PromptsWritingContext writingContext, String relationshipName) throws BackingStoreException {
        PersistHelper.writeRelatedObjects(objsToWrite, parentNode, writingContext, relationshipName);
    }

    final Element writeDefinitionUnder(Node parentNode, PromptsWritingContext writingContext) throws BackingStoreException {
        String persistenceID = writingContext.getPersistenceID(this);
        return this.writeDefinitionUnder(parentNode, writingContext, persistenceID);
    }

    @Override
    public final Element writeDefinitionUnder(Node parentNode, PromptsWritingContext writingContext, String persistenceID) throws BackingStoreException {
        Element thisElement = PersistHelper.newSubelement(parentNode, this.getDefinitionElementName());
        writingContext.markObjAsWritten(this);
        if (persistenceID != null) {
            thisElement.setAttribute("obj", persistenceID);
        }
        this.writeDefinition(thisElement, writingContext);
        return thisElement;
    }

    @Override
    public void replace(Object referencedObject, Object replacementObject) {
    }
}

