/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.valueprovider.workspace;

import com.sas.MissingValues;
import com.sas.beans.PropertyChangeSource;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.StringType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.WorkspaceConnector;
import com.sas.iom.WorkspaceFactory;
import com.sas.models.CacheException;
import com.sas.models.MutableThresholdInterface;
import com.sas.rio.MVAConnection;
import com.sas.storage.simplesqlmodel.ColumnInfo;
import com.sas.storage.simplesqlmodel.ColumnOperand;
import com.sas.storage.simplesqlmodel.Expression;
import com.sas.storage.simplesqlmodel.FormattedOperator;
import com.sas.storage.simplesqlmodel.IntegerOperand;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.SASFormatOperand;
import com.sas.storage.simplesqlmodel.SelectStatement;
import com.sas.storage.simplesqlmodel.StringOperand;
import com.sas.storage.simplesqlmodel.WhereClause;
import com.sas.storage.valueprovider.ListSearchInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.storage.valueprovider.workspace.RB;
import com.sas.util.ListFactory;
import com.sas.util.ResourceReferencesInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ColumnValueProvider
extends AbstractPersistence
implements ValueProviderInterface,
ListSearchInterface,
ResourceReferencesInterface,
MutableThresholdInterface,
PropertyChangeSource {
    public static int DEFAULT_THRESHOLD = 1000;
    private int threshold;
    private String host;
    private String port;
    private String userName;
    private String password;
    public static final String SORT_LABEL = "SortLabel";
    public static final String SORT_VALUE = "SortValue";
    public static final String SORT_NONE = "SortNone";
    protected Connection connection;
    protected String libref;
    protected String tableName;
    protected ColumnInfo valueColumn;
    protected ColumnInfo labelColumn;
    protected boolean useValueAsLabel;
    protected String sortOrder;
    protected String sortFirst;
    protected boolean distinct;
    protected WhereClause whereClause;
    protected IWorkspace iWorkspace;
    private boolean formatLabels;
    private boolean formatValues;
    private boolean trimLabels;
    private boolean trimValues;
    protected DataTypeInterface valueDataType;
    protected DataTypeInterface labelDataType;
    protected boolean displayValue;
    private boolean needQuoting;
    protected boolean isUserConnection;
    protected boolean removeMissingValues;
    public static int MAX_CACHE_SIZE = DEFAULT_THRESHOLD * 10;
    protected PropertyChangeSupport propertyChangeSupport;

    public ColumnValueProvider() {
        this.init();
    }

    public ColumnValueProvider(String host, String port, String username, String password) {
        this.host = host;
        this.port = port;
        this.setUsernamePassword(username, password);
        this.init();
    }

    public ColumnValueProvider(Connection connection) {
        this.connection = connection;
        this.isUserConnection = true;
        this.init();
    }

    private void init() {
        this.distinct = true;
        this.sortFirst = SORT_LABEL;
        this.formatLabels = true;
        this.trimLabels = true;
        this.threshold = DEFAULT_THRESHOLD;
        this.needQuoting = false;
        this.labelDataType = null;
        this.valueDataType = null;
        this.removeMissingValues = false;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void setUsernamePassword(String userName, String password) {
        this.userName = userName;
        try {
            this.password = SasPasswordString.encode((String)"sas001", (String)password);
        }
        catch (SasPasswordEncodingException spe) {
            this.password = password;
        }
    }

    @Override
    public String getDefinitionElementName() {
        return "ColumnValueProvider";
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setLibref(String libref) {
        this.libref = libref;
    }

    public String getLibref() {
        return this.libref;
    }

    public void setTableName(String tableName) {
        String oldValue = tableName;
        if (Util.unequal((Object)this.tableName, (Object)tableName)) {
            this.tableName = tableName;
            this.propertyChangeSupport.firePropertyChange("tableName", oldValue, tableName);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setValueColumn(ColumnInfo valueColumn) {
        ColumnInfo oldValue = valueColumn;
        if (Util.unequal((Object)this.valueColumn, (Object)valueColumn)) {
            this.valueColumn = valueColumn;
            this.valueColumn.setNeedQuoting(this.needQuoting);
            this.valueDataType = null;
            this.propertyChangeSupport.firePropertyChange("valueColumn", oldValue, valueColumn);
        }
    }

    public ColumnInfo getValueColumn() {
        return this.valueColumn;
    }

    public void setLabelColumn(ColumnInfo labelColumn) {
        ColumnInfo oldValue = labelColumn;
        if (Util.unequal((Object)this.labelColumn, (Object)labelColumn)) {
            this.labelColumn = labelColumn;
            this.labelColumn.setNeedQuoting(this.needQuoting);
            this.labelDataType = null;
            this.propertyChangeSupport.firePropertyChange("labelColumn", oldValue, labelColumn);
        }
    }

    public ColumnInfo getLabelColumn() {
        return this.labelColumn;
    }

    public void setUseValueAsLabel(boolean useValueAsLabel) {
        this.useValueAsLabel = useValueAsLabel;
    }

    public boolean getUseValueAsLabel() {
        return this.useValueAsLabel;
    }

    public void setWhereClause(WhereClause where) {
        WhereClause oldValue = this.whereClause;
        if (Util.unequal((Object)this.whereClause, (Object)where)) {
            this.whereClause = where;
            this.propertyChangeSupport.firePropertyChange("whereClause", oldValue, where);
        }
    }

    public WhereClause getWhereClause() {
        return this.whereClause;
    }

    public void setDistinct(boolean isDistinct) {
        boolean oldValue = this.distinct;
        if (Util.unequal((Object)this.distinct, (Object)isDistinct)) {
            this.distinct = isDistinct;
            this.propertyChangeSupport.firePropertyChange("distinct", oldValue, isDistinct);
        }
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setTrimLabels(boolean trimLabels) {
        this.trimLabels = trimLabels;
    }

    public boolean isTrimLabels() {
        return this.trimLabels;
    }

    public void setTrimValues(boolean trimValues) {
        this.trimValues = trimValues;
    }

    public boolean isTrimValues() {
        return this.trimValues;
    }

    public void setRemoveMissingValues(boolean removeMissingValues) {
        boolean oldValue = this.removeMissingValues;
        if (Util.unequal((Object)this.removeMissingValues, (Object)removeMissingValues)) {
            this.removeMissingValues = removeMissingValues;
            this.propertyChangeSupport.firePropertyChange("removeMissingValues", oldValue, removeMissingValues);
        }
    }

    public boolean removeMissingValues() {
        return this.removeMissingValues;
    }

    public void setFormatLabels(boolean formatLabels) {
        boolean oldValue = this.formatLabels;
        if (Util.unequal((Object)this.formatLabels, (Object)formatLabels)) {
            this.formatLabels = formatLabels;
            this.propertyChangeSupport.firePropertyChange("formatLabels", oldValue, formatLabels);
        }
    }

    public boolean isFormatLabels() {
        return this.formatLabels;
    }

    public void setFormatValues(boolean formatValues) {
        boolean oldValue = this.formatValues;
        if (Util.unequal((Object)this.formatValues, (Object)formatValues)) {
            this.formatValues = formatValues;
            this.propertyChangeSupport.firePropertyChange("formatValues", oldValue, formatValues);
        }
    }

    public boolean isFormatValues() {
        return this.formatValues;
    }

    public void setSortFirst(String sortFirst) {
        String oldValue = this.sortFirst;
        if (Util.unequal((Object)this.sortFirst, (Object)sortFirst)) {
            this.sortFirst = sortFirst;
            this.propertyChangeSupport.firePropertyChange("sortFirst", oldValue, sortFirst);
        }
    }

    public String getSortFirst() {
        return this.sortFirst;
    }

    public boolean needQuoting() {
        return this.needQuoting;
    }

    public void setNeedQuoting(boolean needQuoting) {
        boolean oldValue = this.needQuoting;
        if (this.needQuoting != needQuoting) {
            this.needQuoting = needQuoting;
            if (this.valueColumn != null) {
                this.valueColumn.setNeedQuoting(needQuoting);
            }
            if (this.labelColumn != null) {
                this.labelColumn.setNeedQuoting(needQuoting);
            }
            this.propertyChangeSupport.firePropertyChange("needQuoting", oldValue, needQuoting);
        }
    }

    @Override
    public boolean isSearchable() throws ValueProviderException {
        if (this.labelDataType == null) {
            this.labelDataType = this.findDataType(this.getSearchColumn());
        }
        return this.labelDataType instanceof StringType;
    }

    @Override
    public DataTypeInterface getDataType() throws ValueProviderException {
        if (this.valueDataType == null) {
            this.valueDataType = this.findDataType(this.getValueColumn());
        }
        return this.valueDataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataTypeInterface findDataType(ColumnInfo searchColumn) throws ValueProviderException {
        DataTypeInterface searchDataType = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String query = this.buildDataTypeQuery(searchColumn);
            this.getLogger2().debug("DataType Query=" + query);
            statement = this.connection.createStatement(1004, 1007);
            resultSet = statement.executeQuery(query);
            ResultSetMetaData rsMetadata = resultSet.getMetaData();
            int labelDataType = rsMetadata.getColumnType(1);
            searchDataType = this.convertSQLTypeToDataType(labelDataType);
        }
        catch (SQLException se) {
            this.getLogger2().warn("Error trying to find label data type");
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                this.close();
            }
            catch (SQLException se) {
                this.getLogger2().warn("Error trying to close resultset");
            }
            catch (GenericError ge) {
                this.getLogger2().warn("Error trying to close resultset");
            }
        }
        return searchDataType;
    }

    private String buildDataTypeQuery(ColumnInfo searchColumn) throws SQLException, ValueProviderException {
        this.establishConnection();
        if (this.tableName == null) {
            throw new ValueProviderException(RB.getStringResource("ColumnValueProvider.noTableError.txt"));
        }
        SelectStatement selectStatement = new SelectStatement();
        selectStatement.setDistinct(this.distinct);
        StringBuffer selectTableName = new StringBuffer();
        if (this.tableName.indexOf(46) <= 0) {
            selectTableName.append(this.libref);
            selectTableName.append(".");
        }
        if (this.needQuoting) {
            selectTableName.append("'");
            selectTableName.append(this.tableName);
            selectTableName.append("'n");
        } else {
            selectTableName.append(this.tableName);
        }
        selectStatement.setTable(selectTableName.toString());
        ArrayList<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
        ColumnInfo sc = null;
        String scName = searchColumn.getName();
        sc = this.needQuoting || scName.contains(this.tableName) ? new ColumnInfo(scName) : new ColumnInfo(this.tableName + "." + searchColumn.getName());
        sc.setNeedQuoting(this.needQuoting);
        columnList.add(sc);
        selectStatement.setColumns(columnList);
        IntegerOperand op = new IntegerOperand(0);
        WhereClause where = new WhereClause();
        where.setCondition(op);
        selectStatement.setWhereClause(where);
        String query = selectStatement.getSelectStatement(Collections.EMPTY_MAP);
        return query;
    }

    public void setQualifyLabelWithValue(boolean qualifyLabelWithValue) {
        this.setValueDisplayed(qualifyLabelWithValue);
    }

    public boolean isQualifyLabelWithValue() {
        return this.isValueDisplayed();
    }

    public void setValueDisplayed(boolean displayValue) {
        this.displayValue = displayValue;
    }

    @Override
    public boolean isValueDisplayed() {
        return this.displayValue;
    }

    public int count() throws ValueProviderException {
        return 0;
    }

    @Override
    public Object getValues(Locale locale) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, null, 0, this.getThreshold());
    }

    @Override
    public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, null, index, count);
    }

    @Override
    public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, returnType, null, 0, this.getThreshold());
    }

    @Override
    public Object getValues(Locale locale, SearchCriteria searchCriterion) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, searchCriterion, 0, this.getThreshold());
    }

    @Override
    public Object getValues(Locale locale, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, searchCriteria, index, count);
    }

    @Override
    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, returnType, null, index, count);
    }

    private Object getValues(Locale locale, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Collection returnObject = null;
        if (returnType == ValueType.LIST || returnType == ValueType.TREETHENLIST) {
            returnObject = this.getValuesAsList(locale, Collections.EMPTY_MAP, searchCriteria, index, count);
        } else if (returnType == ValueType.TREE) {
            throw new ValueProviderException(RB.getStringResource("ColumnValueProvider.invalidReturnTypeError.txt"));
        }
        return returnObject;
    }

    private Collection getValuesAsList(Locale locale, Map context, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        try {
            if (index < 0) {
                throw new ValueProviderException(RB.getStringResource("ColumnValueProvider.invalidindexError.txt"));
            }
            String query = this.buildQuery(context, searchCriteria);
            Object[] valuesArray = this.getValuesFromServer(locale, query, index, count);
            List<Object> l = Arrays.asList(valuesArray);
            return count > 0 ? l.subList(index, index + count) : l;
        }
        catch (CacheException ce) {
            throw new ValueProviderException(ce, ce.getMessage());
        }
        catch (SQLException se) {
            throw new ValueProviderException(se, se.getMessage());
        }
    }

    protected String buildQuery(Map context, SearchCriteria searchCriteria) throws SQLException, ValueProviderException {
        if (this.tableName == null) {
            throw new ValueProviderException(RB.getStringResource("ColumnValueProvider.noTableError.txt"));
        }
        SelectStatement selectStatement = new SelectStatement();
        selectStatement.setDistinct(this.distinct);
        StringBuffer selectTableName = new StringBuffer();
        if (this.tableName.indexOf(46) <= 0) {
            selectTableName.append(this.libref);
            selectTableName.append(".");
        }
        if (this.needQuoting) {
            selectTableName.append("'");
        }
        selectTableName.append(this.tableName);
        if (this.needQuoting) {
            selectTableName.append("'n");
        }
        selectStatement.setTable(selectTableName.toString());
        List columnList = this.getVPColumnList();
        selectStatement.setColumns(columnList);
        WhereClause submitClause = this.whereClause;
        if (searchCriteria != null) {
            this.verifySearchCriteria(searchCriteria);
            submitClause = this.buildWhereClause(searchCriteria);
        }
        if (submitClause != null) {
            selectStatement.setWhereClause(submitClause);
        }
        String query = selectStatement.getSelectStatement(context);
        this.getLogger2().debug("Query=" + query);
        return query;
    }

    protected String getLabelFormat() {
        int index;
        String format = null;
        if (this.labelColumn != null && (index = (format = this.labelColumn.getFormat().trim()).indexOf(ColumnInfo.DEFAULT_FORMAT)) >= 0) {
            format = format.length() > ColumnInfo.DEFAULT_FORMAT.length() ? format.substring(ColumnInfo.DEFAULT_FORMAT.length() + 1, format.length()).trim() : null;
        }
        return format;
    }

    protected String getValueFormat() {
        int index;
        String format = null;
        if (this.valueColumn != null && (index = (format = this.valueColumn.getFormat().trim()).indexOf(ColumnInfo.DEFAULT_FORMAT)) >= 0) {
            format = format.length() > ColumnInfo.DEFAULT_FORMAT.length() ? format.substring(ColumnInfo.DEFAULT_FORMAT.length() + 1, format.length()).trim() : null;
        }
        return format;
    }

    private List getVPColumnList() throws ValueProviderException {
        String format;
        ArrayList<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
        ColumnInfo tempLabelColumn = null;
        if (this.labelColumn != null) {
            String columnName = this.labelColumn.getName();
            if (columnName == null || columnName.length() == 0) {
                if (this.useValueAsLabel) {
                    columnName = this.valueColumn.getName();
                } else {
                    throw new ValueProviderException(RB.getStringResource("ColumnValueProvider.invalidLabelColumnError.txt"));
                }
            }
            format = this.getLabelFormat();
            tempLabelColumn = this.labelColumn.needQuoting() ? new ColumnInfo(columnName, this.labelColumn.getSortOrder(), format) : new ColumnInfo(this.tableName + "." + columnName, this.labelColumn.getSortOrder(), format);
            tempLabelColumn.setNeedQuoting(this.labelColumn.needQuoting());
        }
        ColumnInfo tempValueColumn = null;
        tempValueColumn = this.valueColumn.needQuoting() ? new ColumnInfo(this.valueColumn.getName(), this.valueColumn.getSortOrder(), this.valueColumn.getFormat()) : new ColumnInfo(this.tableName + "." + this.valueColumn.getName(), this.valueColumn.getSortOrder(), this.valueColumn.getFormat());
        tempValueColumn.setNeedQuoting(this.valueColumn.needQuoting());
        if (this.formatLabels != this.formatValues) {
            if (this.labelColumn == null) {
                format = this.getValueFormat();
                tempLabelColumn = this.valueColumn.needQuoting() ? new ColumnInfo(this.valueColumn.getName(), this.valueColumn.getSortOrder(), format) : new ColumnInfo(this.tableName + "." + this.valueColumn.getName(), this.valueColumn.getSortOrder(), format);
                tempLabelColumn.setNeedQuoting(this.valueColumn.needQuoting());
            }
            if (!this.formatLabels) {
                tempLabelColumn.setFormat(null);
            }
            columnList.add(tempLabelColumn);
        } else if (!this.useValueAsLabel && this.labelColumn != null) {
            if (!this.formatLabels && this.labelColumn.getFormat() != null) {
                tempLabelColumn.setFormat(null);
            }
            columnList.add(tempLabelColumn);
        }
        if (!this.formatValues && this.valueColumn.getFormat() != null) {
            tempValueColumn.setFormat(null);
        }
        columnList.add(tempValueColumn);
        if (columnList.size() == 2 && tempLabelColumn.getFormat() != null) {
            ColumnInfo tempLabelColumn2 = new ColumnInfo(tempLabelColumn.getName(), tempLabelColumn.getSortOrder(), null);
            tempLabelColumn2.setNeedQuoting(tempLabelColumn.needQuoting());
            columnList.add(tempLabelColumn2);
        }
        return columnList;
    }

    private boolean verifySearchCriteria(SearchCriteria searchCriteria) throws ValueProviderException, SQLException {
        return true;
    }

    protected WhereClause buildWhereClause(SearchCriteria searchCriteria) throws ValueProviderException {
        WhereClause newWhere = null;
        Object operator = searchCriteria.getOperator();
        if (this._isContainsSearch(searchCriteria)) {
            newWhere = this._buildContainsWhereClause(searchCriteria);
        } else if (this._isEqualsSearch(searchCriteria)) {
            newWhere = this._buildEqualWhereClause(searchCriteria);
        } else if (SearchCriteria.OPERATOR_STARTS_WITH.equals(operator)) {
            newWhere = this._buildStartsWithWhereClause(searchCriteria);
        } else if (SearchCriteria.OPERATOR_ENDS_WITH.equals(operator)) {
            newWhere = this._buildEndsWithWhereClause(searchCriteria);
        } else if (SearchCriteria.OPERATOR_MATCH_PATTERN.equals(operator)) {
            newWhere = this._buildMatchPatternClause(searchCriteria);
        }
        return newWhere;
    }

    private boolean _isContainsSearch(SearchCriteria searchCriteria) {
        Object operator = searchCriteria.getOperator();
        return SearchCriteria.OPERATOR_CONTAINS.equals(operator) || SearchCriteria.OPERATOR_NOT_CONTAINS.equals(operator);
    }

    private boolean _isEqualsSearch(SearchCriteria searchCriteria) {
        Object operator = searchCriteria.getOperator();
        return SearchCriteria.OPERATOR_EQUAL.equals(operator) || SearchCriteria.OPERATOR_NOT_EQUAL.equals(operator);
    }

    protected ColumnInfo getSearchColumn() throws ValueProviderException {
        List l = this.getVPColumnList();
        ColumnInfo searchColumn = null;
        if (l.size() > 0) {
            searchColumn = (ColumnInfo)l.get(0);
        }
        return searchColumn;
    }

    protected boolean isEmpty(String format) {
        return format == null || format.length() == 0;
    }

    private WhereClause _buildContainsWhereClause(SearchCriteria searchCriteria) throws ValueProviderException {
        ColumnInfo searchColumn = this.getSearchColumn();
        AbstractPersistence exp = new ColumnOperand(searchColumn);
        String textToMatch = searchCriteria.getTextToMatch();
        if (!this.isEmpty(searchColumn.getFormat())) {
            exp = new Expression(FormattedOperator.PUT_OPERATOR, (OperandInterface)((Object)exp), new SASFormatOperand(searchColumn.getFormat()));
        }
        if (!searchCriteria.isCaseSensitiveSearch()) {
            ArrayList<ColumnOperand> l = new ArrayList<ColumnOperand>();
            l.add((ColumnOperand)exp);
            exp = new Expression(FormattedOperator.UPCASE_OPERATOR, l);
            textToMatch = textToMatch.toUpperCase();
        }
        Expression exp1 = new Expression(FormattedOperator.CONTAINS_OPERATOR, (OperandInterface)((Object)exp), new StringOperand(textToMatch));
        return this.getMasterWhere(exp1);
    }

    private WhereClause _buildEqualWhereClause(SearchCriteria searchCriteria) throws ValueProviderException {
        ColumnInfo searchColumn = this.getSearchColumn();
        AbstractPersistence exp = new ColumnOperand(searchColumn);
        String textToMatch = searchCriteria.getTextToMatch();
        if (!this.isEmpty(searchColumn.getFormat())) {
            exp = new Expression(FormattedOperator.PUT_OPERATOR, (OperandInterface)((Object)exp), new SASFormatOperand(searchColumn.getFormat()));
        }
        if (!searchCriteria.isCaseSensitiveSearch()) {
            ArrayList<ColumnOperand> l = new ArrayList<ColumnOperand>();
            l.add((ColumnOperand)exp);
            exp = new Expression(FormattedOperator.UPCASE_OPERATOR, l);
            textToMatch = textToMatch.toUpperCase();
        }
        Expression exp1 = new Expression(FormattedOperator.EQUAL_OPERATOR, (OperandInterface)((Object)exp), new StringOperand(textToMatch));
        return this.getMasterWhere(exp1);
    }

    private WhereClause _buildMatchPatternClause(SearchCriteria searchCriteria) throws ValueProviderException {
        ColumnInfo searchColumn = this.getSearchColumn();
        AbstractPersistence exp = new ColumnOperand(searchColumn);
        String textToMatch = searchCriteria.getTextToMatch();
        textToMatch = Strings.replace((String)textToMatch, (char[])new char[]{'*', '?'}, (String[])new String[]{"%", "_"});
        if (!this.isEmpty(searchColumn.getFormat())) {
            exp = new Expression(FormattedOperator.PUT_OPERATOR, (OperandInterface)((Object)exp), new SASFormatOperand(searchColumn.getFormat()));
        }
        ArrayList<ColumnOperand> l = new ArrayList<ColumnOperand>();
        l.add((ColumnOperand)exp);
        exp = new Expression(FormattedOperator.TRIM_OPERATOR, l);
        if (!searchCriteria.isCaseSensitiveSearch()) {
            l.set(0, (ColumnOperand)exp);
            exp = new Expression(FormattedOperator.UPCASE_OPERATOR, l);
            textToMatch = textToMatch.toUpperCase();
        }
        Expression exp1 = new Expression(FormattedOperator.LIKE_OPERATOR, (OperandInterface)((Object)exp), new StringOperand(textToMatch));
        return this.getMasterWhere(exp1);
    }

    private WhereClause _buildStartsWithWhereClause(SearchCriteria searchCriteria) throws ValueProviderException {
        ColumnInfo searchColumn = this.getSearchColumn();
        AbstractPersistence exp = new ColumnOperand(searchColumn);
        String textToMatch = searchCriteria.getTextToMatch();
        if (!this.isEmpty(searchColumn.getFormat())) {
            exp = new Expression(FormattedOperator.PUT_OPERATOR, (OperandInterface)((Object)exp), new SASFormatOperand(searchColumn.getFormat()));
        }
        if (!searchCriteria.isCaseSensitiveSearch()) {
            ArrayList<ColumnOperand> l = new ArrayList<ColumnOperand>();
            l.add((ColumnOperand)exp);
            exp = new Expression(FormattedOperator.UPCASE_OPERATOR, l);
            textToMatch = textToMatch.toUpperCase();
        }
        Expression exp1 = new Expression(FormattedOperator.LIKE_OPERATOR, (OperandInterface)((Object)exp), new StringOperand(textToMatch + '%'));
        return this.getMasterWhere(exp1);
    }

    private WhereClause _buildEndsWithWhereClause(SearchCriteria searchCriteria) throws ValueProviderException {
        ColumnInfo searchColumn = this.getSearchColumn();
        AbstractPersistence exp = new ColumnOperand(searchColumn);
        String textToMatch = searchCriteria.getTextToMatch();
        if (!this.isEmpty(searchColumn.getFormat())) {
            exp = new Expression(FormattedOperator.PUT_OPERATOR, (OperandInterface)((Object)exp), new SASFormatOperand(searchColumn.getFormat()));
        }
        if (!searchCriteria.isCaseSensitiveSearch()) {
            ArrayList<ColumnOperand> l = new ArrayList<ColumnOperand>();
            l.add((ColumnOperand)exp);
            exp = new Expression(FormattedOperator.UPCASE_OPERATOR, l);
            textToMatch = textToMatch.toUpperCase();
        }
        Expression exp1 = new Expression(FormattedOperator.LIKE_OPERATOR, (OperandInterface)((Object)exp), new StringOperand('%' + textToMatch));
        return this.getMasterWhere(exp1);
    }

    private WhereClause getMasterWhere(Expression searchExpression) {
        WhereClause newWhere = new WhereClause();
        if (this.whereClause != null) {
            OperandInterface exp2 = this.whereClause.getCondition();
            Expression exp = new Expression(FormattedOperator.AND_OPERATOR, searchExpression, exp2);
            newWhere.setCondition(exp);
        } else {
            newWhere.setCondition(searchExpression);
        }
        return newWhere;
    }

    private DataTypeInterface convertSQLTypeToDataType(int columnType) {
        IntegerType dt = null;
        switch (columnType) {
            case 2: 
            case 4: {
                dt = IntegerType.DEFAULT_INSTANCE;
                break;
            }
            case 1: {
                dt = StringType.DEFAULT_INSTANCE;
                break;
            }
            case 16: {
                dt = StringType.DEFAULT_INSTANCE;
                break;
            }
            case 91: {
                dt = DateType.DEFAULT_INSTANCE;
                break;
            }
            case 92: {
                dt = TimeType.DEFAULT_INSTANCE;
                break;
            }
            case 93: {
                dt = TimeStampType.DEFAULT_INSTANCE;
                break;
            }
            case 8: {
                dt = DoubleType.DEFAULT_INSTANCE;
                break;
            }
            case 6: {
                dt = DoubleType.DEFAULT_INSTANCE;
                break;
            }
            default: {
                dt = StringType.DEFAULT_INSTANCE;
            }
        }
        return dt;
    }

    public Object[] getValuesFromServer(Locale locale, String query, int index, int count) throws CacheException {
        Object[] objectArray;
        ResultSet resultSet = null;
        Statement statement = null;
        List valueItemsList = ListFactory.newList();
        try {
            boolean isOnResultSet;
            int labelDataType;
            this.establishConnection();
            statement = this.connection.createStatement(1004, 1007);
            if (count > 0) {
                statement.setMaxRows(index + count);
            }
            resultSet = statement.executeQuery(query);
            ResultSetMetaData rsMetadata = resultSet.getMetaData();
            int colCount = rsMetadata.getColumnCount();
            int valueDataType = labelDataType = rsMetadata.getColumnType(1);
            if (colCount > 1) {
                valueDataType = rsMetadata.getColumnType(2);
            }
            if (!(isOnResultSet = resultSet.absolute(++index))) {
                Object[] objectArray2 = new Object[]{};
                return objectArray2;
            }
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.getDefault());
            MissingValues mv = MissingValues.Dot;
            if (this.getDataType() instanceof StringType) {
                mv = MissingValues._BLANK_;
            }
            int valueColumnIndex = Math.min(colCount, 2);
            int labelColumnIndex = colCount;
            if (colCount >= 2) {
                labelColumnIndex = 1;
            }
            int valueItemIndex = 0;
            while (isOnResultSet) {
                Object valueData = null;
                Object labelData = null;
                boolean isMissing = false;
                if (colCount > 0) {
                    if (this.formatValues) {
                        valueData = resultSet.getString(valueColumnIndex);
                        if (this.isTrimValues() && valueData != null) {
                            valueData = ((String)valueData).trim();
                        }
                        if (resultSet.wasNull() || valueData == null || ((String)valueData).trim().length() == 0) {
                            valueData = mv;
                            isMissing = true;
                        }
                    } else {
                        valueData = valueDataType == 91 ? resultSet.getDate(valueColumnIndex, calendar) : (valueDataType == 92 ? resultSet.getTime(valueColumnIndex, calendar) : (valueDataType == 93 ? resultSet.getTimestamp(valueColumnIndex, calendar) : resultSet.getObject(valueColumnIndex)));
                        if (resultSet.wasNull() || valueData == null || valueData instanceof String && ((String)valueData).trim().length() == 0) {
                            valueData = mv;
                            isMissing = true;
                        }
                    }
                    if (this.formatLabels) {
                        labelData = resultSet.getString(labelColumnIndex);
                        if (this.isTrimLabels() && labelData != null && labelData instanceof String) {
                            labelData = ((String)labelData).trim();
                        }
                        if (colCount == 3) {
                            resultSet.getString(3);
                        }
                        if (resultSet.wasNull() || labelData == null || ((String)labelData).trim().length() == 0) {
                            labelData = MissingValues.toDisplayString((MissingValues)mv, (Locale)locale);
                            isMissing = true;
                        }
                    } else {
                        labelData = labelDataType == 91 ? resultSet.getDate(labelColumnIndex, calendar) : (labelDataType == 92 ? resultSet.getTime(labelColumnIndex, calendar) : (valueDataType == 93 ? resultSet.getTimestamp(labelColumnIndex, calendar) : resultSet.getObject(labelColumnIndex)));
                        if (colCount == 3) {
                            resultSet.getObject(3);
                        }
                        if (resultSet.wasNull() || labelData == null || labelData instanceof String && ((String)labelData).trim().length() == 0) {
                            labelData = MissingValues.toDisplayString((MissingValues)mv, (Locale)locale);
                            isMissing = true;
                        }
                    }
                }
                if (!(isMissing && this.removeMissingValues)) {
                    ValueItem distinctVal = new ValueItem(labelData, valueData);
                    valueItemsList.add(valueItemIndex++, distinctVal);
                }
                isOnResultSet = resultSet.next();
            }
            objectArray = valueItemsList.toArray(new ValueItem[0]);
        }
        catch (SQLException e) {
            throw new CacheException((Exception)e);
        }
        catch (ValueProviderException e) {
            throw new CacheException((Exception)((Object)e));
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                this.close();
            }
            catch (SQLException sQLException) {
            }
            catch (GenericError genericError) {}
        }
        return objectArray;
    }

    public Object clone() throws CloneNotSupportedException {
        ColumnValueProvider clone = (ColumnValueProvider)super.clone();
        clone.tableName = this.tableName;
        clone.valueColumn = this.valueColumn;
        clone.labelColumn = this.labelColumn;
        return clone;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ColumnInfo col;
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("LabelColumn");
        if (!list.isEmpty()) {
            col = (ColumnInfo)list.get(0);
            this.setLabelColumn(col);
            this.getLogger2().debug("consumeRelObjects, setLabelColumn() to ", col.getName());
        }
        if (!(list = roHolder.consumeObjects("ValueColumn")).isEmpty()) {
            col = (ColumnInfo)list.get(0);
            this.setValueColumn(col);
            this.getLogger2().debug("consumeRelObjects, setValueColumn() to ", col.getName());
        }
        if (!(list = roHolder.consumeObjects("Where")).isEmpty()) {
            WhereClause clause = (WhereClause)list.get(0);
            this.setWhereClause(clause);
            this.getLogger2().debug("consumeRelObjects, setWhereClause() ");
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.getLogger2().debug("Running consumeAttributes().");
        this.setDistinct(provider.consumeBooleanAttr("distinct", false));
        this.setLibref(provider.consumeAttr("libref"));
        this.setSortFirst(provider.consumeAttr("sortFirst"));
        this.setThreshold(provider.consumeIntAttr("threshold", DEFAULT_THRESHOLD));
        this.setTableName(provider.consumeAttr("tableName"));
        this.setFormatLabels(provider.consumeBooleanAttr("formatLabels", false));
        this.setFormatValues(provider.consumeBooleanAttr("formatValues", false));
        this.setValueDisplayed(provider.consumeBooleanAttr("valueDisplayed", false));
        this.setUseValueAsLabel(provider.consumeBooleanAttr("useValueAsLabel", false));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        ArrayList<PersistenceInterface> list;
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("Writing definition.");
        XmlUtil.setBooleanAttr(element, "distinct", this.isDistinct(), false);
        XmlUtil.setIntAttr(element, "threshold", this.getThreshold());
        XmlUtil.setAttr(element, "libref", this.getLibref());
        XmlUtil.setAttr(element, "sortFirst", this.getSortFirst());
        XmlUtil.setAttr(element, "tableName", this.getTableName());
        XmlUtil.setBooleanAttr(element, "useValueAsLabel", this.getUseValueAsLabel(), false);
        XmlUtil.setBooleanAttr(element, "formatLabels", this.isFormatLabels(), false);
        XmlUtil.setBooleanAttr(element, "formatValues", this.isFormatValues(), false);
        XmlUtil.setBooleanAttr(element, "valueDisplayed", this.isValueDisplayed(), false);
        if (null != this.getLabelColumn()) {
            this.getLogger2().debug("Writing labelColumn.");
            list = new ArrayList<PersistenceInterface>();
            list.add(this.getLabelColumn());
            ColumnValueProvider.writeRelatedObjects(list, element, writingContext, "LabelColumn");
        }
        if (null != this.getValueColumn()) {
            this.getLogger2().debug("Writing value Column.");
            list = new ArrayList();
            list.add(this.getValueColumn());
            ColumnValueProvider.writeRelatedObjects(list, element, writingContext, "ValueColumn");
        }
        if (null != this.getWhereClause()) {
            this.getLogger2().debug("Writing where clause.");
            list = new ArrayList();
            list.add(this.getWhereClause());
            ColumnValueProvider.writeRelatedObjects(list, element, writingContext, "Where");
        }
        this.writeMetadataDescriptor(writingContext);
    }

    protected void writeMetadataDescriptor(PromptsWritingContext writingContext) {
        if (null != this.getValueColumn() && null != this.getTableName() && !"".equals(this.getTableName())) {
            MetadataDescriptor md = PersistenceFactory.newMetadataDescriptor(null);
            md.setName(this.getTableName());
            md.setType("PHYSICAL_TABLE");
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("LIBREF", this.getLibref());
            md.setAdditionalInfo(info);
            writingContext.addMetadataDescriptor(md);
            this.getLogger2().debug("Created metadata descriptor.", md.toString());
        }
    }

    private void establishConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            if (this.host == null || this.port == null) {
                throw new SQLException(RB.getStringResource("ColumnValueProvider.invalidConnectionError.txt"));
            }
            WorkspaceConnector connector = null;
            Properties configurationData = new Properties();
            configurationData.put("userName", this.userName);
            try {
                String pw = SasPasswordString.decode((String)this.password);
                configurationData.put("password", pw);
            }
            catch (SasPasswordEncodingException se) {
                configurationData.put("password", this.password);
            }
            configurationData.put("host", this.host);
            configurationData.put("port", this.port);
            WorkspaceFactory wFactory = new WorkspaceFactory(new Properties[]{configurationData}, null, null);
            connector = wFactory.getWorkspaceConnector(0L);
            this.iWorkspace = connector.getWorkspace();
            Properties connectionProps = new Properties();
            this.connection = new MVAConnection(this.iWorkspace, connectionProps);
        }
    }

    private void close() throws GenericError, SQLException {
        if (this.iWorkspace != null) {
            this.iWorkspace.Close();
            this.iWorkspace = null;
            if (!this.isUserConnection && this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
    }

    public List getReferencedResources(Class arg0, boolean arg1) {
        if (null != this.whereClause && arg1) {
            return this.whereClause.getReferencedResources(arg0, arg1);
        }
        return Collections.EMPTY_LIST;
    }
}

