/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.valueprovider.olap;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringType;
import com.sas.iom.SASMDX.ISession;
import com.sas.models.MutableThresholdInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataEntityInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import com.sas.storage.olap.tree.DimensionNode;
import com.sas.storage.olap.tree.HierarchyNode;
import com.sas.storage.olap.tree.LevelNode;
import com.sas.storage.olap.tree.MemberNode;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;
import com.sas.storage.olap.tree.MetadataTreeModel;
import com.sas.storage.valueprovider.ListSearchInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueProviderUtil;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import javax.swing.tree.TreeModel;
import org.w3c.dom.Element;

public class MemberValueProvider
extends AbstractPersistence
implements ValueProviderInterface,
ListSearchInterface,
MutableThresholdInterface {
    public static int DEFAULT_THRESHOLD = 100;
    protected transient int threshold;
    protected String cubeName;
    protected String uniqueHierarchyName;
    protected String uniqueLevelName;
    protected String uniqueMemberName;
    protected ISession isession;
    protected MetadataEntityInterface metadataEntity;

    public MemberValueProvider() {
        this.init();
    }

    public MemberValueProvider(String cubeName, String hierarchyUniqueName) {
        this.cubeName = cubeName;
        this.uniqueHierarchyName = hierarchyUniqueName;
        this.init();
    }

    public MemberValueProvider(MetadataEntityInterface metadataEntity) {
        this.metadataEntity = metadataEntity;
        this.init();
    }

    public MemberValueProvider(ISession isession) {
        this.isession = isession;
        this.init();
    }

    private void init() {
        this.threshold = DEFAULT_THRESHOLD;
    }

    public ISession getISession() {
        return this.isession;
    }

    public void setISession(ISession isession) {
        this.isession = isession;
    }

    @Override
    public String getDefinitionElementName() {
        return "MemberValueProvider";
    }

    public final String getCubeName() {
        return this.cubeName;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public void setUniqueHierarchyName(String hierarchyName) {
        this.uniqueHierarchyName = hierarchyName;
    }

    public final String getUniqueHierarchyName() {
        return this.uniqueHierarchyName;
    }

    public void setUniqueLevelName(String levelName) {
        this.uniqueLevelName = levelName;
    }

    public final String getUniqueLevelName() {
        return this.uniqueLevelName;
    }

    public void setUniqueMemberName(String memberName) {
        this.uniqueMemberName = memberName;
    }

    public final String getUniqueMemberName() {
        return this.uniqueMemberName;
    }

    public int count() {
        return 0;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public boolean isSearchable() throws ValueProviderException {
        return this.getDataType() instanceof StringType;
    }

    @Override
    public DataTypeInterface getDataType() {
        return StringType.DEFAULT_INSTANCE;
    }

    @Override
    public Object getValues(Locale locale, SearchCriteria searchCriterion) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, searchCriterion, 0, this.threshold);
    }

    @Override
    public Object getValues(Locale locale) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, null, 0, this.threshold);
    }

    @Override
    public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, null, index, count);
    }

    @Override
    public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, returnType, null, 0, this.threshold);
    }

    @Override
    public Object getValues(Locale locale, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, searchCriteria, index, count);
    }

    @Override
    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, returnType, null, index, count);
    }

    private Object getValues(Locale locale, ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Object returnObject = null;
        if (returnType == ValueType.TREE) {
            returnObject = this.getValuesAsTree();
        } else if (returnType == ValueType.LIST) {
            returnObject = this.getValuesAsList(searchCriteria, index, count);
        } else {
            try {
                returnObject = this.getValuesAsTree();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (returnObject == null) {
                returnObject = this.getValuesAsList(searchCriteria, index, count);
            }
        }
        return returnObject;
    }

    protected TreeModel getValuesAsTree() throws ValueProviderException {
        MetadataTreeModel treeModel = null;
        try {
            this.setMetadataEntity();
            if (this.metadataEntity != null) {
                MetadataEntityTreeNode me = null;
                if (this.metadataEntity instanceof HierarchyInterface) {
                    me = new HierarchyNode((HierarchyInterface)this.metadataEntity, MetadataEntityTreeNode.MEMBER_TREE);
                    LevelInterface[] levels = ((HierarchyInterface)this.metadataEntity).getLevels();
                    if (levels != null && levels.length > 0) {
                        LevelInterface level = levels[1];
                        if (levels[0].getType() != 2) {
                            level = levels[0];
                        }
                        me = new LevelNode(level, MetadataEntityTreeNode.MEMBER_TREE);
                    }
                } else if (this.metadataEntity instanceof DimensionInterface) {
                    me = new DimensionNode((DimensionInterface)this.metadataEntity, MetadataEntityTreeNode.MEMBER_TREE);
                } else if (this.metadataEntity instanceof LevelInterface) {
                    me = new LevelNode((LevelInterface)this.metadataEntity, MetadataEntityTreeNode.MEMBER_TREE);
                } else if (this.metadataEntity instanceof MemberInterface) {
                    me = new MemberNode((MemberInterface)this.metadataEntity, MetadataEntityTreeNode.MEMBER_TREE);
                }
                if (me != null) {
                    treeModel = new MetadataTreeModel(me);
                    return treeModel;
                }
            }
        }
        catch (OLAPException oe) {
            throw new ValueProviderException(oe, oe.getMessage());
        }
        return treeModel;
    }

    protected Collection getValuesAsList(SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Vector<ValueItem> valueList = new Vector<ValueItem>();
        try {
            this.setMetadataEntity();
            if (this.metadataEntity != null) {
                if (searchCriteria != null) {
                    return this.doSearch(searchCriteria, index, count);
                }
                MemberInterface[] members = null;
                if (this.metadataEntity instanceof HierarchyInterface) {
                    members = this.getHierarchyMembers(index, count);
                } else if (this.metadataEntity instanceof DimensionInterface) {
                    members = this.getDimensionMembers(index, count);
                } else if (this.metadataEntity instanceof LevelInterface) {
                    members = this.getLevelMembers(index, count);
                } else if (this.metadataEntity instanceof MemberInterface) {
                    members = this.getMemberChildren(index, count);
                }
                if (members != null) {
                    for (int i = 0; i < members.length; ++i) {
                        ValueItem vi = new ValueItem((Object)members[i].getLabel(), (Object)members[i].getUniqueName());
                        valueList.add(vi);
                    }
                }
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return valueList;
    }

    private void setMetadataEntity() throws OLAPException, ValueProviderException {
        if (this.uniqueHierarchyName == null && this.uniqueLevelName == null && this.uniqueMemberName == null) {
            throw new ValueProviderException("Unable to resolve the item to get values for");
        }
        Metadata metadata = null;
        if (this.isession != null) {
            metadata = new Metadata(this.isession);
        }
        if (metadata == null) {
            return;
        }
        Filter inFilter = new Filter();
        inFilter.setCubeName(this.cubeName);
        if (this.uniqueMemberName != null) {
            inFilter.setUniqueMemberName(this.uniqueMemberName);
            this.metadataEntity = metadata.getMembers(inFilter, 0, 1)[0];
        } else if (this.uniqueLevelName != null) {
            inFilter.setUniqueLevelName(this.uniqueLevelName);
            this.metadataEntity = metadata.getLevel(inFilter);
        } else if (this.uniqueHierarchyName != null) {
            inFilter.setUniqueHierarchyName(this.uniqueHierarchyName);
            this.metadataEntity = metadata.getHierarchy(inFilter);
        }
    }

    private MemberInterface[] getHierarchyMembers(int index, int count) throws OLAPException {
        Filter inFilter = new Filter();
        inFilter.setCubeName(((HierarchyInterface)this.metadataEntity).getCube().getName());
        inFilter.setUniqueHierarchyName(this.metadataEntity.getUniqueName());
        MemberInterface[] members = this.metadataEntity.getMetadata().getMembers(inFilter, index, count);
        return members;
    }

    private MemberInterface[] getDimensionMembers(int index, int count) throws OLAPException {
        Filter inFilter = new Filter();
        inFilter.setCubeName(((DimensionInterface)this.metadataEntity).getCube().getName());
        inFilter.setUniqueDimensionName(this.metadataEntity.getUniqueName());
        MemberInterface[] members = this.metadataEntity.getMetadata().getMembers(inFilter, index, count);
        return members;
    }

    private MemberInterface[] getLevelMembers(int index, int count) throws OLAPException {
        Filter inFilter = new Filter();
        inFilter.setCubeName(((LevelInterface)this.metadataEntity).getCube().getName());
        inFilter.setUniqueLevelName(this.metadataEntity.getUniqueName());
        MemberInterface[] members = this.metadataEntity.getMetadata().getMembers(inFilter, index, count);
        return members;
    }

    private MemberInterface[] getMemberChildren(int index, int count) throws OLAPException {
        MemberInterface m = (MemberInterface)this.metadataEntity;
        Filter inFilter = new Filter();
        inFilter.setCubeName(m.getCube().getName());
        inFilter.setUniqueMemberName(m.getUniqueName());
        inFilter.setTreeOperator(Filter.CHILDREN_TREE_OPERATOR);
        return m.getMetadata().getMembers(inFilter, index, count);
    }

    public Object clone() throws CloneNotSupportedException {
        MemberValueProvider clone = (MemberValueProvider)super.clone();
        clone.cubeName = this.cubeName;
        clone.uniqueHierarchyName = this.uniqueHierarchyName;
        clone.isession = this.isession;
        clone.metadataEntity = this.metadataEntity;
        return clone;
    }

    private Collection doSearch(SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        this.verifySearchCriteria(searchCriteria);
        Collection searchResults = null;
        String searchQuery = this.buildSearchQuery(searchCriteria);
        searchResults = this._executeQuery(searchQuery, index, count);
        return searchResults;
    }

    protected void verifySearchCriteria(SearchCriteria searchCriteria) throws IllegalArgumentException {
    }

    private String buildSearchQuery(SearchCriteria searchCriteria) throws ValueProviderException {
        if (searchCriteria == null) {
            return "";
        }
        String searchFilterMDX = null;
        Object operator = searchCriteria.getOperator();
        if (this._isContainsSearch(searchCriteria)) {
            searchFilterMDX = this._buildContainsSearchQuery(searchCriteria);
        } else if (this._isEqualsSearch(searchCriteria)) {
            searchFilterMDX = this._buildEqualsSearchQuery(searchCriteria);
        } else if (SearchCriteria.OPERATOR_STARTS_WITH.equals(operator)) {
            searchFilterMDX = this._buildStartsWithSearchQuery(searchCriteria);
        } else if (SearchCriteria.OPERATOR_ENDS_WITH.equals(operator)) {
            searchFilterMDX = this._buildEndsWithSearchQuery(searchCriteria);
        } else if (SearchCriteria.OPERATOR_MATCH_PATTERN.equals(operator)) {
            searchFilterMDX = this._buildMatchPatternSearchQuery(searchCriteria);
        }
        return searchFilterMDX;
    }

    private Collection _executeQuery(String mdxQuery, int index, int count) throws ValueProviderException {
        OLAPDataSetInterface olapDataSet = null;
        try {
            if (this.isession != null) {
                olapDataSet = new OLAPDataSet(this.isession);
            }
            if (olapDataSet == null) {
                return Collections.EMPTY_LIST;
            }
            olapDataSet.setQueryStatement(mdxQuery);
            olapDataSet.setContextType(1);
            ResultSetMetadataInterface resultSetMeta = olapDataSet.getResultSetMetadata();
            TupleInterface[] tuples = resultSetMeta.getTuples(0, index, count);
            ArrayList<ValueItem> l = new ArrayList<ValueItem>(tuples.length);
            for (int i = 0; i < tuples.length; ++i) {
                TupleElementInterface[] tupleElement = tuples[i].getElements(0, 1);
                ValueItem vi = new ValueItem((Object)tupleElement[0].getLabel(), (Object)tupleElement[0].getName());
                List path = Collections.EMPTY_LIST;
                if (tupleElement[0].getLevelDepth() > 1) {
                    path = ValueProviderUtil.splitOLAPName(tupleElement[0].getName());
                }
                vi.setAttribute(ValueItem.PARENT, (Object)path);
                l.add(vi);
            }
            return l;
        }
        catch (OLAPException e) {
            throw new ValueProviderException(e, e.getMessage());
        }
    }

    private boolean _isContainsSearch(SearchCriteria searchCriteria) {
        Object operator = searchCriteria.getOperator();
        return SearchCriteria.OPERATOR_CONTAINS.equals(operator) || SearchCriteria.OPERATOR_NOT_CONTAINS.equals(operator);
    }

    private boolean _isEqualsSearch(SearchCriteria searchCriteria) {
        Object operator = searchCriteria.getOperator();
        return SearchCriteria.OPERATOR_EQUAL.equals(operator) || SearchCriteria.OPERATOR_NOT_EQUAL.equals(operator);
    }

    private String _buildMatchPatternSearchQuery(SearchCriteria searchCriteria) throws ValueProviderException {
        return this.buildSearchQuery(searchCriteria.getTextToMatch());
    }

    private String _buildStartsWithSearchQuery(SearchCriteria searchCriteria) throws ValueProviderException {
        return this.buildSearchQuery(searchCriteria.getTextToMatch() + '*');
    }

    private String _buildEndsWithSearchQuery(SearchCriteria searchCriteria) throws ValueProviderException {
        return this.buildSearchQuery('*' + searchCriteria.getTextToMatch());
    }

    private String queryString(String textToMatch) {
        int len = textToMatch.length();
        String returnString = textToMatch;
        if (len == 0) {
            returnString = "$";
        } else {
            returnString = textToMatch.replace('?', '.');
            int aestrikIndex = textToMatch.lastIndexOf(42);
            if (len == 1 && aestrikIndex == len - 1) {
                returnString = returnString.replace('*', '$');
            } else if (aestrikIndex == len - 1) {
                returnString = '^' + textToMatch.substring(0, aestrikIndex);
            } else if (aestrikIndex == 0) {
                returnString = textToMatch.substring(aestrikIndex + 1, len) + '$';
            }
        }
        return returnString;
    }

    private String buildSearchQuery(String textToMatch) throws ValueProviderException {
        try {
            String metadataEntityName = null;
            String dimensionName = null;
            if (this.metadataEntity != null) {
                if (this.metadataEntity instanceof HierarchyInterface || this.metadataEntity instanceof DimensionInterface) {
                    dimensionName = metadataEntityName = this.metadataEntity.getUniqueName();
                } else if (this.metadataEntity instanceof LevelInterface) {
                    metadataEntityName = this.metadataEntity.getUniqueName();
                    dimensionName = ((LevelInterface)this.metadataEntity).getHierarchy().getName();
                }
            }
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT FILTER (");
            if (metadataEntityName != null && dimensionName != null) {
                sb.append("{");
                sb.append(metadataEntityName);
                sb.append(".MEMBERS }, ");
                sb.append("PRXMATCH( PRXPARSE( ");
                sb.append("\"");
                sb.append("'");
                sb.append(this.queryString(textToMatch).toUpperCase());
                sb.append("'");
                sb.append("\"");
                sb.append("), ");
                sb.append("UPCASE( ");
                sb.append(dimensionName);
                sb.append(".currentMember.name))) ");
                sb.append("ON COLUMNS FROM ");
                sb.append(this.cubeName);
            }
            return sb.toString();
        }
        catch (OLAPException oe) {
            throw new ValueProviderException("Search Failed");
        }
    }

    private String _buildContainsSearchQuery(SearchCriteria searchCriteria) throws ValueProviderException {
        String searchFilterMDX = null;
        try {
            String name = null;
            String dimName = null;
            if (this.metadataEntity != null) {
                if (this.metadataEntity instanceof HierarchyInterface || this.metadataEntity instanceof DimensionInterface) {
                    dimName = name = this.metadataEntity.getUniqueName();
                } else if (this.metadataEntity instanceof LevelInterface) {
                    name = this.metadataEntity.getUniqueName();
                    dimName = ((LevelInterface)this.metadataEntity).getHierarchy().getName();
                }
            }
            String textToMatch = searchCriteria.getTextToMatch();
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT FILTER (");
            if (name != null && dimName != null) {
                sb.append("{");
                sb.append(name);
                sb.append(".MEMBERS }, ");
                sb.append("FIND( ");
                sb.append(dimName);
                sb.append(".currentMember.name,  ");
                sb.append("\"");
                sb.append(textToMatch);
                sb.append("\", ");
                sb.append("'i')) ");
                sb.append("ON COLUMNS FROM ");
                sb.append(this.cubeName);
            }
            searchFilterMDX = sb.toString();
        }
        catch (OLAPException oe) {
            throw new ValueProviderException(oe, oe.getMessage());
        }
        System.out.println(searchFilterMDX);
        return searchFilterMDX;
    }

    private String buildEqualsSearchQuery(SearchCriteria searchCriteria, boolean isNegated) throws ValueProviderException {
        String searchFilterMDX = null;
        try {
            String textToMatch = searchCriteria.getTextToMatch();
            int len = textToMatch.length();
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT FILTER (");
            String name = null;
            String dimName = null;
            if (this.metadataEntity != null) {
                if (this.metadataEntity instanceof HierarchyInterface || this.metadataEntity instanceof DimensionInterface) {
                    dimName = name = this.metadataEntity.getUniqueName();
                } else if (this.metadataEntity instanceof LevelInterface) {
                    name = this.metadataEntity.getUniqueName();
                    dimName = ((LevelInterface)this.metadataEntity).getHierarchy().getName();
                }
            }
            if (name != null && dimName != null) {
                sb.append("{");
                sb.append(name);
                sb.append(".MEMBERS }, ");
                sb.append("SUBSTR( UPCASE( ");
                sb.append(dimName);
                sb.append(".currentMember.name),");
                sb.append("1 ");
                sb.append(") = ");
                sb.append("\"");
                sb.append(textToMatch.toUpperCase());
                sb.append("\") ");
                sb.append("ON COLUMNS FROM ");
                sb.append(this.cubeName);
            }
            searchFilterMDX = sb.toString();
        }
        catch (OLAPException oe) {
            throw new ValueProviderException(oe, oe.getMessage());
        }
        System.out.println(searchFilterMDX);
        return searchFilterMDX;
    }

    private String _buildEqualsSearchQuery(SearchCriteria searchCriteria) throws ValueProviderException {
        Object operator = searchCriteria.getOperator();
        boolean isNegated = SearchCriteria.OPERATOR_NOT_EQUAL.equals(operator);
        return this.buildEqualsSearchQuery(searchCriteria, isNegated);
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.getLogger2().debug("Running consumeAttributes().");
        this.setCubeName(provider.consumeAttr("cubeName"));
        this.setUniqueHierarchyName(provider.consumeAttr("uniqueHierarchyName"));
        this.setUniqueLevelName(provider.consumeAttr("uniqueLevelName"));
        this.setUniqueMemberName(provider.consumeAttr("uniqueMemberName"));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("Writing definition.");
        XmlUtil.setIntAttr(element, "threshold", this.getThreshold(), DEFAULT_THRESHOLD);
        XmlUtil.setAttr(element, "cubeName", this.getCubeName());
        XmlUtil.setAttr(element, "uniqueHierarchyName", this.getUniqueHierarchyName());
        XmlUtil.setAttr(element, "uniqueLevelName", this.getUniqueLevelName());
        XmlUtil.setAttr(element, "uniqueMemberName", this.getUniqueMemberName());
        MetadataDescriptor md = PersistenceFactory.newMetadataDescriptor(null);
        md.setName(this.getCubeName());
        md.setType("OLAP_CUBE");
        writingContext.addMetadataDescriptor(md);
    }

    @Override
    public boolean isValueDisplayed() {
        return false;
    }
}

