/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.valueprovider;

import com.sas.storage.valueprovider.ValueItemPersister;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ValueItemList
extends AbstractPersistence {
    private List valueItems;

    public ValueItemList() {
    }

    public ValueItemList(List valueItems) {
        this.valueItems = valueItems;
    }

    public List getValueItems() {
        return this.valueItems;
    }

    public void setValueItems(List valueItems) {
        this.valueItems = valueItems;
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList persisterList = roHolder.consumeObjects("ValueItems");
        if (persisterList != null && persisterList.size() > 0) {
            this.valueItems = this.convertPersistersToValueItems(persisterList);
        }
    }

    @Override
    public String getDefinitionElementName() {
        return "ValueItemList";
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        ValueItemList.writeRelatedObjects(this.convertValueItemsToPersisters(this.valueItems), element, writingContext, "ValueItems");
    }

    private List convertValueItemsToPersisters(List valueItems) {
        ArrayList<ValueItemPersister> persisters = new ArrayList<ValueItemPersister>(valueItems.size());
        int n = valueItems.size();
        for (int i = 0; i < n; ++i) {
            persisters.add(new ValueItemPersister((ValueItem)valueItems.get(i)));
        }
        return persisters;
    }

    private List convertPersistersToValueItems(List persisterList) {
        ArrayList<ValueItem> valueItems = new ArrayList<ValueItem>(persisterList.size());
        int n = persisterList.size();
        for (int i = 0; i < n; ++i) {
            ValueItemPersister persister = (ValueItemPersister)persisterList.get(i);
            valueItems.add(persister.getValueItem());
        }
        return valueItems;
    }
}

