/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.valueprovider;

import com.sas.prompts.datatypes.values.StringValue;
import com.sas.util.Strings;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SearchCriteria
extends AbstractPersistence {
    public static final Object OPERATOR_CONTAINS = "CONTAINS";
    public static final Object OPERATOR_EQUAL = "EQUAL";
    public static final Object OPERATOR_STARTS_WITH = "STARTS WITH";
    public static final Object OPERATOR_ENDS_WITH = "ENDS WITH";
    public static final Object OPERATOR_MATCH_PATTERN = "MATCH PATTERN";
    public static final Object OPERATOR_NOT_EQUAL = "OPERATOR_NOT_EQUAL";
    public static final Object OPERATOR_NOT_CONTAINS = "OPERATOR_NOT_CONTAINS";
    private Object _operator = null;
    private String _textToMatch = null;
    private boolean _isFormattedValueSearch;
    private boolean _isCaseSensitiveSearch = false;

    @Override
    public String getDefinitionElementName() {
        return "SearchCriteria";
    }

    public Object getOperator() {
        return this._operator;
    }

    public void setOperator(Object operator) {
        this._operator = operator;
    }

    public String getTextToMatch() {
        return this._textToMatch;
    }

    public void setTextToMatch(String textToMatch) {
        this._textToMatch = textToMatch;
    }

    public boolean isFormattedValueSearch() {
        return this._isFormattedValueSearch;
    }

    public void setFormattedValueSearch(boolean isFormattedValueSearch) {
        this._isFormattedValueSearch = isFormattedValueSearch;
    }

    public boolean isCaseSensitiveSearch() {
        return this._isCaseSensitiveSearch;
    }

    public void setCaseSensitiveSearch(boolean isCaseSensitiveSearch) {
        this._isCaseSensitiveSearch = isCaseSensitiveSearch;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        this.getLogger2().debug("consumeRelObjects, Creating Operator.");
        ArrayList operatorList = roHolder.consumeObjects("Operator");
        this.processOperator(operatorList);
    }

    private void processOperator(List operatorList) {
        if (operatorList != null && operatorList.size() == 1) {
            StringValue sv = (StringValue)operatorList.get(0);
            String value = (String)sv.getValue();
            if (Strings.equal((String)value, (String)((String)OPERATOR_CONTAINS), (boolean)false, (boolean)false)) {
                this._operator = OPERATOR_CONTAINS;
            } else if (Strings.equal((String)value, (String)((String)OPERATOR_EQUAL), (boolean)false, (boolean)false)) {
                this._operator = OPERATOR_EQUAL;
            } else if (Strings.equal((String)value, (String)((String)OPERATOR_STARTS_WITH), (boolean)false, (boolean)false)) {
                this._operator = OPERATOR_STARTS_WITH;
            } else if (Strings.equal((String)value, (String)((String)OPERATOR_ENDS_WITH), (boolean)false, (boolean)false)) {
                this._operator = OPERATOR_ENDS_WITH;
            } else if (Strings.equal((String)value, (String)((String)OPERATOR_MATCH_PATTERN), (boolean)false, (boolean)false)) {
                this._operator = OPERATOR_MATCH_PATTERN;
            }
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.getLogger2().debug("Running consumeAttributes().");
        this.setTextToMatch(provider.consumeAttr("textToMatch"));
        this.setCaseSensitiveSearch(provider.consumeBooleanAttr("isCaseSensitiveSearch", false));
        provider.consumeBooleanAttr("isFormattedSearch", false);
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setBooleanAttr(element, "isCaseSensitiveSearch", this.isCaseSensitiveSearch(), false);
        XmlUtil.setAttr(element, "textToMatch", this.getTextToMatch());
        List list = this.getWritableOperators();
        if (list != null) {
            SearchCriteria.writeRelatedObjects(list, element, writingContext, "Operator");
        }
    }

    private List getWritableOperators() {
        if (this._operator == null) {
            return null;
        }
        ArrayList<StringValue> list = new ArrayList<StringValue>(1);
        StringValue value = new StringValue();
        value.setValue(this._operator.toString());
        list.add(value);
        return list;
    }
}

