/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.simplesqlmodel;

import com.sas.storage.simplesqlmodel.BaseValueOperand;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.ValueOperandInterface;
import java.util.Locale;
import java.util.Map;

public class IntegerOperand
extends BaseValueOperand
implements OperandInterface {
    public IntegerOperand() {
        this(0);
    }

    public IntegerOperand(int value) {
        this.setValue((Object)value);
    }

    @Override
    public String getOperandAsString(Map context) {
        return "" + this.getValueAsInt();
    }

    public int getValueAsInt() {
        Integer i = (Integer)this.getValue();
        return i;
    }

    public void setValue(int value) {
        this.setValue((Object)value);
    }

    @Override
    public boolean evaluateOperandAsBoolean(Locale locale, Map context) {
        if (this.getValue() == null) {
            return false;
        }
        return this.getValueAsInt() != 0;
    }

    @Override
    public String getDefinitionElementName() {
        return "IntegerOperand";
    }

    @Override
    public int compareTo(ValueOperandInterface o, Locale locale) {
        if (this.getValue() == null && o.getValue() == null) {
            return 0;
        }
        if (this.getValue() == null) {
            return -1;
        }
        if (o.getValue() == null) {
            return 1;
        }
        Integer d = this.getValueAsInt();
        Integer od = ((IntegerOperand)o).getValueAsInt();
        return d.compareTo(od);
    }

    public String toString() {
        return this.getOperandAsString(null);
    }
}

