/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.retriever.dto;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public enum ValueDataType {
    STRING,
    INTEGER,
    DOUBLE,
    NUMBER,
    DATE,
    TIME,
    TIME_STAMP,
    MISSING_VALUE,
    METADATA_ITEM,
    QUERY_ITEM,
    VALUEITEM,
    FOLDER,
    OLAP_HIERARCHY_METADATA,
    OLAP_DIMENSION_METADATA,
    OLAP_MEASURE_METADATA,
    LIBRARY_METADATA,
    TABLE_METADATA,
    COLUMN_METADATA,
    HIERARCHY_METADATA,
    SPECIAL_VALUE;

    private ValueDataType _dataType;

    public ValueDataType getDataType() {
        return this._dataType;
    }

    public void setDataType(ValueDataType dt) {
        this._dataType = dt;
    }

    public void readExternal(ObjectInput in) throws IOException {
        this._dataType = ValueDataType.valueOf(in.readUTF());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this._dataType.toString());
    }

    public final String getEquivalentPersistedValue() {
        switch (this.ordinal()) {
            case 0: {
                return "StringType";
            }
            case 2: {
                return "DoubleType";
            }
            case 4: {
                return "DateType";
            }
            case 5: {
                return "TimeType";
            }
            case 1: {
                return "IntegerType";
            }
        }
        return null;
    }
}

