/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.retriever;

import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.storage.retriever.ListValueRetriever;
import com.sas.storage.retriever.LocalizableColumnLabel;
import com.sas.storage.retriever.LocalizableColumnValue;
import com.sas.storage.retriever.ValueRetrieverConfiguration;
import com.sas.storage.retriever.dto.ColumnValueItem;
import com.sas.uiconfig.ResourceBundleDelegate;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class StaticValueRetrieverConfiguration
extends ValueRetrieverConfiguration
implements ListValueRetriever,
MultiLocaleProperties {
    private static final long serialVersionUID = 1L;
    private LocalizableColumnValue valueItem = new LocalizableColumnValue();
    private List<LocalizableColumnLabel> labelsList = new LinkedList<LocalizableColumnLabel>();
    private Locale locale = Locale.getDefault();
    private transient ResourceBundleDelegate resourceBundleDelegate;
    public static final String RB_KEY = "StaticValueRetrieverConfiguration.";
    public static final String CONFIG_ATTRIBUTE_VALUE_ITEM_LIST = "StaticValueRetrieverConfiguration.CONFIG_ATTRIBUTE_VALUE_ITEM_LIST";
    public static final String CONFIG_ATTRIBUTE_LOCALIZED_LABELS_LIST = "StaticValueRetrieverConfiguration.CONFIG_ATTRIBUTE_LOCALIZED_LABELS_LIST";
    public static final String CONFIG_ATTRIBUTE_LOCALIZED_LABEL_FOR_VALUE_ITEM = "StaticValueRetrieverConfiguration.CONFIG_ATTRIBUTE_LOCALIZED_LABEL_FOR_VALUE_ITEM";
    public static final String CONFIG_ATTRIBUTE_LOCALE = "StaticValueRetrieverConfiguration.CONFIG_ATTRIBUTE_LOCALE";

    @Override
    public List<ColumnValueItem> getValuesAsList(@NotNull Locale locale1, int fromIndex, int count) {
        ValidateArg.notNull((Object)locale1, (String)"locale");
        ArrayList<ColumnValueItem> listToReturn = new ArrayList<ColumnValueItem>();
        this.getLogger2().debug("getValuesAsList() for locale, fromIndex, count:", locale1.toString() + Integer.toString(fromIndex) + Integer.toString(count));
        this.valueItem.setResourceBundleDelegate(this.resourceBundleDelegate);
        ColumnValueItem cvi4Locale = this.valueItem.getDataSubset(locale1, fromIndex, count);
        if (cvi4Locale.getName() != null) {
            for (LocalizableColumnLabel labelItem : this.labelsList) {
                labelItem.setResourceBundleDelegate(this.resourceBundleDelegate);
                ColumnValueItem label = labelItem.getDataSubset(locale1, fromIndex, count);
                listToReturn.add(label);
            }
            listToReturn.add(cvi4Locale);
        }
        this.getLogger2().debug("getValuesAsList() returns list of size:", Integer.toString(listToReturn.size()));
        return listToReturn;
    }

    public void setValueColumn(@NotNull ColumnValueItem valueItem) {
        ValidateArg.notNull((Object)valueItem, (String)"valueItem");
        ValidateArg.notBlank((String)valueItem.getName(), (String)"column name");
        ValidateArg.notNull((Object)((Object)valueItem.getDataType()), (String)"data type");
        this.valueItem.setData(valueItem);
        if (valueItem.getLocale() != null && !this.getUsersLocale().toString().equals(valueItem.getLocale())) {
            this.setUsersLocale(XmlUtil.xmlToLocale(valueItem.getLocale()));
        }
    }

    public ColumnValueItem getValueColumn() {
        return this.valueItem.getDataSubset(this.getUsersLocale(), -1, -1);
    }

    public void setAllLabels(List<ColumnValueItem> list) {
        ValidateArg.notNull(list, (String)"list");
        this.labelsList.clear();
        for (ColumnValueItem item : list) {
            LocalizableColumnLabel label = new LocalizableColumnLabel();
            label.setData(item);
            this.labelsList.add(label);
        }
    }

    public List<ColumnValueItem> getAllLabels() {
        ArrayList<ColumnValueItem> listToReturn = new ArrayList<ColumnValueItem>();
        for (LocalizableColumnLabel labelItem : this.labelsList) {
            listToReturn.add(labelItem.getDataSubset(this.getUsersLocale(), -1, -1));
        }
        return listToReturn;
    }

    private boolean addLocalizedLabels(List<ColumnValueItem> labels) {
        boolean retVal = false;
        for (ColumnValueItem labelToAdd : labels) {
            for (LocalizableColumnLabel label : this.labelsList) {
                if (!label.matches(labelToAdd)) continue;
                Locale locale = XmlUtil.xmlToLocale(labelToAdd.getLocale());
                retVal = label.addLabels(locale, labelToAdd.getRowData());
                label.setColumnLabel(locale, labelToAdd.getLabel());
            }
        }
        return retVal;
    }

    private void addHeaderForValueColumn(Locale locale1, String label) {
        this.valueItem.setColumnLabel(locale1, label);
    }

    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        ValidateArg.notNull(options, (String)"options");
        if (options.containsKey(CONFIG_ATTRIBUTE_VALUE_ITEM_LIST)) {
            this.getLogger2().debug("configureAttributes() applyValueColumnList called.");
            this.applyColumValueItemList((List)options.get(CONFIG_ATTRIBUTE_VALUE_ITEM_LIST));
        }
        if (options.containsKey(CONFIG_ATTRIBUTE_LOCALE) && options.containsKey(CONFIG_ATTRIBUTE_LOCALIZED_LABEL_FOR_VALUE_ITEM)) {
            this.getLogger2().debug("configureAttributes() addLabelForValueColumn called.");
            Locale locale1 = XmlUtil.xmlToLocale((String)options.get(CONFIG_ATTRIBUTE_LOCALE));
            this.addHeaderForValueColumn(locale1, (String)options.get(CONFIG_ATTRIBUTE_LOCALIZED_LABEL_FOR_VALUE_ITEM));
        }
        if (options.containsKey(CONFIG_ATTRIBUTE_LOCALIZED_LABELS_LIST)) {
            this.getLogger2().debug("configureAttributes() addLocalizedLabels");
            this.addLocalizedLabels((List)options.get(CONFIG_ATTRIBUTE_LOCALIZED_LABELS_LIST));
        }
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList labels = roHolder.consumeObjects("LabelColumns");
        LocalizableColumnValue value = (LocalizableColumnValue)roHolder.consumeObject("ValueColumn");
        if (null != value) {
            this.valueItem = value;
            this.getLogger2().debug("consumeRelObjects, setting value.");
        }
        if (!labels.isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, setting labels.");
            this.labelsList = labels;
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("Writing value item.");
        ArrayList<PersistenceInterface> value = new ArrayList<PersistenceInterface>();
        value.add(this.valueItem);
        StaticValueRetrieverConfiguration.writeRelatedObjects(value, element, writingContext, "ValueColumn");
        this.getLogger2().debug("Writing labels.");
        ArrayList<PersistenceInterface> labels = new ArrayList<PersistenceInterface>();
        labels.addAll(this.labelsList);
        StaticValueRetrieverConfiguration.writeRelatedObjects(labels, element, writingContext, "LabelColumns");
    }

    @Override
    public String getDefinitionElementName() {
        return null;
    }

    private void applyColumValueItemList(List<ColumnValueItem> cviList) {
        ValidateArg.notNull(cviList, (String)"cviList");
        if (cviList.size() >= 1) {
            this.setValueColumn(cviList.get(0));
        }
        if (cviList.size() > 1) {
            this.setAllLabels(cviList.subList(1, cviList.size()));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        StaticValueRetrieverConfiguration retVal = (StaticValueRetrieverConfiguration)super.clone();
        for (LocalizableColumnLabel lcl : this.labelsList) {
            retVal.labelsList.add((LocalizableColumnLabel)lcl.clone());
        }
        retVal.locale = this.getUsersLocale();
        retVal.valueItem = (LocalizableColumnValue)this.valueItem.clone();
        return retVal;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    public Locale getUsersLocale() {
        return this.locale;
    }

    public void setUsersLocale(@NotNull Locale locale) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        this.locale = locale;
        this.getLogger2().debug("setUsersLocale() is now ", locale.toString());
    }

    @Override
    public void beginLocalization() throws UnexpectedLocalizationException {
    }

    @Override
    public void endLocalization() throws UnexpectedLocalizationException {
    }

    public Collection getLocales() throws UnexpectedLocalizationException {
        if (null != this.valueItem) {
            return this.valueItem.getLocales();
        }
        return Collections.emptyList();
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale1) throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        list.addComment("StaticValueRetrieverConfiguration, the value column");
        list.addComment("The value is the column header text.");
        PropertyList viList = this.valueItem.getLocalizableProperties(locale1);
        list.addProperty("ValueColumn", viList);
        if (!this.labelsList.isEmpty()) {
            int i = 0;
            for (LocalizableColumnLabel lcl : this.labelsList) {
                list.addComment("StaticValueRetrieverConfiguration, a label column");
                list.addComment("The value is the column header text.");
                list.addComment("The rowLabel is the text for row of this column.");
                PropertyList lcList = lcl.getLocalizableProperties(locale1);
                list.addProperty("LabelColumn", i, lcList);
                ++i;
            }
            this.getLogger2().debug("getLocalizableProperties(), added label columns", Integer.toString(i));
        }
        return list;
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        this.getLogger2().debug("setLocalizableProperties, label cols=", Integer.toString(this.labelsList.size()));
        if (map.containsNestedProperty("ValueColumn")) {
            this.valueItem.setLocalizableProperties(locale, map.getNestedProperties("ValueColumn"));
        }
        int i = 0;
        for (LocalizableColumnLabel lcl : this.labelsList) {
            if (map.containsIndexedNestedProperty("LabelColumn")) {
                lcl.setLocalizableProperties(locale, map.getNestedProperties("LabelColumn", i));
            }
            ++i;
        }
    }

    @Override
    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        return this.getLocalizableProperties(this.getUsersLocale());
    }

    @Override
    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        this.setLocalizableProperties(this.getUsersLocale(), map);
    }

    public void setResourceBundleDelegate(ResourceBundleDelegate resourceBundleDelegate) {
        this.resourceBundleDelegate = resourceBundleDelegate;
    }
}

