/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.retriever;

import com.sas.util.ValidateArg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

final class LocaleToListMap
implements Map<Locale, List<Object>> {
    private Map<Locale, List<Object>> map = new LinkedHashMap<Locale, List<Object>>();

    LocaleToListMap() {
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Locale, List<Object>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public List<Object> get(Object locale) {
        Locale systemDefaultLocale;
        if (this.map.containsKey(locale)) {
            return this.map.get(locale);
        }
        if (null != locale && locale instanceof Locale) {
            Locale langLocale;
            Locale castLocale = (Locale)locale;
            boolean hasCountry = false;
            boolean hasLanguage = false;
            String language = "";
            if (null != castLocale.getCountry() && castLocale.getCountry().length() > 0) {
                hasCountry = true;
            }
            if (null != castLocale.getLanguage() && castLocale.getLanguage().length() > 0) {
                hasLanguage = true;
                language = castLocale.getLanguage();
            }
            if (hasCountry && hasLanguage && this.map.containsKey(langLocale = new Locale(language))) {
                return this.map.get(langLocale);
            }
            if (hasLanguage) {
                Set<Map.Entry<Locale, List<Object>>> entries = this.map.entrySet();
                for (Map.Entry<Locale, List<Object>> entry : entries) {
                    if (!language.equals(entry.getKey().getLanguage())) continue;
                    return entry.getValue();
                }
            }
        }
        if (!(systemDefaultLocale = Locale.getDefault()).equals(locale)) {
            return this.get(systemDefaultLocale);
        }
        if (this.size() >= 1) {
            return this.values().iterator().next();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Locale> keySet() {
        return this.map.keySet();
    }

    @Override
    public List<Object> put(Locale locale, List<Object> value) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        ValidateArg.notNull(value, (String)"value");
        ArrayList<Object> mine = new ArrayList<Object>();
        mine.addAll(value);
        return this.map.put(locale, mine);
    }

    @Override
    public List<Object> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<List<Object>> values() {
        return this.map.values();
    }

    @Override
    public void putAll(Map<? extends Locale, ? extends List<Object>> t) {
        this.map.putAll(t);
    }
}

