/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.tree;

import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.tree.MeasureNode;
import com.sas.storage.olap.tree.MemberNode;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;
import javax.swing.tree.TreeNode;

public class LevelNode
extends MetadataEntityTreeNode {
    private LevelInterface level;

    public LevelNode(LevelInterface level) {
        this(level, MetadataEntityTreeNode.DEFAULT_TREE, false);
    }

    public LevelNode(LevelInterface level, int treeType) {
        this(level, treeType, false);
    }

    public LevelNode(LevelInterface level, int treeType, boolean displayAllMember) {
        this.level = level;
        this.userObject = level;
        this.setTreeType(treeType);
        this.setDisplayAllMember(displayAllMember);
    }

    public LevelNode(MetadataInterface metadata, String cubeName, String levelUniqueName) {
        this(metadata, cubeName, levelUniqueName, MetadataEntityTreeNode.DEFAULT_TREE, false);
    }

    public LevelNode(MetadataInterface metadata, String cubeName, String levelUniqueName, int treeType) {
        this(metadata, cubeName, levelUniqueName, treeType, false);
    }

    public LevelNode(MetadataInterface metadata, String cubeName, String levelUniqueName, int treeType, boolean displayAllMember) {
        this.findLevel(metadata, cubeName, levelUniqueName);
        if (this.level == null) {
            this.createDummyNode(levelUniqueName);
        }
        this.setTreeType(treeType);
        this.setDisplayAllMember(this.displayAllMember());
    }

    @Override
    public int getChildCount() {
        try {
            if (this.childCount == -1) {
                this.childCount = this.level.getMembers().length;
            }
        }
        catch (OLAPException oe) {
            return 0;
        }
        return this.childCount;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (!this.initialized) {
            this.populateChildren();
        }
        if (index >= 0 && index < this.childCount && super.getChildAt(index) == null) {
            this.populateChildren();
        }
        return super.getChildAt(index);
    }

    @Override
    protected synchronized boolean populateChildren() {
        block6: {
            try {
                boolean isMeasure;
                if (this.getChildCount() <= 0) break block6;
                boolean bl = isMeasure = this.level.getHierarchy().getDimension().getType() == 2;
                if (isMeasure) {
                    MeasureInterface[] measures = this.level.getCube().getMeasures();
                    this.childCount = measures.length;
                    for (int j = 0; j < measures.length; ++j) {
                        MeasureNode m = new MeasureNode(measures[j]);
                        super.insert(m, j);
                        m.setParent(this);
                        m.setThreshold(this.threshold);
                    }
                } else {
                    MemberInterface[] members = this.level.getMembers(0, this.threshold);
                    this.childCount = members.length;
                    for (int j = 0; j < members.length; ++j) {
                        MemberNode m = new MemberNode(members[j], this.treeType, this.displayAllMember());
                        super.insert(m, j);
                        m.setParent(this);
                        m.setThreshold(this.threshold);
                    }
                }
                this.initialized = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.initialized;
    }

    private LevelInterface findLevel(MetadataInterface metadata, String cubeName, String uniqueName) {
        try {
            Filter filter = new Filter();
            filter.setCubeName(cubeName);
            filter.setUniqueLevelName(uniqueName);
            this.level = metadata.getLevel(filter);
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return this.level;
    }
}

