/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.tree;

import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;
import com.sas.storage.olap.tree.TupleElementNode;

public class AxisNode
extends MetadataEntityTreeNode {
    public static String COLUMN = "Column";
    public static String ROW = "Row";
    public static String SLICER = "Slicer";
    private AxisInterface axis;

    public AxisNode() {
    }

    public AxisNode(AxisInterface axis) {
        this.axis = axis;
        this.setName();
    }

    private void setName() {
        try {
            int index = this.axis.getAxisNumber();
            switch (index) {
                case 0: {
                    this.name = COLUMN;
                    break;
                }
                case 1: {
                    this.name = ROW;
                    break;
                }
                case -1: {
                    this.name = SLICER;
                    break;
                }
                default: {
                    this.name = "Unknown";
                    break;
                }
            }
        }
        catch (OLAPException oe) {
            this.name = "Unknown";
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int getChildCount() {
        try {
            if (this.childCount == -1 && this.axis != null && this.axis.getTupleCount() > 0) {
                TupleInterface[] tuples = this.axis.getTuples(0, -1);
                TupleElementInterface[] elements = OLAPUtil.getTupleElementsForLevel(0, tuples, false, -1);
                this.childCount = elements.length;
            }
        }
        catch (OLAPException oe) {
            return 0;
        }
        return this.childCount;
    }

    @Override
    protected synchronized boolean populateChildren() {
        try {
            if (this.getChildCount() > 0) {
                TupleInterface[] tuples = this.axis.getTuples(0, -1);
                TupleElementInterface[] elements = OLAPUtil.getTupleElementsForLevel(0, tuples, false, -1);
                for (int j = 0; j < elements.length; ++j) {
                    TupleElementNode elementNode = new TupleElementNode(elements[j]);
                    super.insert(elementNode, j);
                    elementNode.setParent(this);
                }
            }
            this.initialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.initialized;
    }
}

