/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASMDX.ISession;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.SchemaInterface;
import com.sas.storage.olap.sasmdx.RemoteMetadata;

@SASScope(value="ALL")
public class Schema
implements SchemaInterface {
    @SASScope
    protected String label;
    @SASScope
    protected String name;
    @SASScope
    protected MetadataInterface metadata;
    @SASScope
    protected ISession _session;
    @SASScope
    protected Filter filter;

    @SASScope
    public Schema(MetadataInterface metadata, ISession _session, String schemaName) throws OLAPException {
        this.metadata = metadata;
        this._session = _session;
        this.label = schemaName;
        this.name = schemaName;
    }

    @Override
    public String getName() throws OLAPException {
        return this.name;
    }

    @Override
    public String getLabel() throws OLAPException {
        return this.label;
    }

    @Override
    public CubeInterface[] getCubes() throws OLAPException {
        return RemoteMetadata.CubeMetadata(this.metadata, this._session, this.getFilter());
    }

    @Override
    public synchronized Filter getFilter() throws OLAPException {
        if (this.filter == null) {
            this.filter = new Filter();
            this.filter.setSchemaName(this.name);
        }
        return this.filter;
    }

    @Override
    public MetadataInterface getMetadata() throws OLAPException {
        return this.metadata;
    }
}

