/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASMDX.ISession;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import com.sas.storage.olap.sasmdx.RB;

@SASScope(value="ALL")
public class Property
implements PropertyInterface {
    @SASScope
    public static final String RB_KEY = "Property.";
    @SASScope
    protected ISession _session;
    @SASScope
    protected String label;
    @SASScope
    protected String name;
    @SASScope
    protected String cubeName;
    protected String uniqueDimensionName;
    protected String uniqueHierarchyName;
    @SASScope
    protected String uniqueLevelName;
    @SASScope
    protected String uniqueMemberName;
    @SASScope
    protected String description;
    @SASScope
    protected int type;
    @SASScope
    protected MetadataInterface metadata;
    @SASScope
    protected LevelInterface level;
    @SASScope
    protected MemberInterface member;
    @SASScope
    protected Filter filter;
    protected Class dataTypeClass;
    protected int dataType;
    private boolean isShared;

    @SASScope
    public Property(MetadataInterface metadata, ISession _session, String cubeName, String uniqueLevelName, String uniqueMemberName, String name, String label, int type, int dataType, String description) throws OLAPException {
        this.metadata = metadata;
        this._session = _session;
        this.cubeName = cubeName;
        this.uniqueLevelName = uniqueLevelName;
        this.uniqueMemberName = uniqueMemberName;
        this.name = name;
        this.label = label;
        this.type = type;
        this.description = description;
        this.dataType = dataType;
        this.level = null;
        this.member = null;
        this.filter = null;
        if (this.cubeName == null || this.cubeName.length() == 0) {
            this.isShared = true;
        }
    }

    public Property(MetadataInterface metadata, ISession _session, String cubeName, String dimensionName, String hierarchyName, String uniqueLevelName, String uniqueMemberName, String name, String label, int type, int dataType, String description) throws OLAPException {
        this.metadata = metadata;
        this._session = _session;
        this.cubeName = cubeName;
        this.uniqueDimensionName = dimensionName;
        this.uniqueHierarchyName = hierarchyName;
        this.uniqueLevelName = uniqueLevelName;
        this.uniqueMemberName = uniqueMemberName;
        this.name = name;
        this.label = label;
        this.type = type;
        this.description = description;
        this.dataType = dataType;
        this.level = null;
        this.member = null;
        this.filter = null;
        if (this.cubeName == null || this.cubeName.length() == 0) {
            this.isShared = true;
        }
    }

    @SASScope
    public Property(MetadataInterface metadata, ISession _session, String cubeName, LevelInterface level, String uniqueLevelName, MemberInterface member, String uniqueMemberName, String name, String label, int type, int dataType, String description) throws OLAPException {
        this(metadata, _session, cubeName, uniqueLevelName, uniqueMemberName, name, label, type, dataType, description);
        this.level = level;
        this.member = member;
    }

    public String toString() {
        return this.cubeName + " " + this.uniqueLevelName + this.uniqueMemberName + " " + this.name + " " + this.label + " " + this.type + " " + this.description;
    }

    @Override
    public String getName() throws OLAPException {
        return this.name;
    }

    @Override
    public String getLabel() throws OLAPException {
        return this.label;
    }

    @Override
    public int getType() throws OLAPException {
        return this.type;
    }

    @Override
    public Class getDataType() throws OLAPException {
        if (this.dataTypeClass == null && this.dataType != 0) {
            try {
                this.dataTypeClass = this.dataType == 1 ? Class.forName("java.lang.String") : (this.dataType == 2 ? Class.forName("java.lang.Double") : (this.dataType == 3 ? Class.forName("java.lang.Long") : (this.dataType == 4 ? Class.forName("java.lang.Short") : (this.dataType == 5 ? Class.forName("java.lang.Boolean") : null))));
            }
            catch (ClassNotFoundException ce) {
                this.dataTypeClass = null;
            }
        }
        return this.dataTypeClass;
    }

    @Override
    public String getDescription() throws OLAPException {
        return this.description;
    }

    @Override
    public LevelInterface getLevel() throws OLAPException {
        if (this.level == null) {
            if (this.metadata == null) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "noLevel.ex.txt"));
            }
            Filter levelFilter = new Filter();
            levelFilter.setCubeName(this.cubeName);
            levelFilter.setUniqueLevelName(this.uniqueLevelName);
            levelFilter.setIncludeSharedDimensions(this.isShared);
            LevelInterface[] levels = this.metadata.getLevels(levelFilter);
            for (int i = 0; i < levels.length; ++i) {
                System.out.println(levels[i].getUniqueName());
            }
            if (levels.length != 1) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "multipleLevel.ex.txt"));
            }
            this.level = levels[0];
        }
        return this.level;
    }

    @Override
    public MemberInterface getMember() throws OLAPException {
        if (this.member == null) {
            if (this.metadata == null) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "noMember.ex.txt"));
            }
            Filter memberFilter = new Filter();
            memberFilter.setCubeName(this.cubeName);
            memberFilter.setUniqueMemberName(this.uniqueMemberName);
            memberFilter.setIncludeSharedDimensions(this.isShared);
            MemberInterface[] members = this.metadata.getMembers(memberFilter, 0, -1);
            if (members.length != 1) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "multipleMember.ex.txt"));
            }
            this.member = members[0];
        }
        return this.member;
    }

    @Override
    public synchronized Filter getFilter() throws OLAPException {
        if (this.filter == null) {
            this.filter = new Filter();
            this.filter.setCubeName(this.cubeName);
            this.filter.setIncludeSharedDimensions(this.isShared);
            this.filter.setUniqueDimensionName(this.uniqueDimensionName);
            this.filter.setUniqueHierarchyName(this.uniqueHierarchyName);
            this.filter.setUniqueLevelName(this.uniqueLevelName);
            this.filter.setUniqueMemberName(this.uniqueMemberName);
            this.filter.setPropertyName(this.name);
            this.filter.setPropertyType(this.type);
        }
        return this.filter;
    }

    public MetadataInterface getMetadata() throws OLAPException {
        return this.metadata;
    }
}

