/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASMDX.ISession;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.RB;
import java.util.Date;

@SASScope(value="ALL")
public class Hierarchy
implements HierarchyInterface {
    @SASScope
    public static final String RB_KEY = "Hierarchy.";
    @SASScope
    protected ISession _session;
    @SASScope
    protected String catalogName;
    @SASScope
    protected String schemaName;
    @SASScope
    protected String label;
    @SASScope
    protected String name;
    @SASScope
    protected String uniqueName;
    @SASScope
    protected String cubeName;
    @SASScope
    protected String description;
    @SASScope
    protected String uniqueDimensionName;
    @SASScope
    protected int memberCount;
    @SASScope
    protected String defaultMemberName;
    @SASScope
    protected String allMemberName;
    @SASScope
    protected MetadataInterface metadata;
    @SASScope
    protected Filter filter;
    @SASScope
    protected int structure;
    private DimensionInterface dimension;
    private boolean isShared;

    public Hierarchy(MetadataInterface metadata, ISession _session, String catalogName, String schemaName, String cubeName, String uniqueDimensionName, String name, String uniqueName, String label, int memberCount, String defaultMemberName, String allMemberName, String description, int structure) throws OLAPException {
        this.metadata = metadata;
        this._session = _session;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.cubeName = cubeName;
        this.uniqueDimensionName = uniqueDimensionName;
        this.name = name;
        this.uniqueName = uniqueName;
        this.label = label;
        this.description = description;
        this.memberCount = memberCount;
        this.defaultMemberName = defaultMemberName;
        this.allMemberName = allMemberName;
        this.structure = structure;
        this.filter = null;
        if (this.cubeName == null || this.cubeName.length() == 0) {
            this.isShared = true;
        }
    }

    @Override
    public String getName() throws OLAPException {
        return this.name;
    }

    @Override
    public String getLabel() throws OLAPException {
        return this.label;
    }

    @Override
    public String getUniqueName() throws OLAPException {
        return this.uniqueName;
    }

    @Override
    public String getDescription() throws OLAPException {
        return this.description;
    }

    @Override
    public int getStructure() {
        return this.structure;
    }

    @Override
    public synchronized DimensionInterface getDimension() throws OLAPException {
        if (this.dimension == null) {
            if (this.metadata == null) {
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "noDimension.ex.txt"));
            }
            Filter inFilter = new Filter();
            inFilter.setCubeName(this.cubeName);
            inFilter.setIncludeSharedDimensions(this.isShared);
            inFilter.setUniqueHierarchyName(this.uniqueName);
            inFilter.setUniqueDimensionName(this.uniqueDimensionName);
            this.dimension = this.metadata.getDimension(inFilter);
        }
        return this.dimension;
    }

    @Override
    public int getMemberCount() throws OLAPException {
        return this.memberCount;
    }

    @Override
    public MemberInterface getDefaultMember() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "noDimension.ex.txt"));
        }
        Filter inFilter = new Filter();
        inFilter.setCubeName(this.cubeName);
        inFilter.setIncludeSharedDimensions(this.isShared);
        inFilter.setUniqueDimensionName(this.uniqueDimensionName);
        inFilter.setUniqueHierarchyName(this.uniqueName);
        inFilter.setUniqueMemberName(this.defaultMemberName);
        inFilter.setMemberType(0);
        MemberInterface[] members = this.metadata.getMembers(inFilter, 0, -1);
        if (members.length != 1) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "multipleMember.ex.txt"));
        }
        return members[0];
    }

    @Override
    public MemberInterface getTopMember() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "topMember.ex.txt"));
        }
        Filter inFilter = new Filter();
        inFilter.setCubeName(this.cubeName);
        inFilter.setIncludeSharedDimensions(this.isShared);
        inFilter.setUniqueDimensionName(this.uniqueDimensionName);
        inFilter.setUniqueHierarchyName(this.uniqueName);
        inFilter.setUniqueMemberName(this.allMemberName);
        inFilter.setMemberType(0);
        MemberInterface[] members = this.metadata.getMembers(inFilter, 0, -1);
        if (members.length != 1) {
            return null;
        }
        return members[0];
    }

    @Override
    public MemberInterface[] getTopMembers() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "topMember.ex.txt"));
        }
        LevelInterface[] levels = this.getLevels();
        for (int k = 0; k < levels.length; ++k) {
            if (levels[k].getDepth() != 0 || this.getDimension().getType() == 2) continue;
            return levels[k].getMembers();
        }
        return new MemberInterface[0];
    }

    @Override
    public LevelInterface[] getLevels() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "noLevel.ex.txt"));
        }
        Filter inFilter = new Filter();
        inFilter.setCubeName(this.cubeName);
        inFilter.setIncludeSharedDimensions(this.isShared);
        inFilter.setUniqueDimensionName(this.uniqueDimensionName);
        inFilter.setUniqueHierarchyName(this.uniqueName);
        return this.metadata.getLevels(inFilter);
    }

    @Override
    public synchronized Filter getFilter() throws OLAPException {
        if (this.filter == null) {
            this.filter = new Filter();
            this.filter.setCatalogName(this.catalogName);
            this.filter.setSchemaName(this.schemaName);
            this.filter.setCubeName(this.cubeName);
            this.filter.setIncludeSharedDimensions(this.isShared);
            this.filter.setUniqueDimensionName(this.uniqueDimensionName);
            this.filter.setHierarchyName(this.name);
            this.filter.setUniqueHierarchyName(this.uniqueName);
        }
        return this.filter;
    }

    @Override
    public MetadataInterface getMetadata() throws OLAPException {
        return this.metadata;
    }

    @Override
    public CubeInterface getCube() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource("noCube.ex.txt"));
        }
        if (this.cubeName != null && this.cubeName.length() > 0) {
            Filter inFilter = new Filter();
            inFilter.setCatalogName(this.catalogName);
            inFilter.setSchemaName(this.schemaName);
            inFilter.setCubeName(this.cubeName);
            return this.metadata.getCube(inFilter);
        }
        return null;
    }

    @Override
    public MemberInterface[] getMembers() throws OLAPException {
        if (this.metadata == null) {
            throw new IllegalStateException(RB.getStringResource("nullMetadata.ex.txt"));
        }
        Filter inFilter = new Filter();
        inFilter.setCatalogName(this.catalogName);
        inFilter.setSchemaName(this.schemaName);
        inFilter.setCubeName(this.cubeName);
        inFilter.setIncludeSharedDimensions(this.isShared);
        inFilter.setUniqueDimensionName(this.uniqueDimensionName);
        inFilter.setUniqueHierarchyName(this.uniqueName);
        MemberInterface[] members = this.metadata.getMembers(inFilter, 0, -1);
        return members;
    }

    @Override
    public Date getCreationDateTime() throws OLAPException {
        throw new OLAPException(RB.getStringResource("methodNotSupported.ex.txt"));
    }

    @Override
    public Date getUpdateDateTime() throws OLAPException {
        throw new OLAPException(RB.getStringResource("methodNotSupported.ex.txt"));
    }
}

