/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.collection.LongKeyDictionary;
import com.sas.iom.SASIOMDefs.DoubleSeqHolder;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASMDX.CellValueFormat;
import com.sas.iom.SASMDX.DataType;
import com.sas.iom.SASMDX.DataTypeSeqHolder;
import com.sas.iom.SASMDX.IMDDataSet;
import com.sas.models.BufferHints;
import com.sas.models.CacheException;
import com.sas.models.SequentialCache;
import com.sas.models.SparseCache;
import com.sas.models.StaticCacheInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.CacheProperties;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.PerformanceTuning;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.sasmdx.AxisCache;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import com.sas.storage.olap.sasmdx.RB;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

@SASScope
public class DataCache {
    public static final String RB_KEY = "DataCache.";
    private SparseCache unformattedCellCache;
    private SparseCache formattedCellCache;
    private AxisCache[] axisCache;
    protected HashMap ancestorInfo;
    private OLAPDataSetInterface olapDataSet;
    private IMDDataSet _mdDataSet;
    private int nAxes;
    private int contextType;
    private int cellCount;
    private PerformanceTuning performanceTuning;

    public DataCache(OLAPDataSetInterface olapDataSet, IMDDataSet _mdDataSet, PerformanceTuning performanceTuning) throws OLAPException {
        this.olapDataSet = olapDataSet;
        this._mdDataSet = _mdDataSet;
        this.setPerformanceTuning(performanceTuning);
        this.initialize();
    }

    public void setPerformanceTuning(PerformanceTuning performanceTuning) throws OLAPException {
        if (performanceTuning == null) {
            this.performanceTuning = new PerformanceTuning();
        } else {
            this.performanceTuning = performanceTuning;
            AxisCache[] ac = this.getAxisCache(0, -1);
            CacheProperties[] axisCacheProp = performanceTuning.getCache(PerformanceTuning.ALL_AXIS_TYPES);
            for (int i = 1; i < ac.length; ++i) {
                CacheProperties cp = axisCacheProp[i];
                if (!cp.hasChanged()) continue;
                this.configureAxisCache(cp, ac, i);
            }
            this.configureCellCache();
        }
    }

    private void configureAxisCache(CacheProperties cp, AxisCache[] ac, int axisNumber) throws OLAPException {
        try {
            BitSet changebits = cp.getChangeBits();
            int bufferSize = -1;
            int lookAhead = -1;
            if (changebits.get(0) && (bufferSize = cp.getBufferSize()) == PerformanceTuning.MAX_VALUE) {
                bufferSize = ac[axisNumber].getAxis().getTupleCount();
            }
            if ((changebits.get(1) || changebits.get(2)) && (lookAhead = cp.getLookAhead()) == PerformanceTuning.MAX_VALUE) {
                lookAhead = ac[axisNumber].getAxis().getTupleCount();
            }
            SequentialCache tupleCache = ac[axisNumber].getTupleCache();
            tupleCache.configureCache(bufferSize, lookAhead, -1, -1, -1);
        }
        catch (CacheException ce) {
            throw new OLAPException(ce);
        }
    }

    private void configureCellCache() throws OLAPException {
        try {
            CacheProperties[] cellCacheProp = this.performanceTuning.getCache(PerformanceTuning.ALL_CELL_TYPES);
            for (int i = 0; i < cellCacheProp.length; ++i) {
                CacheProperties cp = cellCacheProp[i];
                if (!cp.hasChanged()) continue;
                BitSet changebits = cp.getChangeBits();
                int bufferSize = -1;
                int lookAhead = -1;
                if (changebits.get(0) && (bufferSize = cp.getBufferSize()) == PerformanceTuning.MAX_VALUE) {
                    bufferSize = this.getCellCount();
                }
                if ((changebits.get(1) || changebits.get(2)) && (lookAhead = cp.getLookAhead()) == PerformanceTuning.MAX_VALUE) {
                    lookAhead = this.getCellCount();
                }
                SparseCache cellCache = null;
                cellCache = i == 1 ? this.getFormattedCellCache() : this.getUnformattedCellCache();
                cellCache.configureCache(bufferSize, lookAhead, -1, -1, -1);
            }
        }
        catch (CacheException ce) {
            throw new OLAPException(ce);
        }
    }

    public PerformanceTuning getPerformanceTuning() {
        if (this.performanceTuning == null) {
            this.performanceTuning = new PerformanceTuning();
        }
        return this.performanceTuning;
    }

    public String getQueryStatement() throws OLAPException {
        return this.olapDataSet.getQueryStatement();
    }

    public void setCubeNameHint(String cubeName) {
        if (this.olapDataSet instanceof OLAPDataSetInterface) {
            ((OLAPDataSet)this.olapDataSet).setCubeNameHint(cubeName);
        }
    }

    public String getCubeNameHint() {
        return this.olapDataSet instanceof OLAPDataSet ? ((OLAPDataSet)this.olapDataSet).getCubeNameHint() : null;
    }

    public SparseCache getUnformattedCellCache() throws OLAPException {
        if (this.unformattedCellCache == null) {
            this.unformattedCellCache = new SparseCache((StaticCacheInterface)new CellReader(false));
        }
        return this.unformattedCellCache;
    }

    public SparseCache getFormattedCellCache() throws OLAPException {
        if (this.formattedCellCache == null) {
            this.formattedCellCache = new SparseCache((StaticCacheInterface)new CellReader(true));
        }
        return this.formattedCellCache;
    }

    public AxisCache[] getAxisCache(int index, int count) throws OLAPException {
        if (this.axisCache == null) {
            this.populateAxesCache();
        }
        if (this.axisCache == null || count != -1 && index >= this.axisCache.length - 1 || count == -1 && index >= this.axisCache.length) {
            return null;
        }
        if (index == -1) {
            index = this.axisCache.length - 1;
        }
        int endIndex = count == -1 ? this.axisCache.length : index + count;
        AxisCache[] requestedCaches = new AxisCache[endIndex - index];
        for (int i = index; i < endIndex; ++i) {
            requestedCaches[i - index] = this.axisCache[i];
        }
        return requestedCaches;
    }

    public AxisCache getAxisCache(int axisNumber) throws OLAPException {
        return this.getAxisCache(axisNumber, 1)[0];
    }

    public Map getAncestorInfo(String uniqueMemberName, int ancestorLevel) throws OLAPException {
        HashMap properties = null;
        if (this.ancestorInfo != null && this.ancestorInfo.containsKey(uniqueMemberName)) {
            LongKeyDictionary ancestorTable = (LongKeyDictionary)this.ancestorInfo.get(uniqueMemberName);
            properties = (HashMap)ancestorTable.get((long)ancestorLevel);
        }
        return properties;
    }

    public void setAncestorInfo(String uniqueMemberName, int ancestorLevel, Map properties) throws OLAPException {
        LongKeyDictionary ancestorTable;
        if (this.ancestorInfo != null && this.ancestorInfo.containsKey(uniqueMemberName)) {
            ancestorTable = (LongKeyDictionary)this.ancestorInfo.get(uniqueMemberName);
        } else {
            if (this.ancestorInfo == null) {
                this.ancestorInfo = new HashMap(10);
            }
            ancestorTable = new LongKeyDictionary();
        }
        ancestorTable.set((long)ancestorLevel, (Object)properties);
        this.ancestorInfo.put(uniqueMemberName, ancestorTable);
    }

    public void flush(OLAPDataSetInterface olapDataSet, IMDDataSet _mdDataSet) throws OLAPException {
        this.olapDataSet = olapDataSet;
        this._mdDataSet = _mdDataSet;
        this.flush();
    }

    public void flush() throws OLAPException {
        this.initialize();
    }

    protected void initialize() throws OLAPException {
        this.contextType = this.olapDataSet.getContextType();
        this.axisCache = null;
        this.nAxes = 0;
        this.cellCount = -1;
        if (this.ancestorInfo != null) {
            Collection c = this.ancestorInfo.values();
            for (LongKeyDictionary l : c) {
                Object var3_3 = null;
            }
        }
        this.ancestorInfo = null;
        this.formattedCellCache = null;
        this.unformattedCellCache = null;
    }

    protected int calculateBufferSize() throws OLAPException {
        return this.getCellCount();
    }

    public int getCellCount() throws OLAPException {
        if (this.cellCount == -1) {
            this.cellCount = 1;
            if (this.axisCache == null) {
                this.populateAxesCache();
            }
            for (int i = 0; i < this.axisCache.length - 1; ++i) {
                int count = this.axisCache[i].getAxis().getTupleCount();
                this.cellCount *= count;
            }
            ((OLAPDataSet)this.olapDataSet).setCellCount(this.cellCount);
        }
        return this.cellCount;
    }

    protected void populateAxesCache() throws OLAPException {
        try {
            LongSeqHolder axisNumDims = new LongSeqHolder();
            StringSeqHolder axisDimNames = new StringSeqHolder();
            LongSeqHolder axisNumHiers = new LongSeqHolder();
            StringSeqHolder axisHierNames = new StringSeqHolder();
            LongSeqHolder axisNumTuples = new LongSeqHolder();
            LongSeqHolder axisDimNumProps = new LongSeqHolder();
            StringSeqHolder axisDimPropNames = new StringSeqHolder();
            DataTypeSeqHolder axisDimPropTypes = new DataTypeSeqHolder();
            LongSeqHolder axisMaxDimPropSize = new LongSeqHolder();
            if (this._mdDataSet != null) {
                this._mdDataSet.GetAxisInfo(axisNumDims, axisDimNames, axisNumHiers, axisHierNames, axisNumTuples, axisDimNumProps, axisDimPropNames, axisDimPropTypes, axisMaxDimPropSize);
            }
            int namesOffset = 0;
            int propertyOffset = 0;
            int tupleOffset = 0;
            this.nAxes = axisNumDims.value.length;
            this.axisCache = new AxisCache[this.nAxes];
            for (int i = 0; i < this.nAxes; ++i) {
                int tupleDepth = axisNumDims.value[i];
                String[] dimensionNames = new String[tupleDepth];
                String[] hierarchyNames = new String[tupleDepth];
                int[] propertyCount = new int[tupleDepth];
                String[][] propertyNames = new String[tupleDepth][];
                for (int j = namesOffset; j < namesOffset + tupleDepth; ++j) {
                    int index = j - namesOffset;
                    dimensionNames[index] = axisDimNames.value[j];
                    hierarchyNames[index] = axisHierNames.value[j];
                    propertyCount[index] = axisDimNumProps.value[j] - 5;
                    int propertyCnt = propertyCount[index];
                    propertyNames[index] = new String[propertyCnt];
                    for (int k = propertyOffset; k < propertyOffset + propertyCnt; ++k) {
                        propertyNames[index][k - propertyOffset] = axisDimPropNames.value[k + 5];
                    }
                    propertyOffset += propertyCnt + 5;
                }
                namesOffset += tupleDepth;
                tupleOffset += axisNumTuples.value[i];
                int axisIndex = i == this.nAxes - 1 ? -1 : i;
                int tupleCount = axisNumTuples.value[i];
                if (tupleDepth == 0) {
                    tupleCount = tupleDepth;
                }
                this.axisCache[i] = new AxisCache(this, axisIndex, tupleCount, tupleDepth, hierarchyNames, dimensionNames, propertyNames);
            }
        }
        catch (Exception ex) {
            throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
        }
    }

    @SASScope
    OLAPDataSetInterface getOLAPDataSet() {
        return this.olapDataSet;
    }

    @SASScope
    IMDDataSet getIMDDataSet() {
        return this._mdDataSet;
    }

    @SASScope
    int getAxesCount() {
        return this.nAxes;
    }

    public int calculateOrdinals(int axisNumber, int[] startingCoordinates, int[] endingCoordinates, int[] currentCoordinates, long[] returnKeys, int index) throws OLAPException {
        for (int i = startingCoordinates[axisNumber]; i <= endingCoordinates[axisNumber]; ++i) {
            currentCoordinates[axisNumber] = i;
            if (axisNumber == 0) {
                if (index >= returnKeys.length) continue;
                returnKeys[index++] = OLAPUtil.calculateCellOrdinal(this.olapDataSet.getResultSetMetadata(), currentCoordinates);
                continue;
            }
            index = this.calculateOrdinals(--axisNumber, startingCoordinates, endingCoordinates, currentCoordinates, returnKeys, index);
            ++axisNumber;
        }
        return index;
    }

    @SASScope
    private class CellReader
    implements StaticCacheInterface {
        private boolean readFormatted;

        public CellReader(boolean readFormatted) {
            this.readFormatted = readFormatted;
        }

        public Object getFromCache(long key) throws CacheException {
            return this.getFromCache(key, key, true)[0];
        }

        public Object[] getFromCache(long[] keys, boolean readFully) throws CacheException {
            return keys != null && keys.length > 0 ? this.getFromCache(keys[0], keys[keys.length - 1], readFully) : new Object[]{};
        }

        public Object[] getFromCache(long startOrdinal, long endOrdinal, boolean readFully) throws CacheException {
            LongSeqHolder ordinals = new LongSeqHolder();
            DataTypeSeqHolder dataTypes = new DataTypeSeqHolder();
            StringSeqHolder stringValues = new StringSeqHolder();
            LongSeqHolder longValues = new LongSeqHolder();
            DoubleSeqHolder values = new DoubleSeqHolder();
            OctetSeqHolder missing = new OctetSeqHolder();
            StringSeqHolder formattedValues = new StringSeqHolder();
            int nRead = 0;
            int startCell = (int)startOrdinal;
            int endCell = (int)endOrdinal;
            try {
                nRead = DataCache.this._mdDataSet.ReadCells(startCell, endCell, this.readFormatted ? CellValueFormat.CellValueFormatFormatted : CellValueFormat.CellValueFormatRaw, ordinals, dataTypes, stringValues, longValues, values, missing, formattedValues);
            }
            catch (Exception ex) {
                throw new CacheException(OLAPUtil.getExceptionMessage(ex));
            }
            if (this.readFormatted) {
                String[] tempValues = formattedValues.value;
                byte[] missingInfo = missing.value;
                int[] tempOrdinals = ordinals.value;
                TreeMap<Integer, String> formattedCellValues = new TreeMap<Integer, String>();
                String missingString = ".";
                for (int i = 0; i < nRead; ++i) {
                    Integer index = tempOrdinals[i];
                    if (missingInfo[i] == 32) {
                        formattedCellValues.put(index, missingString);
                        continue;
                    }
                    formattedCellValues.put(index, tempValues[i]);
                }
                return formattedCellValues.values().toArray(OLAPUtil.EMPTY_STRING_ARRAY);
            }
            double[] rawData = values.value;
            byte[] missingInfo = missing.value;
            String missingString = ".";
            int[] tempOrdinals = ordinals.value;
            TreeMap<Integer, Object> unformattedValues = new TreeMap<Integer, Object>();
            int si = 0;
            int di = 0;
            int li = 0;
            for (int i = 0; i < nRead; ++i) {
                Integer index = tempOrdinals[i];
                if (missingInfo[i] == 32) {
                    unformattedValues.put(index, missingString);
                    ++di;
                    continue;
                }
                if (dataTypes.value[i] == DataType.DataTypeDouble) {
                    unformattedValues.put(index, rawData[di++]);
                    continue;
                }
                if (dataTypes.value[i] == DataType.DataTypeString) {
                    unformattedValues.put(index, new String(stringValues.value[si++]));
                    continue;
                }
                if (dataTypes.value[i] != DataType.DataTypeLong) continue;
                unformattedValues.put(index, Long.valueOf(longValues.value[li++]));
            }
            return unformattedValues.values().toArray();
        }

        public long[] computeCacheKeyRange(long startOrdinal, long endOrdinal, int lookAhead) throws CacheException {
            long[] returnKeys = null;
            try {
                int[] endCoords;
                long cellCnt = DataCache.this.getCellCount();
                if (endOrdinal == -1L) {
                    endOrdinal = cellCnt - 1L;
                }
                if (startOrdinal < 0L || endOrdinal > cellCnt - 1L) {
                    throw new IllegalArgumentException(RB.getStringResource(DataCache.RB_KEY, "invalidOrdinal.ex.txt"));
                }
                ResultSetMetadataInterface rsm = DataCache.this.olapDataSet.getResultSetMetadata();
                AxisInterface[] axis = rsm.getAxes(0, -1);
                int numAxes = axis.length - 1;
                int[] startCoords = OLAPUtil.calculateTupleCoordinates(rsm, (int)startOrdinal);
                int[] newEndCoords = endCoords = OLAPUtil.calculateTupleCoordinates(rsm, (int)endOrdinal);
                int[] newStartCoords = startCoords;
                long endOrd = endOrdinal;
                long startOrd = startOrdinal;
                SparseCache cache = DataCache.this.formattedCellCache;
                if (!this.readFormatted) {
                    cache = DataCache.this.unformattedCellCache;
                }
                boolean configureCache = false;
                if (!this.getRequestedCells(startOrdinal, endOrdinal, lookAhead, cellCnt)) {
                    CacheProperties[] axesProp = DataCache.this.performanceTuning.getCache(PerformanceTuning.ALL_AXIS_TYPES);
                    CacheProperties[] cellProp = DataCache.this.performanceTuning.getCache(PerformanceTuning.CELL_TYPE);
                    for (int i = 0; i < numAxes; ++i) {
                        int tupleCount = axis[i].getTupleCount();
                        if (axesProp[i + 1].getLookAhead() == PerformanceTuning.MAX_VALUE) {
                            newStartCoords[i] = 0;
                            newEndCoords[i] = tupleCount - 1;
                            continue;
                        }
                        if (startOrdinal == endOrdinal && i == 0) {
                            newEndCoords[i] = tupleCount - 1;
                        } else {
                            int cellLookAhead = axesProp[i + 1].getPageSize() * cellProp[0].getPageCount();
                            int tempEndCoord = Math.min(tupleCount - startCoords[i], cellLookAhead);
                            newEndCoords[i] = Math.max(endCoords[i], startCoords[i] + tempEndCoord - 1);
                        }
                        configureCache = true;
                    }
                    startOrd = OLAPUtil.calculateCellOrdinal(rsm, newStartCoords);
                    endOrd = OLAPUtil.calculateCellOrdinal(rsm, newEndCoords);
                }
                int nCellsRequested = startCoords.length == 1 ? (int)(endOrd - startOrd + 1L) : 1;
                for (int i = 1; i < startCoords.length; ++i) {
                    nCellsRequested *= (newEndCoords[i] - newStartCoords[i] + 1) * (newEndCoords[i - 1] - newStartCoords[i - 1] + 1);
                }
                if (nCellsRequested < 0) {
                    throw new IllegalArgumentException(RB.getStringResource(DataCache.RB_KEY, "invalidOrdinal.ex.txt"));
                }
                if (configureCache) {
                    this.configureCellCache(nCellsRequested);
                }
                returnKeys = new long[nCellsRequested];
                int[] currentCoordinates = new int[newStartCoords.length];
                DataCache.this.calculateOrdinals(startCoords.length - 1, newStartCoords, newEndCoords, currentCoordinates, returnKeys, 0);
                return returnKeys;
            }
            catch (OLAPException ex) {
                throw new CacheException(ex.getMessage() == null ? ex.toString() : ex.getMessage());
            }
        }

        private void configureCellCache(int nCellsRequested) throws CacheException {
            int cacheCapacity;
            SparseCache cache = DataCache.this.formattedCellCache;
            CacheProperties cp = DataCache.this.performanceTuning.getCache(PerformanceTuning.FORMATTED_CELL_TYPE)[0];
            if (!this.readFormatted) {
                cache = DataCache.this.unformattedCellCache;
                cp = DataCache.this.performanceTuning.getCache(PerformanceTuning.CELL_TYPE)[0];
            }
            if ((cacheCapacity = cache.getCacheCapacity()) < nCellsRequested) {
                if (cp.hasChanged() && cp.getChangeBits().get(0)) {
                    int bufferSize = cp.getBufferSize();
                    if (bufferSize == PerformanceTuning.MAX_VALUE && cacheCapacity < DataCache.this.cellCount) {
                        bufferSize = DataCache.this.cellCount;
                    }
                    cache.configureCache(bufferSize, -1, -1, -1, -1);
                } else {
                    cache.configureCache(nCellsRequested, -1, -1, -1, -1);
                }
            }
        }

        private boolean getRequestedCells(long startOrdinal, long endOrdinal, int lookAhead, long cellCnt) throws CacheException {
            return lookAhead == 0 || startOrdinal == 0L && endOrdinal == cellCnt - 1L || this.readFormatted && DataCache.this.formattedCellCache.cacheContainsKey((long)((int)startOrdinal)) && DataCache.this.formattedCellCache.cacheContainsKey((long)((int)endOrdinal)) || !this.readFormatted && DataCache.this.unformattedCellCache.cacheContainsKey((long)((int)startOrdinal)) && DataCache.this.unformattedCellCache.cacheContainsKey((long)((int)endOrdinal));
        }

        private int getType(int axisNumber) throws OLAPException {
            int type;
            switch (axisNumber) {
                case 0: {
                    type = PerformanceTuning.COLUMNS_AXIS_TYPE;
                    break;
                }
                case 1: {
                    type = PerformanceTuning.ROWS_AXIS_TYPE;
                    break;
                }
                case 2: {
                    type = PerformanceTuning.PAGES_AXIS_TYPE;
                    break;
                }
                case 3: {
                    type = PerformanceTuning.SECTIONS_AXIS_TYPE;
                    break;
                }
                case 4: {
                    type = PerformanceTuning.CHAPTERS_AXIS_TYPE;
                    break;
                }
                case -1: {
                    type = PerformanceTuning.SLICERS_AXIS_TYPE;
                    break;
                }
                default: {
                    type = -1;
                }
            }
            return type;
        }

        public long[] getCacheKeys() throws CacheException {
            return null;
        }

        public boolean cacheContainsKey(long key) throws CacheException {
            return false;
        }

        public int getCacheKeyUse() {
            return 1;
        }

        public void configureCache(int maxCacheSize, int bufferLookAhead, int thresholdType, int threshholdVale, int accessType) throws CacheException {
        }

        public void useBufferHints(BufferHints hints) {
        }

        public int count() {
            return 0;
        }

        public StaticCacheInterface getSecondaryCache() {
            return null;
        }
    }
}

