/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.sasmdx.AxisCache;

@SASScope(value="ALL")
public class Axis
implements AxisInterface {
    @SASScope
    protected ResultSetMetadataInterface resultSetMetadata;
    @SASScope
    protected int tupleCount;
    @SASScope
    protected int tupleDepth;
    @SASScope
    protected int axisNumber;
    @SASScope
    protected String[][] propertyNames;
    @SASScope
    protected TupleInterface[] tuples;
    @SASScope
    protected String[] axisHeaders;
    private String[] baseDimensionNames;
    private String[] baseUniqueHierarchyNames;
    @SASScope
    protected AxisCache cache;

    @SASScope
    public Axis(AxisCache cache, int axisNumber, ResultSetMetadataInterface resultSetMetadata) throws OLAPException {
        this(cache, axisNumber, 0, 0, null, resultSetMetadata);
    }

    @SASScope
    public Axis(AxisCache cache, int axisNumber, int tupleCount, int tupleDepth, String[] dimensionNames, ResultSetMetadataInterface resultSetMetadata) throws OLAPException {
        this.cache = cache;
        this.resultSetMetadata = resultSetMetadata;
        this.axisNumber = axisNumber;
        this.tupleCount = tupleCount;
        this.tupleDepth = tupleDepth;
        this.baseDimensionNames = dimensionNames;
    }

    @SASScope
    public Axis(AxisCache cache, int axisNumber, int tupleCount, int tupleDepth, String[] hierarchyNames, String[] dimensionNames, ResultSetMetadataInterface resultSetMetadata) throws OLAPException {
        this.cache = cache;
        this.resultSetMetadata = resultSetMetadata;
        this.axisNumber = axisNumber;
        this.tupleCount = tupleCount;
        this.tupleDepth = tupleDepth;
        this.baseDimensionNames = dimensionNames;
        this.baseUniqueHierarchyNames = hierarchyNames;
    }

    @Override
    public ResultSetMetadataInterface getResultSetMetadata() {
        return this.resultSetMetadata;
    }

    @Override
    public int getAxisNumber() throws OLAPException {
        return this.axisNumber;
    }

    @Override
    public int getTupleCount() throws OLAPException {
        return this.tupleCount;
    }

    @Override
    public String[] getHierarchyNames() throws OLAPException {
        return this.cache.getHierarchyNames();
    }

    @Override
    public String[] getDimensionNames() throws OLAPException {
        return this.cache.getDimensionNames();
    }

    @Override
    public TupleInterface[] getTuples(int index, int count) throws OLAPException {
        return this.cache.getTuples(index, count);
    }

    @Override
    public TupleInterface getTuple(int index) throws OLAPException {
        return this.cache.getTuples(index, 1)[0];
    }

    @Override
    public int getMaximumTupleDepth() throws OLAPException {
        return this.cache.getMaximumTupleDepth();
    }

    @Override
    public String[] getAxisHeaders() throws OLAPException {
        return this.cache.getAxisHeaders();
    }

    @Override
    public String[] getUniqueLevelNames() throws OLAPException {
        return this.cache.getUniqueLevelNames();
    }

    String[] getBaseDimensionNames() throws OLAPException {
        return this.baseDimensionNames;
    }

    String[] getBaseUniqueHierarchyNames() throws OLAPException {
        return this.baseUniqueHierarchyNames;
    }

    public int getTupleDepth() throws OLAPException {
        return this.tupleDepth;
    }

    void setAxisCache(AxisCache cache) {
        this.cache = cache;
    }
}

