/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.olap.embedded;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.Axis;
import com.sas.storage.olap.embedded.RB;
import com.sas.storage.olap.embedded.ResultSet;
import com.sas.util.Util;
import java.util.ArrayList;
import java.util.List;

@SASScope(value="ALL")
public class ResultSetMetadata
implements ResultSetMetadataInterface {
    @SASScope
    public static final String RB_KEY = "ResultSetMetadata.";
    private ArrayList axes = new ArrayList(3);
    private int axesCount;
    private ResultSetInterface resultSet;
    private AxisInterface slicerAxis;

    public ResultSetMetadata() throws OLAPException {
        this(null);
    }

    public ResultSetMetadata(AxisInterface[] axes) throws OLAPException {
        if (axes != null) {
            for (int i = 0; i < axes.length; ++i) {
                this.addAxis(axes[i]);
            }
        }
    }

    public void setSlicerAxis(AxisInterface slicerAxis) throws OLAPException {
        if (slicerAxis.getAxisNumber() == -1) {
            this.slicerAxis = slicerAxis;
        } else {
            ((Axis)this.slicerAxis).setAxisNumber(-1);
        }
        if (slicerAxis instanceof Axis) {
            ((Axis)this.slicerAxis).setResultSetMetadata(this);
        }
    }

    AxisInterface getSlicerAxis() throws OLAPException {
        return this.slicerAxis;
    }

    public void setResultSet(ResultSetInterface resultSet) throws OLAPException {
        if (Util.unequal((Object)this.resultSet, (Object)resultSet)) {
            this.resultSet = resultSet;
            if (resultSet instanceof ResultSet) {
                ((ResultSet)this.resultSet).setResultSetMetadata(this);
            }
        }
    }

    public void addAxis(AxisInterface axis) throws OLAPException {
        if (axis == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidAxis.ex.txt"));
        }
        int axisNum = axis.getAxisNumber();
        if (axisNum == -1) {
            this.setSlicerAxis(axis);
        } else {
            if (axisNum < 0 || axisNum > this.axesCount) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "skipAxis.ex.txt"));
            }
            if (axisNum < this.axesCount) {
                this.axes.set(axisNum, axis);
            } else if (axisNum == this.axesCount) {
                this.axes.add(axis);
                ++this.axesCount;
            }
            if (axis instanceof Axis) {
                ((Axis)axis).setResultSetMetadata(this);
            }
        }
    }

    public void setAxes(AxisInterface[] axes) throws OLAPException {
        for (int i = 0; i < axes.length; ++i) {
            this.addAxis(axes[i]);
        }
    }

    public AxisInterface removeAxis(int axisNumber) throws OLAPException {
        if (axisNumber < -1 || axisNumber >= this.axesCount) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        if (axisNumber == -1) {
            this.slicerAxis = null;
            return null;
        }
        AxisInterface axis = (AxisInterface)this.axes.get(axisNumber);
        int cnt = this.axes.size();
        for (int i = axisNumber + 1; i < cnt; ++i) {
            ((Axis)this.axes.get(i)).setAxisNumber(i - 1);
        }
        return (AxisInterface)this.axes.remove(axisNumber);
    }

    @Override
    public AxisInterface[] getAxes(int index, int count) throws OLAPException {
        if (index < -1 || index >= this.axesCount && index != 0 || count < -1 || count > this.axesCount + 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        if (index == -1 && (count == -1 || count == 1)) {
            return new AxisInterface[]{this.slicerAxis};
        }
        if (count != 0) {
            int endIndex = count == -1 ? this.axesCount : index + count;
            List<AxisInterface> values = this.axes.subList(index, endIndex);
            if (!(count != -1 && count != this.axesCount + 1 || this.slicerAxis == null || values.contains(this.slicerAxis))) {
                values.add(this.slicerAxis);
            }
            return values.toArray(new AxisInterface[0]);
        }
        return new AxisInterface[0];
    }

    @Override
    public AxisInterface getAxis(int index) throws OLAPException {
        if (index < -1 || index >= this.axesCount && index != 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        if (index == -1) {
            return this.slicerAxis;
        }
        return (AxisInterface)this.axes.get(index);
    }

    @Override
    public final ResultSetInterface getResultSet() throws OLAPException {
        return this.resultSet;
    }

    @Override
    public TupleInterface[] getTuples(int axisIndex, int index, int count) throws OLAPException {
        if (axisIndex < 0 || axisIndex >= this.axesCount) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        return ((AxisInterface)this.axes.get(axisIndex)).getTuples(index, count);
    }

    @Override
    public TupleElementInterface[] getElements(int axisIndex, int tupleCoordinate, int index, int count) throws OLAPException {
        if (axisIndex < 0 || axisIndex >= this.axesCount) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidIndex.ex.txt"));
        }
        return ((AxisInterface)this.axes.get(axisIndex)).getTuples(tupleCoordinate, 1)[0].getElements(index, count);
    }
}

