/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc.export;

import com.sas.storage.jdbc.export.RelationalExportInterface;
import com.sas.util.transforms.ObjectToStringTransform;

public class RelationalDelimitedValuesExporter
implements RelationalExportInterface {
    private String dataDelimiter;
    private String lineDelimiter;

    public RelationalDelimitedValuesExporter() {
        this.setDataDelimiter(",");
        this.setLineDelimiter("\n");
    }

    public RelationalDelimitedValuesExporter(String dataDelimiter) {
        this.setDataDelimiter(dataDelimiter);
        this.setLineDelimiter("\n");
    }

    public String getDataDelimiter() {
        return this.dataDelimiter;
    }

    public void setDataDelimiter(String dataDelimiter) {
        this.dataDelimiter = dataDelimiter;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    protected void writeString(String str, StringBuffer line) {
        line.append('\"');
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) == '\"') {
                line.append("\"\"");
                continue;
            }
            line.append(str.charAt(i));
        }
        line.append('\"');
    }

    protected String objectToString(Object value) {
        return (String)ObjectToStringTransform.defaultInstance.transform(value);
    }

    @Override
    public String getFileHeader() {
        return "";
    }

    @Override
    public String getColumnHeaderLine(Object[] columnHeaders) {
        return this.getLine(null, columnHeaders);
    }

    @Override
    public String getLine(Object rowHeader, Object[] data) {
        StringBuffer line;
        StringBuffer stringBuffer = line = data != null ? new StringBuffer(data.length * 4) : new StringBuffer();
        if (rowHeader != null) {
            this.writeString(rowHeader.toString(), line);
            if (data != null && data.length > 0) {
                line.append(this.getDataDelimiter());
            }
        }
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != null) {
                    this.writeString(data[i].toString(), line);
                }
                if (i >= data.length - 1) continue;
                line.append(this.getDataDelimiter());
            }
        }
        line.append(this.getLineDelimiter());
        return line.toString();
    }

    @Override
    public String getFileTrailer() {
        return "";
    }
}

