/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.storage.jdbc.JDBCColumnValuesAdapter;
import com.sas.storage.jdbc.RB;
import com.sas.util.Util;
import com.sas.util.transforms.MapToTemplateStringTransform;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class JDBCToListModelAdapter
extends JDBCColumnValuesAdapter
implements ListModel {
    public static final String RB_KEY = "JDBCToListModelAdapter.";
    protected EventListenerList listenerList = new EventListenerList();
    protected String templateText;
    protected MapToTemplateStringTransform mapTransform;

    public JDBCToListModelAdapter() {
        this(null, null);
    }

    public JDBCToListModelAdapter(ResultSet result) {
        super(result);
    }

    public JDBCToListModelAdapter(Connection conn, String queryStatement) {
        super(conn, queryStatement);
    }

    @Override
    protected void initializeData() {
        super.initializeData();
        this.templateText = "";
        this.trimUsed = true;
        this.mapTransform = new MapToTemplateStringTransform("");
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    @Override
    public int getSize() {
        try {
            return this.calculateRowCount();
        }
        catch (SQLException se) {
            IllegalStateException ise = new IllegalStateException(RB.getStringResource(RB_KEY, "calculateSize.ex.txt"));
            ise.initCause(se);
            throw ise;
        }
    }

    public Object getElementAt(int index) {
        ++index;
        try {
            if (!this.isRetrieveAllColumnValues() && this.templateText != null && !this.templateText.equals("")) {
                return this.mapTransform.transform((Object)this.getElementsAt(--index));
            }
            return this.retrieveValueAt(index, 1);
        }
        catch (SQLException se) {
            IllegalStateException ise = new IllegalStateException(RB.getStringResource(RB_KEY, "retrieveValue.ex.txt"));
            ise.initCause(se);
            throw ise;
        }
    }

    public Map getElementsAt(int index) throws SQLException {
        ++index;
        int columnCount = this.doCountColumns(0);
        HashMap<String, Object> map = new HashMap<String, Object>(columnCount);
        boolean currentRetrieveAllColumnValues = this.isRetrieveAllColumnValues();
        this.retrieveAllColumnValues = false;
        for (int i = 0; i < columnCount; ++i) {
            String key = this.meta.getColumnName(i + 1).toUpperCase();
            Object value = this.retrieveValueAt(index, i + 1);
            if (value instanceof String && this.isTrimUsed()) {
                value = ((String)value).trim();
            }
            map.put(key, value);
        }
        this.retrieveAllColumnValues = currentRetrieveAllColumnValues;
        return map;
    }

    public String getTemplateText() {
        return this.templateText;
    }

    public void setTemplateText(String templateText) {
        String oldTemplateText;
        if (templateText == null) {
            templateText = "";
        }
        if (Util.unequal((Object)(oldTemplateText = this.templateText), (Object)templateText)) {
            this.templateText = templateText;
            this.mapTransform.setTemplateText(templateText);
            this.initialized = false;
            this.spcs.firePropertyChange("templateText", oldTemplateText, templateText);
            this.fireModelEvent();
        }
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "connection"}, {"Hidden", "true"}}, {{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}, {{"Name", "elementAt"}, {"Hidden", "true"}}, {{"Name", "resultSetRequeryUsed"}, {"Expert", "true"}}, {{"Name", "size"}, {"Expert", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @Override
    public void fireCellEvent(int row, int column) {
        this.fireModelEvent(new ListDataEvent(this, 0, row, row));
    }

    @Override
    public void fireModelEvent(EventObject event) {
        if ((this.conn != null && this.queryStatement != null || this.resultSetUsed && this.result != null) && event instanceof ListDataEvent) {
            EventListener[] listeners = this.listenerList.getListeners(ListDataListener.class);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                ((ListDataListener)listeners[i]).contentsChanged((ListDataEvent)event);
            }
        }
    }

    @Override
    public void fireModelEvent() {
        if (this.conn != null && this.queryStatement != null || this.resultSetUsed && this.result != null) {
            int lastRow;
            if (this.designTime) {
                return;
            }
            try {
                lastRow = this.calculateRowCount() - 1;
            }
            catch (SQLException se) {
                lastRow = 0;
            }
            this.fireModelEvent(new ListDataEvent(this, 0, 0, lastRow));
        }
    }
}

