/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc;

import com.sas.storage.jdbc.JDBCDataTypeDescription;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;

public class JDBCDataTypeInfo {
    protected static Hashtable typeInfo;

    protected static void initTypeInfo() {
        if (typeInfo != null) {
            return;
        }
        typeInfo = new Hashtable(28);
        typeInfo.put(2003, new JDBCDataTypeDescription(null, "java.sql.Array", "ARRAY", "Array", Array.class));
        typeInfo.put(-5, new JDBCDataTypeDescription(0L, "long", "BIGINT", "Long", Long.TYPE));
        typeInfo.put(-2, new JDBCDataTypeDescription(null, "byte[]", "BINARY", "ByteArray", byte[].class));
        typeInfo.put(-7, new JDBCDataTypeDescription(Boolean.FALSE, "boolean", "BIT", "Boolean", Boolean.TYPE));
        typeInfo.put(2004, new JDBCDataTypeDescription(null, "java.sql.Blob", "BLOB", "Blob", Blob.class));
        typeInfo.put(1, new JDBCDataTypeDescription(null, "String", "CHAR", "String", String.class));
        typeInfo.put(2005, new JDBCDataTypeDescription(null, "java.sql.Clob", "CLOB", "Clob", Clob.class));
        typeInfo.put(91, new JDBCDataTypeDescription(null, "java.sql.Date", "DATE", "Date", Date.class));
        typeInfo.put(3, new JDBCDataTypeDescription(null, "java.math.BigDecimal", "DECIMAL", "BigDecimal", BigDecimal.class));
        typeInfo.put(2001, new JDBCDataTypeDescription(null, null, "DISTINCT", "Distinct", null));
        typeInfo.put(8, new JDBCDataTypeDescription(0.0, "double", "DOUBLE", "Double", Double.TYPE));
        typeInfo.put(6, new JDBCDataTypeDescription(0.0, "double", "FLOAT", "Double", Double.TYPE));
        typeInfo.put(4, new JDBCDataTypeDescription(0, "int", "INTEGER", "Int", Integer.TYPE));
        typeInfo.put(2000, new JDBCDataTypeDescription(null, "Object", "OBJECT", "Object", Object.class));
        typeInfo.put(-4, new JDBCDataTypeDescription(null, "byte[]", "LONGVARBINARY", "ByteArray", byte[].class));
        typeInfo.put(-1, new JDBCDataTypeDescription(null, "String", "LONGVARCHAR", "String", String.class));
        typeInfo.put(0, new JDBCDataTypeDescription(null, null, "NULL", "Null", null));
        typeInfo.put(2, new JDBCDataTypeDescription(null, "java.math.BigDecimal", "NUMERIC", "BigDecimal", BigDecimal.class));
        typeInfo.put(1111, new JDBCDataTypeDescription(null, null, "OTHER", null, null));
        typeInfo.put(7, new JDBCDataTypeDescription(Float.valueOf(0.0f), "float", "REAL", "Float", Float.TYPE));
        typeInfo.put(2006, new JDBCDataTypeDescription(null, "java.sql.Ref", "REF", "Ref", Ref.class));
        typeInfo.put(5, new JDBCDataTypeDescription((short)0, "short", "SMALLINT", "Short", Short.TYPE));
        typeInfo.put(2002, new JDBCDataTypeDescription(null, null, "STRUCT", "Struct", Struct.class));
        typeInfo.put(92, new JDBCDataTypeDescription(null, "java.sql.Time", "TIME", "Time", Time.class));
        typeInfo.put(93, new JDBCDataTypeDescription(null, "java.sql.Timestamp", "TIMESTAMP", "Timestamp", Timestamp.class));
        typeInfo.put(-6, new JDBCDataTypeDescription((byte)0, "byte", "TINYINT", "Byte", Byte.TYPE));
        typeInfo.put(-3, new JDBCDataTypeDescription(null, "byte[]", "VARBINARY", "ByteArray", byte[].class));
        typeInfo.put(12, new JDBCDataTypeDescription(null, "String", "VARCHAR", "String", String.class));
    }

    public static Object getDefaultValue(int jdbcDataType) {
        JDBCDataTypeInfo.initTypeInfo();
        if (typeInfo.containsKey(jdbcDataType)) {
            JDBCDataTypeDescription info = (JDBCDataTypeDescription)typeInfo.get(jdbcDataType);
            return info.defaultValue;
        }
        return null;
    }

    public static String getJavaType(int jdbcDataType) {
        JDBCDataTypeInfo.initTypeInfo();
        if (typeInfo.containsKey(jdbcDataType)) {
            JDBCDataTypeDescription info = (JDBCDataTypeDescription)typeInfo.get(jdbcDataType);
            return info.javaTypeName;
        }
        return null;
    }

    public static String getJDBCTypeString(int jdbcDataType) {
        JDBCDataTypeInfo.initTypeInfo();
        if (typeInfo.containsKey(jdbcDataType)) {
            JDBCDataTypeDescription info = (JDBCDataTypeDescription)typeInfo.get(jdbcDataType);
            return info.jdbcTypeName;
        }
        return null;
    }

    public static String getDataBeanAccessMethodPart(int jdbcDataType) {
        JDBCDataTypeInfo.initTypeInfo();
        if (typeInfo.containsKey(jdbcDataType)) {
            JDBCDataTypeDescription info = (JDBCDataTypeDescription)typeInfo.get(jdbcDataType);
            return info.dataBeanAccessMethodPart;
        }
        return null;
    }

    public static Class getJavaClass(int jdbcDataType) {
        JDBCDataTypeInfo.initTypeInfo();
        if (typeInfo.containsKey(jdbcDataType)) {
            JDBCDataTypeDescription info = (JDBCDataTypeDescription)typeInfo.get(jdbcDataType);
            return info.javaClass;
        }
        return null;
    }
}

