/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.jdbc;

import com.sas.ComponentException;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.storage.flattened.sasmdx.RB;
import com.sas.util.Command;
import java.beans.PropertyChangeListener;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.swing.event.SwingPropertyChangeSupport;

public class JDBCConnection
implements Connection {
    public static final String RB_KEY = "JDBCConnection.";
    protected boolean designTime = Util.isDesignTime();
    protected Connection connection;
    protected String driverName;
    protected String databaseURL;
    protected String user;
    protected String password;
    protected Properties connectionInfo;
    protected Class driverClass;
    protected Command loginCmd;
    protected SwingPropertyChangeSupport spcs = new SwingPropertyChangeSupport(this);

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "connectionInfo"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}, {{"Name", "autoCommit"}, {"Hidden", "true"}}, {{"Name", "closed"}, {"Hidden", "true"}}, {{"Name", "readOnly"}, {"Hidden", "true"}}, {{"Name", "metaData"}, {"Hidden", "true"}}, {{"Name", "catalog"}, {"Hidden", "true"}}, {{"Name", "typeMap"}, {"Hidden", "true"}}, {{"Name", "transactionIsolation"}, {"Hidden", "true"}}, {{"Name", "warnings"}, {"Hidden", "true"}}, {{"Name", "password"}, {"Masked", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "databaseURL";
        ebi.defaultOutputPropertyName = "databaseURL";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        String oldPassword = this.password;
        if (com.sas.util.Util.unequal((Object)oldPassword, (Object)password)) {
            this.password = password;
            this.spcs.firePropertyChange("password", oldPassword, password);
        }
    }

    public String getUsername() {
        return this.user;
    }

    public void setUsername(String username) {
        String oldUsername = this.user;
        if (com.sas.util.Util.unequal((Object)oldUsername, (Object)username)) {
            this.user = username;
            this.spcs.firePropertyChange("username", oldUsername, username);
        }
    }

    public Properties getConnectionInfo() {
        return this.connectionInfo;
    }

    public void setConnectionInfo(Properties info) {
        Properties oldConnectionInfo = this.connectionInfo;
        if (com.sas.util.Util.unequal((Object)oldConnectionInfo, (Object)info)) {
            this.connectionInfo = info;
            this.spcs.firePropertyChange("connectionInfo", oldConnectionInfo, info);
        }
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public void setDatabaseURL(String url) {
        String oldDatabaseURL = this.databaseURL;
        if (com.sas.util.Util.unequal((Object)oldDatabaseURL, (Object)url)) {
            this.databaseURL = url;
            this.spcs.firePropertyChange("databaseURL", oldDatabaseURL, url);
        }
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driver) throws ClassNotFoundException {
        String oldDriverName = this.driverName;
        if (com.sas.util.Util.unequal((Object)oldDriverName, (Object)driver)) {
            this.driverName = driver;
            this.driverClass = driver != null && !driver.equals("") ? Class.forName(driver) : null;
            this.spcs.firePropertyChange("driverName", oldDriverName, driver);
        }
    }

    public Command getLoginCommand() {
        return this.loginCmd;
    }

    public void setLoginCommand(Command command) {
        this.loginCmd = command;
    }

    protected Connection createConnection() throws SQLException {
        String dbURL;
        Command cmd = this.getLoginCommand();
        if (cmd != null) {
            cmd.execute((Object)this);
        }
        if ((dbURL = this.getDatabaseURL()) == null) {
            return null;
        }
        if (this.driverClass == null) {
            try {
                this.driverClass = Class.forName(this.getDriverName());
            }
            catch (ClassNotFoundException e) {
                throw new ComponentException((Throwable)e);
            }
        }
        String user = this.getUsername();
        String password = this.getPassword();
        Properties info = this.getConnectionInfo();
        if (info != null && info.size() > 0) {
            return DriverManager.getConnection(dbURL, info);
        }
        if (password != null || com.sas.util.Util.unequal((Object)password, (Object)"") || user != null || com.sas.util.Util.unequal((Object)user, (Object)"")) {
            return DriverManager.getConnection(dbURL, user, password);
        }
        return DriverManager.getConnection(dbURL);
    }

    public void resetConnection() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.connection = null;
    }

    public Connection getConnection() throws SQLException {
        if (this.designTime) {
            return null;
        }
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        return this.connection;
    }

    @Override
    public Statement createStatement() throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.prepareStatement(sql, columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.getConnection().setAutoCommit(autoCommit);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return false;
        }
        return connection.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.getConnection().commit();
        }
    }

    @Override
    public void rollback() throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.getConnection().rollback();
        }
    }

    @Override
    public void close() throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.getConnection().close();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return true;
        }
        return connection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.getConnection().setReadOnly(readOnly);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return true;
        }
        return connection.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.getConnection().setCatalog(catalog);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.getConnection().setTransactionIsolation(level);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return 0;
        }
        return connection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.getConnection().clearWarnings();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public Map getTypeMap() throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.getTypeMap();
    }

    public void setTypeMap(Map typeMap) throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.getConnection().setTypeMap(typeMap);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.getConnection().setHoldability(holdability);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return 1;
        }
        return connection.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        return connection.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.getConnection().rollback(savepoint);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.getConnection().releaseSavepoint(savepoint);
        }
    }

    private static SQLException throwUnsupportedException() {
        return new SQLException(RB.getStringResource(RB_KEY, "methodNotSupported.ex.txt"));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw JDBCConnection.throwUnsupportedException();
    }
}

