/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.flattened.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASMDX.DataType;
import com.sas.storage.olap.OLAPUtil;
import java.util.Arrays;
import java.util.List;

@SASScope
class Row {
    List formattedList;
    int[] dataTypes;
    List rawList;
    int cellValueFormat;
    int index;

    public Row(int rowIndex, int cellValueFormat, String[] formattedValues, int[] dataTypes, List rawList) {
        this.index = rowIndex;
        this.formattedList = Arrays.asList(formattedValues);
        this.cellValueFormat = cellValueFormat;
        this.dataTypes = dataTypes;
        this.rawList = rawList;
    }

    public Row(int rowIndex, int cellValueFormat, String[] formattedValues, DataType[] dataTypes, List rawList) {
        this.index = rowIndex;
        this.formattedList = Arrays.asList(formattedValues);
        this.cellValueFormat = cellValueFormat;
        this.rawList = rawList;
    }

    Object[] getValues(int columnIndex, int count) {
        if (this.cellValueFormat == 0 || this.cellValueFormat == 2) {
            return this.rawList.subList(columnIndex - 1, columnIndex + count - 1).toArray();
        }
        return OLAPUtil.EMPTY_OBJECT_ARRAY;
    }

    String[] getFormattedValues(int columnIndex, int count) {
        if (this.cellValueFormat == 1 || this.cellValueFormat == 2) {
            return this.formattedList.subList(columnIndex - 1, columnIndex + count - 1).toArray(OLAPUtil.EMPTY_STRING_ARRAY);
        }
        return OLAPUtil.EMPTY_STRING_ARRAY;
    }
}

