/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.flattened.sasmdx;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.DoubleSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfLongHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfOctetHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.iom.SASMDX.CellValueFormat;
import com.sas.iom.SASMDX.IFlatDataSet;
import com.sas.iom.SASMDX.IFlatDataSet_1_2;
import com.sas.iom.SASMDX.IFlatDataSet_1_2Helper;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.IMDXServerHelper;
import com.sas.iom.SASMDX.ISession;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import com.sas.storage.flattened.sasmdx.FlattenResultSetMetadata;
import com.sas.storage.flattened.sasmdx.RB;
import com.sas.storage.flattened.sasmdx.Row;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;

@SASScope(value="ALL")
public class FlattenResultSet
implements ResultSet {
    @SASScope
    public static final String RB_KEY = "FlattenResultSet.";
    private String queryStatement;
    private int numRows;
    private IMDXServer _connection;
    private ISession _session;
    private String host;
    private int port;
    private String username;
    private String password;
    private List rowsList;
    private int cellValueFormat;
    private int currentRow;
    private ResultSetMetaData flatMetadata;
    public static final int FORMAT_RAW = 0;
    public static final int FORMAT_FORMATTED = 1;
    public static final int FORMAT_RAWANDFORMATTED = 2;
    public static final int FORMAT_RAWNOEMPTY = 3;
    public static final int FORMAT_FORMATTEDNOEMPTY = 4;
    public static final int FORMAT_RAWANDFORMATTEDNOEMPTY = 5;
    private static final Double NaN = Double.NaN;

    public FlattenResultSet(String host, int port, String query) throws SQLException {
        this(host, port, "", "", query);
    }

    public FlattenResultSet(String host, int port, String userName, String password, String query) throws SQLException {
        this(host, port, userName, password, query, 1);
    }

    public FlattenResultSet(String host, int port, String userName, String password, String query, int cellFormat) throws SQLException {
        this.host = host;
        this.port = port;
        this.queryStatement = query;
        this.username = userName;
        this.password = password;
        this.cellValueFormat = cellFormat;
        this.rowsList = new ArrayList();
        if (this.queryStatement == null) {
            this.setQueryStatement(this.queryStatement);
        } else {
            this.executeQuery(this.queryStatement);
        }
    }

    public FlattenResultSet(IMDXServer connection, String query, int cellFormat) throws SQLException {
        try {
            this._connection = connection;
            this.cellValueFormat = cellFormat;
            if (this._connection != null) {
                Locale defaultLocale = Locale.getDefault();
                this._session = this._connection.CreateSession(defaultLocale.toString());
            }
            this.queryStatement = query;
            if (this.queryStatement == null) {
                this.setQueryStatement(this.queryStatement);
            } else {
                this.executeQuery(this.queryStatement);
            }
        }
        catch (Exception e) {
            throw new SQLException();
        }
    }

    public FlattenResultSet(ISession session, String query, int cellFormat) throws SQLException {
        try {
            this._session = session;
            this.cellValueFormat = cellFormat;
            this.queryStatement = query;
            if (this.queryStatement == null) {
                this.setQueryStatement(this.queryStatement);
            } else {
                this.executeQuery(this.queryStatement);
            }
        }
        catch (Exception e) {
            throw new SQLException();
        }
    }

    public void setQueryStatement(String query) throws SQLException {
        this.queryStatement = query;
    }

    public String getQueryStatement() throws SQLException {
        return this.queryStatement;
    }

    public void executeQuery(String queryStatement) throws SQLException {
        try {
            if (this._session == null) {
                this.establishConnection();
            }
            IntHolder _numRows = new IntHolder();
            IFlatDataSet_1_2 _flatDataSet = IFlatDataSet_1_2Helper.narrow((Object)this._session.MDXQueryFlat(queryStatement, _numRows));
            this.numRows = _numRows.value;
            if (this.numRows > 0) {
                int startRow = 0;
                VariableArray2dOfLongHolder dataTypes = new VariableArray2dOfLongHolder();
                VariableArray2dOfStringHolder formattedValues = new VariableArray2dOfStringHolder();
                VariableArray2dOfOctetHolder missing = new VariableArray2dOfOctetHolder();
                LongSeqHolder longValues = new LongSeqHolder();
                StringSeqHolder stringValues = new StringSeqHolder();
                DoubleSeqHolder doubleValues = new DoubleSeqHolder();
                VariableArray2dOfStringHolder formatStrings = new VariableArray2dOfStringHolder();
                int nRead = _flatDataSet.ReadRows_2(startRow, this.numRows, CellValueFormat.from_int((int)this.cellValueFormat), formattedValues, dataTypes, missing, doubleValues, stringValues, longValues, formatStrings);
                this.flatMetadata = new FlattenResultSetMetadata((IFlatDataSet)_flatDataSet, this.cellValueFormat, startRow < nRead ? formatStrings.value[startRow] : null);
                int sv = 0;
                int dv = 0;
                int iv = 0;
                this.rowsList = new ArrayList(nRead);
                for (int i = startRow; i < nRead; ++i) {
                    ArrayList<java.lang.Object> rawList = new ArrayList<java.lang.Object>();
                    for (int j = 0; j < dataTypes.value[i].length; ++j) {
                        if (this.cellValueFormat != 2 && this.cellValueFormat != 0) continue;
                        if (dataTypes.value[i][j] == 1) {
                            rawList.add(stringValues.value[sv++]);
                            continue;
                        }
                        if (dataTypes.value[i][j] == 2) {
                            rawList.add(doubleValues.value[dv++]);
                            continue;
                        }
                        if (dataTypes.value[i][j] == 3) {
                            rawList.add(longValues.value[iv++]);
                            continue;
                        }
                        if (dataTypes.value[i][j] != 0) continue;
                        int columnType = this.flatMetadata.getColumnType(j + 1);
                        if (columnType == 8) {
                            rawList.add(NaN);
                            continue;
                        }
                        if (columnType != 1) continue;
                        rawList.add("");
                    }
                    Row r = new Row(i, this.cellValueFormat, formattedValues.value[i], dataTypes.value[i], rawList);
                    this.rowsList.add(i, r);
                }
                this.currentRow += nRead;
            } else {
                this.flatMetadata = new FlattenResultSetMetadata((IFlatDataSet)_flatDataSet, this.cellValueFormat, new String[0]);
            }
        }
        catch (GenericError e) {
            String msg = this.extractMessage(e);
            throw new SQLException(msg);
        }
        catch (Exception e) {
            throw new SQLException(OLAPUtil.getExceptionMessage(e));
        }
    }

    private String extractMessage(GenericError ge) {
        String msg = ge.getMessage();
        Throwable cause = ge.getCause();
        while (cause != null && cause instanceof GenericError) {
            String newMsg = ((GenericError)cause).ErrorText;
            if (msg.indexOf(newMsg) < 0) {
                msg = msg + "\n" + newMsg;
            }
            cause = ((GenericError)cause).getCause();
        }
        return msg;
    }

    public void executeQuery() throws SQLException {
        this.executeQuery(this.queryStatement);
    }

    @SASScope
    protected void establishConnection() throws OLAPException {
        try {
            if (this._session != null) {
                return;
            }
            if (this._connection == null && this.host != null && this.port > 0) {
                String classID = "f3f46472-1e31-11d5-87c2-00c04f38f9f6";
                BridgeServer server = new BridgeServer(classID, this.host, this.port);
                ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)server);
                ConnectionFactoryInterface cxf = ConnectionFactoryManager.getConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
                ConnectionInterface cx = cxf.getConnection(this.username, this.password);
                Object obj = cx.getObject();
                this._connection = IMDXServerHelper.narrow((Object)obj);
            }
            if (this._connection != null) {
                Locale defaultLocale = Locale.getDefault();
                this._session = this._connection.CreateSession(defaultLocale.toString());
            }
        }
        catch (Exception ex) {
            throw new OLAPException(ex, OLAPUtil.getExceptionMessage(ex));
        }
    }

    private boolean isCurrentRowValid() {
        if (this.currentRow <= 0) {
            this.currentRow = 0;
        } else if (this.currentRow > this.numRows) {
            this.currentRow = this.numRows + 1;
        }
        return this.currentRow > 0 && this.numRows > 0 && this.currentRow <= this.numRows;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.numRows > 0 && this.currentRow == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.numRows > 0 && this.currentRow == this.numRows + 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.numRows > 0 && this.currentRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.currentRow == this.numRows;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.numRows > 0) {
            this.currentRow = 0;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.numRows > 0) {
            this.currentRow = this.numRows + 1;
        }
    }

    @Override
    public boolean first() throws SQLException {
        if (this.numRows > 0) {
            this.currentRow = 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.numRows > 0) {
            this.currentRow = this.numRows;
            return true;
        }
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        return this.numRows > 0 && this.currentRow > 0 ? this.currentRow : 0;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.currentRow = row < 0 ? this.numRows + row : row;
        return this.isCurrentRowValid();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.currentRow += rows;
        return this.isCurrentRowValid();
    }

    @Override
    public boolean previous() throws SQLException {
        --this.currentRow;
        return this.isCurrentRowValid();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateObject(int columnIndex, java.lang.Object x, int scale) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateObject(int columnIndex, java.lang.Object x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateObject(String columnName, java.lang.Object x, int scale) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateObject(String columnName, java.lang.Object x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    public java.lang.Object getObject(int i, Map map) throws SQLException {
        if (this.isCurrentRowValid()) {
            Row r = (Row)this.rowsList.get(this.currentRow - 1);
            return r.getValues(i, 1)[0];
        }
        return null;
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    public java.lang.Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findColumn(colName));
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public boolean next() throws SQLException {
        ++this.currentRow;
        return this.isCurrentRowValid();
    }

    @Override
    public void close() throws SQLException {
        if (this.flatMetadata != null && this.flatMetadata instanceof FlattenResultSetMetadata) {
            ((FlattenResultSetMetadata)this.flatMetadata).close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (this.isCurrentRowValid()) {
            Row r = (Row)this.rowsList.get(this.currentRow - 1);
            if (this.cellValueFormat == 1 || this.cellValueFormat == 2) {
                return r.getFormattedValues(columnIndex, 1)[0];
            }
            return r.getValues(columnIndex, 1)[0].toString();
        }
        return null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (this.isCurrentRowValid()) {
            Row r = (Row)this.rowsList.get(this.currentRow - 1);
            return (Integer)r.getValues(columnIndex, 1)[0];
        }
        return 0;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        if (this.isCurrentRowValid()) {
            Row r = (Row)this.rowsList.get(this.currentRow - 1);
            return ((Integer)r.getValues(columnIndex, 1)[0]).longValue();
        }
        return 0L;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        if (this.isCurrentRowValid()) {
            Row r = (Row)this.rowsList.get(this.currentRow - 1);
            return (Double)r.getValues(columnIndex, 1)[0];
        }
        return 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.flatMetadata;
    }

    @Override
    public java.lang.Object getObject(int columnIndex) throws SQLException {
        Row r = (Row)this.rowsList.get(this.currentRow - 1);
        return r.getValues(columnIndex, 1)[0];
    }

    @Override
    public java.lang.Object getObject(String columnName) throws SQLException {
        Row r = (Row)this.rowsList.get(this.currentRow - 1);
        return r.getValues(this.findColumn(columnName), 1)[0];
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return ((FlattenResultSetMetadata)this.flatMetadata).getColumnIndex(columnName);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    private static SQLException throwUnsupportedException() {
        return new SQLException(RB.getStringResource(RB_KEY, "methodNotSupported.ex.txt"));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw FlattenResultSet.throwUnsupportedException();
    }
}

