/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.editableproperties;

import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.RB;
import com.sas.text.Message;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class SectionedPropertyMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, PropertyMap> sections = new LinkedHashMap<String, PropertyMap>();
    private static final String RB_KEY = "SectionedPropertyMap.";
    private transient LoggerFactoryInterface loggerFactory = null;
    private transient CommonLoggerInterface logger = null;

    public int load(Reader reader) throws IOException {
        int errorCount = 0;
        LineNumberReader myreader = reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
        while (true) {
            int firstLine = myreader.getLineNumber() + 1;
            PropertyMap section = new PropertyMap();
            int sectionErrorCount = section.load(myreader, true);
            if (sectionErrorCount == -1) break;
            errorCount += sectionErrorCount;
            String name = section.sectionName;
            if (name == null) {
                name = "";
            }
            if (this.containsSection(name)) {
                ++errorCount;
                this.getLogger2().error(Message.format((String)RB.getStringResource(RB_KEY, "DuplicateSectionIgnored.fmt.log"), (Object)PropertyList.escapeString(null, null, name, 5), (Object)firstLine));
                continue;
            }
            this.sections.put(name, section);
        }
        return errorCount;
    }

    public boolean containsSection(String name) {
        return this.sections.containsKey(name);
    }

    public PropertyMap getSection(String name) {
        return this.sections.get(name);
    }

    public void removeSection(String name) {
        this.sections.remove(name);
    }

    public void setSection(String name, PropertyMap map) {
        this.sections.put(name, map);
    }

    public Collection<String> getSections() {
        return this.sections.keySet();
    }

    protected CommonLoggerInterface getLogger2() {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger(this.getClass().getName(), new Log4JFactory2());
        }
        return this.logger;
    }
}

