/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.editableproperties;

import com.sas.storage.editableproperties.LocalizedResourceBundle;
import com.sas.storage.editableproperties.SectionedPropertyMap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocalizedResourceBundleFactory {
    SectionedPropertyMap resources = new SectionedPropertyMap();
    Map<Locale, LocalizedResourceBundle> bundles;

    LocalizedResourceBundleFactory(Reader reader) throws IOException {
        this.resources.load(reader);
        this.bundles = new ConcurrentHashMap<Locale, LocalizedResourceBundle>();
    }

    public static LocalizedResourceBundleFactory getFactory(String localizationResources) {
        StringReader reader = new StringReader(localizationResources);
        LocalizedResourceBundleFactory factory = null;
        try {
            factory = LocalizedResourceBundleFactory.getFactory(reader);
            ((Reader)reader).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return factory;
    }

    public static LocalizedResourceBundleFactory getFactory(Reader reader) throws IOException {
        return new LocalizedResourceBundleFactory(reader);
    }

    public LocalizedResourceBundle getBundle(Locale locale) {
        if (this.bundles.containsKey(locale)) {
            return this.bundles.get(locale);
        }
        LocalizedResourceBundle bundle = new LocalizedResourceBundle(this, locale);
        this.bundles.put(locale, bundle);
        return bundle;
    }
}

