/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.util;

import com.sas.prompts.util.PromptContentHandler;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class HandlePromptLocalizableProperties {
    public static final String APPLY = "APPLY";
    public static final String EXTRACT = "EXTRACT";

    public static void main(String[] args) throws SAXException, IOException {
        if (null == args || null == args[0]) {
            throw new IOException("The arguments array was null or the required first argument was null. ");
        }
        if (args.length < 4) {
            throw new IOException("The arguments array does not contain the required second or third arguments. ");
        }
        Locale locale = null;
        String fileName = args[1];
        String propertyFile = args[2];
        String locString = args[3];
        String outFile = null;
        if (args.length > 4) {
            outFile = args[4];
        }
        locale = HandlePromptLocalizableProperties.getLocale(locString);
        if (null != fileName && null != propertyFile) {
            Log4JFactory2 loggerFactory = new Log4JFactory2();
            CommonLoggerInterface logger = LoggerRepository2.getLogger(HandlePromptLocalizableProperties.class.getName(), loggerFactory);
            if (logger.isInfoEnabled()) {
                logger.info("The action to take is " + args[0]);
                logger.info("The XML file name is " + fileName);
                logger.info("The properties file name is " + propertyFile);
                logger.info("The locale string is " + locString);
                logger.info("The output file is " + outFile);
            }
            if (EXTRACT.equals(args[0])) {
                HandlePromptLocalizableProperties.extractProperties(fileName, propertyFile, locale, loggerFactory, logger);
            } else if (APPLY.equals(args[0])) {
                if (null != outFile) {
                    PersistenceInterface retVal = HandlePromptLocalizableProperties.parseXML(fileName, loggerFactory);
                    HandlePromptLocalizableProperties.applyProperties(retVal, propertyFile, locale, loggerFactory, logger);
                    HandlePromptLocalizableProperties.writeOutputFile(retVal, outFile);
                } else {
                    logger.error("No output file parameter was supplied so no XML file was written.");
                }
            }
        } else {
            throw new IOException("The file name and/or output destination arguments were null. ");
        }
    }

    private static void writeOutputFile(PersistenceInterface retVal, String outFile) throws SAXException, IOException {
        try {
            String xml = XmlUtil.promptModelToPrettyString(retVal);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");
            BufferedWriter out = new BufferedWriter(w);
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.newLine();
            out.write(xml);
            out.close();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage());
        }
        catch (BackingStoreException e) {
            throw new SAXException(e);
        }
    }

    private static void applyProperties(PersistenceInterface retVal, String dest, Locale locale, LoggerFactoryInterface loggerFactory, CommonLoggerInterface logger) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(dest), "UTF-8");
        if (null != reader) {
            PropertyMap map = new PropertyMap();
            int i = map.load(reader);
            ((Reader)reader).close();
            if (i != -1) {
                logger.debug("The property map was loaded with data.");
                if (retVal instanceof MultiLocaleProperties) {
                    MultiLocaleProperties prompt = (MultiLocaleProperties)((Object)retVal);
                    prompt.setLocalizableProperties(locale, map);
                }
            } else {
                logger.warn("No data was loaded into the property map.");
            }
        } else {
            logger.error("No file could be found or opened for reading: " + dest);
        }
    }

    private static Locale getLocale(String locString) {
        Locale locale = null;
        locale = XmlUtil.xmlToLocale(locString);
        return locale;
    }

    private static void extractProperties(String fileName, String dest, Locale locale, LoggerFactoryInterface loggerFactory, CommonLoggerInterface logger) throws SAXException, IOException {
        PersistenceInterface retVal = HandlePromptLocalizableProperties.parseXML(fileName, loggerFactory);
        if (retVal instanceof MultiLocaleProperties) {
            MultiLocaleProperties prompt = (MultiLocaleProperties)((Object)retVal);
            PropertyList list = null;
            list = null == locale ? prompt.getLocalizableProperties() : prompt.getLocalizableProperties(locale);
            if (null != dest && null != list) {
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(dest), "UTF-8");
                BufferedWriter writer = new BufferedWriter(w);
                list.save(writer);
                logger.info("The PropertyList was saved to the destination.");
                writer.close();
            }
        } else {
            throw new SAXException("The parsed prompt was not an instance of MultiLocaleProperties. No PropertyList can be returned.");
        }
    }

    private static PersistenceInterface parseXML(String fileName, LoggerFactoryInterface loggerFactory) throws SAXException, IOException {
        PersistenceInterface retVal = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        InputStreamReader fis = new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8");
        if (null != fis) {
            PromptsReadingContext rc = PersistenceFactory.newReadingContext(loggerFactory);
            PromptContentHandler handler = PromptContentHandler.newHandler2(loggerFactory, rc);
            if (null != handler) {
                SAXParser parser;
                try {
                    parser = factory.newSAXParser();
                }
                catch (ParserConfigurationException e) {
                    throw new SAXException(e);
                }
                InputSource source = new InputSource(fis);
                parser.parse(source, (DefaultHandler)handler);
                retVal = handler.getObject();
            }
            fis.close();
        }
        if (null == retVal) {
            throw new SAXException("No prompt object was found within the supplied XML.");
        }
        return retVal;
    }
}

