/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.datatypes.DataTypeInterface;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public abstract class SimplePersistedValue
extends BasePersistedValue {
    protected abstract DataTypeInterface getDataType();

    protected String getValueAsString(Object value) {
        return this.getDataType().getPersistanceString(value);
    }

    protected Object coerceValueFromString(String text) {
        return this.getDataType().coerceValueFromPersistedString(text);
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String valueAsText = provider.consumeAttr("value");
        this.setValue(this.coerceValueFromString(valueAsText));
        this.getLogger2().debug("consumeAttributes() ");
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getValue()) {
            this.getLogger2().debug("writeDefinition(), Writing a value.");
            super.writeDefinition(element, writingContext);
            String valueAsText = this.getValueAsString(this.getValue());
            XmlUtil.setAttr(element, "value", valueAsText);
        } else {
            this.getLogger2().debug("writeDefinition(): No value to write");
        }
    }
}

