/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.datatypes.OLAPMemberNameType;
import com.sas.models.OLAPMemberName;
import com.sas.models.OLAPMemberNameInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.DataSourceValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.LocalizedText;
import com.sas.util.xmlpersist.impl.PersistHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OLAPMemberNameValue
extends BasePersistedValue {
    @Override
    public String getDefinitionElementName() {
        return "OLAPMemberName";
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        OLAPMemberName olapMemberName = (OLAPMemberName)this.getValue();
        ArrayList list2 = roHolder.consumeObjects("Label");
        if (!list2.isEmpty()) {
            for (LocalizedText text : list2) {
                olapMemberName.setLabel(text.getText(), text.getLocale());
            }
        }
        if (!(list2 = roHolder.consumeObjects("DataSource")).isEmpty()) {
            for (DataSourceValue dataSource : list2) {
                olapMemberName.setDataSource((DataSourceInterface)dataSource.getValue());
            }
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        String uniqueMemberName = provider.consumeAttr("uniqueMemberName");
        OLAPMemberName memberName = new OLAPMemberName();
        memberName.setUniqueName(uniqueMemberName);
        this.setValue(memberName);
        this.getLogger2().debug("consumeAttributes(), value was set to:", OLAPMemberNameType.DEFAULT_INSTANCE.getDisplayString((Object)memberName, Locale.US));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getValue()) {
            super.writeDefinition(element, writingContext);
            OLAPMemberNameInterface olapMember = (OLAPMemberNameInterface)this.getValue();
            XmlUtil.setAttr(element, "uniqueMemberName", olapMember.getUniqueName());
            List list = PersistHelper.getAllText(olapMember.getLabel(), null);
            if (!list.isEmpty()) {
                this.getLogger2().debug("Writing labels.");
                OLAPMemberNameValue.writeRelatedObjects(list, element, writingContext, "Label");
            }
            ArrayList<PersistenceInterface> valueObjects = new ArrayList<PersistenceInterface>();
            if (olapMember.getDataSource() != null) {
                PersistenceInterface itemValue = ValueUtil.getPersistableValue(olapMember.getDataSource());
                valueObjects.add(itemValue);
                OLAPMemberNameValue.writeRelatedObjects(valueObjects, element, writingContext, "DataSource");
            }
        } else {
            this.getLogger2().debug("No value to write");
        }
    }
}

